/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.generatedforms2.ui;

import de.aristaflow.adept2.extensions.generatedforms2.ui.Activator;
import de.aristaflow.adept2.extensions.generatedforms2.ui.GeneratedFormsWizard;
import de.aristaflow.adept2.ui.statushandling.StatusTools;
import de.aristaflow.adept2.util.Base64;
import de.aristaflow.adept2.util.FileTools;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import net.miginfocom.swt.MigLayout;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

class FormImageWizardPage
extends WizardPage {
    public static final String PAGE_NAME = "de.aristaflow.form.GeneratedForm#image";
    public static final String ATC_IMAGE = "Image";
    private static final int MAX_PREVIEW_SIZE = 150;
    GeneratedFormsWizard pageSet;
    private CLabel imageContainer;
    private Image image;

    public FormImageWizardPage(GeneratedFormsWizard wizard) {
        super(PAGE_NAME);
        this.pageSet = wizard;
        this.setTitle("Form: Image");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new MigLayout("wrap", "[grow][]"));
        this.setMessage("Select an image to be displayed in the form");
        Button loadImageButton = new Button(composite, 0);
        loadImageButton.setText("Load image...");
        loadImageButton.setLayoutData((Object)"right");
        loadImageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fidi = new FileDialog(FormImageWizardPage.this.getShell(), 4096);
                if (fidi.open() != null) {
                    String filePath = String.valueOf(fidi.getFilterPath()) + File.separator + fidi.getFileName();
                    FormImageWizardPage.this.loadImageFromFile(filePath);
                }
            }
        });
        Button removeImageButton = new Button(composite, 0);
        removeImageButton.setText("Remove image");
        removeImageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormImageWizardPage.this.removeImage();
            }
        });
        Label separater = new Label(composite, 258);
        separater.setLayoutData((Object)"growx, spanx");
        Label imageLabel = new Label(composite, 0);
        imageLabel.setText("Thumbnail preview:");
        imageLabel.setLayoutData((Object)"spanx");
        this.imageContainer = new CLabel(composite, 0);
        this.imageContainer.setLayoutData((Object)"spanx, grow, gapx 10lp");
        this.reloadData();
        this.setControl((Control)composite);
    }

    void loadImageFromFile(String filename) {
        block6: {
            Closeable fis = null;
            try {
                try {
                    byte[] rawImage = FileTools.toByteArray((File)new File(filename));
                    boolean success = this.setImage(rawImage);
                    if (!success) break block6;
                    if (rawImage == null) {
                        this.pageSet.getData().getConfiguration().remove(ATC_IMAGE);
                        break block6;
                    }
                    String imageString = Base64.encodeBytes((byte[])rawImage, (int)2);
                    this.pageSet.getData().getConfiguration().setString(ATC_IMAGE, imageString);
                }
                catch (IOException ex) {
                    String msg = "The image file could not be loaded!";
                    StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)msg, (Throwable)ex);
                    FileTools.closeQuietly(fis);
                }
            }
            finally {
                FileTools.closeQuietly(fis);
            }
        }
    }

    private void loadImageDataFromATC() {
        String imageString = this.pageSet.getData().getConfiguration().getString(ATC_IMAGE);
        if (imageString == null) {
            this.setImage(null);
        } else {
            byte[] imageBytes = Base64.decode((String)imageString);
            try {
                this.setImage(imageBytes);
            }
            catch (SWTException ex) {
                String msg = "The image could not be loaded from the activity type configuration!";
                StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)msg, (Throwable)ex);
            }
        }
    }

    void removeImage() {
        this.pageSet.getData().getConfiguration().remove(ATC_IMAGE);
    }

    boolean setImage(byte[] rawImage) {
        if (this.image != null) {
            this.image.dispose();
        }
        if (rawImage == null) {
            this.imageContainer.setImage(null);
            this.imageContainer.setText("<no image>");
            this.imageContainer.getParent().layout();
        } else {
            try {
                ImageData imageData = new ImageData((InputStream)new ByteArrayInputStream(rawImage));
                if (imageData.width > 150 || imageData.height > 150) {
                    float scale = imageData.width > imageData.height ? 150.0f / (float)imageData.width : 150.0f / (float)imageData.height;
                    imageData = imageData.scaledTo((int)((float)imageData.width * scale), (int)((float)imageData.height * scale));
                }
                this.image = new Image((Device)this.getShell().getDisplay(), imageData);
                this.imageContainer.setImage(this.image);
                this.imageContainer.setText(null);
                this.imageContainer.getParent().layout();
            }
            catch (SWTException ex) {
                String msg = "The image data could not be loaded!";
                StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)msg, (Throwable)ex);
                this.imageContainer.setImage(null);
                this.imageContainer.setText("<no image>");
                this.imageContainer.getParent().layout();
                return false;
            }
        }
        return true;
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
        }
        super.dispose();
    }

    private void commit() {
        this.updateCompleteStatus();
        this.saveData();
    }

    private void updateCompleteStatus() {
        boolean complete = true;
        this.setPageComplete(complete);
    }

    void reloadData() {
        this.loadImageDataFromATC();
    }

    private void saveData() {
    }
}

