/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui;

import de.aristaflow.adept2.base.licensing.LicenceManager;
import de.aristaflow.adept2.base.security.Authentication;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.ClientSessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.client.ClientBootstrap;
import de.aristaflow.adept2.core.client.ClientService;
import de.aristaflow.adept2.model.common.LicenceInformation;
import de.aristaflow.adept2.ui.login.Activator;
import de.aristaflow.adept2.ui.statushandling.WhiteErrorDialogue;
import de.aristaflow.adept2.ui.util.FontTools;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.splash.AbstractSplashHandler;

public abstract class AbstractConnectSplashScreen
extends AbstractSplashHandler {
    ResourceBundle messages;
    Label progressLabel;
    ProgressBar progressBar;
    private Button cancelButton;
    Boolean connected;
    Exception exception;

    public void init(Shell splash) {
        block15: {
            super.init(splash);
            this.messages = ResourceBundle.getBundle("de.aristaflow.adept2.ui.login.LDBundle");
            splash.setLayout((Layout)new FillLayout());
            splash.setBackgroundMode(2);
            Composite infoArea = new Composite((Composite)splash, 0);
            infoArea.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 0).create());
            infoArea.setBackgroundMode(2);
            new Label(infoArea, 0).setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
            Composite progressInfoArea = new Composite(infoArea, 0);
            progressInfoArea.setLayoutData((Object)GridDataFactory.fillDefaults().create());
            progressInfoArea.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).margins(5, 3).spacing(0, 4).create());
            progressInfoArea.setBackgroundMode(2);
            Composite progressBarContainer = new Composite(progressInfoArea, 0);
            progressBarContainer.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).hint(-1, 15).grab(true, false).create());
            progressBarContainer.setLayout((Layout)new FillLayout());
            progressBarContainer.setBackgroundMode(2);
            this.progressBar = new ProgressBar(progressBarContainer, 2);
            this.progressLabel = new Label(progressInfoArea, 0);
            this.progressLabel.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).create());
            final ClientBootstrap[] clientBootstrap = new ClientBootstrap[1];
            final Thread bootThread = new Thread(){
                private boolean interrupted;

                @Override
                public void interrupt() {
                    this.interrupted = true;
                    super.interrupt();
                }

                @Override
                public void run() {
                    block2: {
                        try {
                            clientBootstrap[0] = ClientBootstrap.load();
                            AbstractConnectSplashScreen.this.connected = !this.interrupted;
                        }
                        catch (Exception ex) {
                            AbstractConnectSplashScreen.this.connected = Boolean.FALSE;
                            if (this.interrupted) break block2;
                            AbstractConnectSplashScreen.this.exception = ex;
                        }
                    }
                    AbstractConnectSplashScreen.this.getSplash().getDisplay().wake();
                }
            };
            this.cancelButton = new Button(progressInfoArea, 0x800000);
            this.cancelButton.setLayoutData((Object)GridDataFactory.fillDefaults().create());
            this.cancelButton.setText(this.messages.getString("CancelBtn"));
            this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    bootThread.interrupt();
                    AbstractConnectSplashScreen.this.progressLabel.setText(AbstractConnectSplashScreen.this.messages.getString("AFCSSCancelling"));
                }
            });
            splash.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 27) {
                        bootThread.interrupt();
                        AbstractConnectSplashScreen.this.progressLabel.setText(AbstractConnectSplashScreen.this.messages.getString("AFCSSCancelling"));
                    }
                }
            });
            Composite licenceInfoArea = new Composite(infoArea, 0);
            licenceInfoArea.setLayoutData((Object)GridDataFactory.fillDefaults().create());
            licenceInfoArea.setBackground(splash.getDisplay().getSystemColor(17));
            licenceInfoArea.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(1, 1).create());
            CLabel licencedTo = new CLabel(licenceInfoArea, 0x1000004);
            licencedTo.setLayoutData((Object)GridDataFactory.fillDefaults().hint(0, -1).grab(true, true).align(4, 0x1000000).create());
            licencedTo.setBackground(licencedTo.getDisplay().getSystemColor(25));
            FontTools.changeFont((Control)licencedTo, (int)-1, (int)-1);
            Rectangle bounds = splash.getBounds();
            bounds.height += licencedTo.computeSize((int)-1, (int)-1).y;
            splash.setBounds(bounds);
            this.progressLabel.setText(this.messages.getString("AFCSSConnecting"));
            bootThread.start();
            while (this.connected == null) {
                if (this.getSplash().getDisplay().readAndDispatch()) continue;
                if (this.connected != null) break;
                this.getSplash().getDisplay().sleep();
            }
            try {
                bootThread.join();
            }
            catch (InterruptedException interruptedException) {}
            this.progressBar.dispose();
            if (!this.connected.booleanValue()) {
                if (this.exception != null) {
                    WhiteErrorDialogue.openError((Shell)this.getSplash(), (String)this.messages.getString("AFCSSConFailedTtl"), (String)this.messages.getString("AFCSSConFailedMsg"), (Throwable)this.exception);
                }
                this.getSplash().getDisplay().close();
            } else {
                this.progressBar = new ProgressBar(progressBarContainer, 0);
                progressBarContainer.layout();
                this.cancelButton.setEnabled(false);
            }
            if (clientBootstrap[0] != null) {
                try {
                    ClientService service = clientBootstrap[0].getClientService();
                    Authentication authentication = service.getAuthentication();
                    ClientSessionFactory[] clientSessionFactories = this.getClientSessionFactories(authentication);
                    if (clientSessionFactories != null) {
                        service.setAuthenticatedAgents(clientSessionFactories);
                        Activator.setService(service);
                        Activator.setBootstrap(clientBootstrap[0]);
                        String licensee = "N/A";
                        String licenceType = "N/A";
                        try {
                            SessionToken session = service.getSessionToken();
                            LicenceManager licMan = service.getLicenceManager();
                            LicenceInformation licInf = licMan.getLicenceInformation(session);
                            licensee = licInf.getLicensee();
                            licenceType = licInf.getLicenceType();
                            if (!Character.isUpperCase(licenceType.charAt(0))) {
                                licenceType = String.valueOf(licenceType.substring(0, 1).toUpperCase()) + licenceType.substring(1);
                            }
                        }
                        catch (ServiceNotKnownException serviceNotKnownException) {
                        }
                        catch (RuntimeException runtimeException) {}
                        String msg = String.format(this.messages.getString("AFCSSLicence"), licenceType, licensee);
                        licencedTo.setText(msg.replace("&", "&&"));
                        break block15;
                    }
                    this.getSplash().getDisplay().close();
                }
                catch (ServiceNotKnownException snke) {
                    WhiteErrorDialogue.openError((Shell)this.getSplash(), (String)this.messages.getString("AFCSSInitFailedTtl"), (String)this.messages.getString("AFCSSInitFailedMsg"), (Throwable)snke);
                    this.getSplash().getDisplay().close();
                }
            }
        }
    }

    protected abstract ClientSessionFactory[] getClientSessionFactories(Authentication var1);

    public IProgressMonitor getBundleProgressMonitor() {
        return new IProgressMonitor(){
            int worked = 1;
            {
                AbstractConnectSplashScreen.this.getSplash().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).AbstractConnectSplashScreen.this.progressBar.isDisposed()) {
                            return;
                        }
                        (this).AbstractConnectSplashScreen.this.progressBar.setSelection(worked);
                    }
                });
            }

            public void beginTask(final String name, final int totalWork) {
                AbstractConnectSplashScreen.this.getSplash().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).AbstractConnectSplashScreen.this.progressBar.isDisposed()) {
                            return;
                        }
                        (this).AbstractConnectSplashScreen.this.progressBar.setMaximum(totalWork + 1);
                        (this).AbstractConnectSplashScreen.this.progressLabel.setText(name);
                        (this).AbstractConnectSplashScreen.this.progressLabel.update();
                    }
                });
            }

            public void done() {
            }

            public void internalWorked(double work) {
            }

            public boolean isCanceled() {
                return false;
            }

            public void setCanceled(boolean value) {
            }

            public void setTaskName(final String name) {
                AbstractConnectSplashScreen.this.getSplash().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).AbstractConnectSplashScreen.this.progressLabel.isDisposed()) {
                            return;
                        }
                        (this).AbstractConnectSplashScreen.this.progressLabel.setText(name);
                        (this).AbstractConnectSplashScreen.this.progressLabel.update();
                    }
                });
            }

            public void subTask(final String name) {
                AbstractConnectSplashScreen.this.getSplash().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).AbstractConnectSplashScreen.this.progressLabel.isDisposed()) {
                            return;
                        }
                        (this).AbstractConnectSplashScreen.this.progressLabel.setText(name);
                        (this).AbstractConnectSplashScreen.this.progressLabel.update();
                    }
                });
            }

            public void worked(int work) {
                this.worked += work;
                AbstractConnectSplashScreen.this.getSplash().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).AbstractConnectSplashScreen.this.progressBar.isDisposed()) {
                            return;
                        }
                        (this).AbstractConnectSplashScreen.this.progressBar.setSelection(worked);
                    }
                });
            }
        };
    }
}

