/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui;

import de.aristaflow.adept2.base.security.Authentication;
import de.aristaflow.adept2.base.security.AuthenticationException;
import de.aristaflow.adept2.base.sessionmanagement.ClientSessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.ui.AbstractConnectSplashScreen;
import de.aristaflow.adept2.ui.login.LoginDialogue;
import de.aristaflow.adept2.util.ConfigurationTools;
import de.aristaflow.adept2.util.DataSourceException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.eclipse.core.runtime.Platform;

public class LoginSplashScreen
extends AbstractConnectSplashScreen {
    private String username = null;
    private String password = null;
    private Boolean changeCred = null;
    private Boolean selectOP = null;
    private Boolean singleOPSelection = null;
    private boolean autoLogin = false;

    public LoginSplashScreen() {
        this.parseParameters();
    }

    @Override
    protected ClientSessionFactory[] getClientSessionFactories(Authentication authentication) {
        ClientSessionFactory[] ret = null;
        boolean authenticated = false;
        if (this.autoLogin) {
            try {
                List qas = authentication.authenticate(this.username, this.password);
                ret = new ClientSessionFactory[qas.size()];
                int i = 0;
                for (QualifiedAgent qa : qas) {
                    ret[i++] = authentication.authenticate(qa.getAgentID(), qa.getOrgPositionID(), this.password);
                }
                authenticated = true;
            }
            catch (AuthenticationException authenticationException) {
            }
            catch (DataSourceException dataSourceException) {}
        }
        if (!authenticated) {
            LoginDialogue dialogue = new LoginDialogue(this.getSplash(), authentication, this.messages.getString("AFCSSAppName"));
            if (this.username != null) {
                dialogue.setInitialUserName(this.username);
            }
            if (this.password != null) {
                dialogue.setInitialPassword(this.password);
            }
            if (this.changeCred != null) {
                dialogue.setChangeOrgPositionLoginMode(this.changeCred == false);
            }
            if (this.selectOP != null) {
                dialogue.setOrgPositionSelectionEnabled(this.selectOP);
            }
            if (this.singleOPSelection != null) {
                dialogue.setMultipleOrgPositionSelectionEnabled(this.singleOPSelection == false);
            }
            dialogue.open();
            if (dialogue.wasAuthenticationSuccessful()) {
                ret = dialogue.getClientSessionFactories();
            }
        }
        return ret;
    }

    protected void parseParameters() {
        InputStream demoCredentialsInput = ((Object)((Object)this)).getClass().getResourceAsStream("demoCredentials.properties");
        if (demoCredentialsInput != null) {
            try {
                PropertiesConfiguration demoCredentials = new PropertiesConfiguration();
                demoCredentials.load(demoCredentialsInput);
                if (ConfigurationTools.propertyValuePresent((Configuration)demoCredentials, (String)"UserName")) {
                    this.username = demoCredentials.getString("UserName");
                }
                if (ConfigurationTools.propertyValuePresent((Configuration)demoCredentials, (String)"Password")) {
                    this.password = demoCredentials.getString("Password");
                }
            }
            catch (ConfigurationException configurationException) {}
        }
        boolean uSet = false;
        boolean pSet = false;
        String[] args = Platform.getApplicationArgs();
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if ("-U".equals(arg) || "--username".equals(arg)) {
                this.username = args[++i];
                uSet = true;
            } else if ("-P".equals(arg) || "--password".equals(arg)) {
                this.password = args[++i];
                args[i] = "*****";
                pSet = true;
            } else if ("-CC".equals(arg) || "--changecredentials".equals(arg)) {
                this.changeCred = Boolean.TRUE;
            } else if ("-SOS".equals(arg) || "--selectorgpos".equals(arg)) {
                this.selectOP = Boolean.TRUE;
            } else if ("-SSOS".equals(arg) || "--selectsingleorgpos".equals(arg)) {
                this.selectOP = Boolean.TRUE;
                this.singleOPSelection = Boolean.TRUE;
            }
            ++i;
        }
        boolean bl = this.autoLogin = this.changeCred == null && this.selectOP == null && this.singleOPSelection == null && uSet && pSet;
        if (uSet && pSet && this.changeCred == null) {
            this.changeCred = Boolean.FALSE;
        }
        if (uSet && pSet && this.selectOP == null) {
            this.selectOP = Boolean.FALSE;
        }
        try {
            this.password = ConfigurationTools.parsePassword((String)this.password);
        }
        catch (GeneralSecurityException generalSecurityException) {}
    }
}

