/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.login;

import de.aristaflow.adept2.base.configuration.SystemProperties;
import de.aristaflow.adept2.base.security.AFCallbackHandler;
import de.aristaflow.adept2.base.security.Authentication;
import de.aristaflow.adept2.base.security.AuthenticationException;
import de.aristaflow.adept2.base.security.callbackhandler.NameOrgPosSesIDAppNameHandler;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.sessionmanagement.ClientSessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LoggerTools;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class LoginDialogue
extends Dialog {
    protected final Logger logger = LoggerTools.getLogger((Object)((Object)this));
    ResourceBundle messages;
    private String userName;
    private String password;
    private boolean orgPositionSelectionEnabled = true;
    private boolean multipleOrgPositionSelectionEnabled = true;
    private boolean changeOrgPositionLoginMode = false;
    private Mode mode = Mode.AUTHENTICATION;
    private boolean wasAuthenticationSuccessful = false;
    private ClientSessionFactory[] clientSessionFactories;
    private Text text_userName;
    private Text text_password;
    private Label label_orgPos;
    private Combo combo_orgPos;
    private ComboViewer comboViewer_orgPos;
    private Table table_orgPos;
    CheckboxTableViewer tableViewer_orgPos;
    private Label label_messageIndicator;
    private Label label_messageText;
    private Authentication authentication;
    private final String appName;
    private String userSessionID;

    public LoginDialogue(Shell parentShell, Authentication authentication, String appName) {
        super(parentShell);
        this.authentication = authentication;
        this.messages = ResourceBundle.getBundle("de.aristaflow.adept2.ui.login.LDBundle");
        this.appName = appName;
        if (SystemProperties.getOsName().toLowerCase().contains("windows")) {
            this.setShellStyle(this.getShellStyle() | 0x4000);
        }
    }

    public void setInitialUserName(String userName) {
        this.userName = userName;
    }

    public void setInitialPassword(String password) {
        this.password = password;
    }

    public void setOrgPositionSelectionEnabled(boolean enabled) {
        this.orgPositionSelectionEnabled = enabled;
    }

    public void setMultipleOrgPositionSelectionEnabled(boolean enabled) {
        this.multipleOrgPositionSelectionEnabled = enabled;
    }

    public void setUserSessionID(String userSessionID) {
        this.userSessionID = userSessionID;
    }

    public void setChangeOrgPositionLoginMode(boolean changeOrgPositionLoginMode) {
        if (changeOrgPositionLoginMode) {
            if (this.userName == null || this.password == null) {
                throw new IllegalStateException("changeOrgPositionLoginMode may only be true when both a user name and password have been set!");
            }
            this.changeOrgPositionLoginMode = true;
        } else {
            this.changeOrgPositionLoginMode = false;
        }
    }

    public String getUserName() {
        this.ensureAuthenticationSuccessful();
        return this.userName;
    }

    public String getPassword() {
        this.ensureAuthenticationSuccessful();
        return this.password;
    }

    public ClientSessionFactory getClientSessionFactory() {
        this.ensureAuthenticationSuccessful();
        return this.clientSessionFactories[0];
    }

    public ClientSessionFactory[] getClientSessionFactories() {
        this.ensureAuthenticationSuccessful();
        return (ClientSessionFactory[])this.clientSessionFactories.clone();
    }

    public boolean wasAuthenticationSuccessful() {
        return this.wasAuthenticationSuccessful;
    }

    private void ensureAuthenticationSuccessful() {
        if (!this.wasAuthenticationSuccessful()) {
            throw new IllegalStateException("Authentication wasn't successful!");
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        String title = this.messages.getString("LoginTitle");
        title = String.format(title, this.appName);
        if (title != null) {
            shell.setText(title);
        }
    }

    public void create() {
        super.create();
        if (this.changeOrgPositionLoginMode) {
            this.authenticate();
        } else {
            this.setMode(Mode.AUTHENTICATION);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        String[] okButtonPrototypes = new String[]{this.messages.getString("AuthenticateBtn"), this.messages.getString("LoginBtn")};
        String longestPrototype = "";
        String[] stringArray = okButtonPrototypes;
        int n = okButtonPrototypes.length;
        int n2 = 0;
        while (n2 < n) {
            String proto = stringArray[n2];
            if (proto.length() > longestPrototype.length()) {
                longestPrototype = proto;
            }
            ++n2;
        }
        this.createButton(parent, 0, longestPrototype, true);
        this.createButton(parent, 1, this.messages.getString("CancelBtn"), false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogueArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)dialogueArea.getLayout();
        layout.marginWidth = 20;
        layout.marginHeight = 15;
        layout.numColumns = 2;
        String[] prototypes = new String[]{this.messages.getString("UsernameLbl"), this.messages.getString("PasswordLbl"), this.messages.getString("OrgPosLbl"), this.messages.getString("OrgPosnLbl")};
        int preferredLeftColumnLabelWidth = 0;
        Label dummy = new Label(dialogueArea, 0);
        String[] stringArray = prototypes;
        int n = prototypes.length;
        int n2 = 0;
        while (n2 < n) {
            String prototype = stringArray[n2];
            dummy.setText(prototype);
            int width = dummy.computeSize((int)-1, (int)-1).x;
            if (width > preferredLeftColumnLabelWidth) {
                preferredLeftColumnLabelWidth = width;
            }
            ++n2;
        }
        dummy.dispose();
        Label label_userName = new Label(dialogueArea, 0);
        GridData layoutData = new GridData(4, 4, false, false);
        layoutData.verticalAlignment = 0x1000000;
        layoutData.widthHint = preferredLeftColumnLabelWidth;
        label_userName.setLayoutData((Object)layoutData);
        label_userName.setText(this.messages.getString("UsernameLbl"));
        this.text_userName = new Text(dialogueArea, 2052);
        layoutData = new GridData(4, 4, false, false);
        layoutData.widthHint = 200;
        this.text_userName.setLayoutData((Object)layoutData);
        this.text_userName.setTextLimit(30);
        if (this.userName != null) {
            this.text_userName.setText(this.userName);
            this.text_userName.selectAll();
        }
        this.text_userName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LoginDialogue.this.setMessage(LoginDialogue.this.messages.getString("LDMessage1"), false);
            }
        });
        this.text_userName.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                LoginDialogue.this.text_userName.selectAll();
            }
        });
        Label label_password = new Label(dialogueArea, 0);
        layoutData = new GridData(4, 4, false, false);
        layoutData.verticalAlignment = 0x1000000;
        layoutData.widthHint = preferredLeftColumnLabelWidth;
        label_password.setLayoutData((Object)layoutData);
        label_password.setText(this.messages.getString("PasswordLbl"));
        this.text_password = new Text(dialogueArea, 0x400804);
        layoutData = new GridData(4, 4, false, false);
        layoutData.widthHint = 200;
        this.text_password.setLayoutData((Object)layoutData);
        this.text_password.setTextLimit(50);
        this.text_password.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LoginDialogue.this.setMessage(LoginDialogue.this.messages.getString("LDMessage1"), false);
            }
        });
        this.text_password.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                LoginDialogue.this.text_password.selectAll();
            }
        });
        if (this.multipleOrgPositionSelectionEnabled) {
            this.label_orgPos = new Label(dialogueArea, 0);
            layoutData = new GridData(4, 4, false, false);
            layoutData.verticalAlignment = 128;
            layoutData.widthHint = preferredLeftColumnLabelWidth;
            layoutData.exclude = true;
            this.label_orgPos.setLayoutData((Object)layoutData);
            this.label_orgPos.setText(this.messages.getString("OrgPosnLbl"));
            this.label_orgPos.setVisible(false);
            this.table_orgPos = new Table(dialogueArea, 67616);
            layoutData = new GridData(4, 4, false, false);
            layoutData.exclude = true;
            this.table_orgPos.setLayoutData((Object)layoutData);
            this.table_orgPos.setVisible(false);
            this.tableViewer_orgPos = new CheckboxTableViewer(this.table_orgPos);
            this.tableViewer_orgPos.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.tableViewer_orgPos.setLabelProvider((IBaseLabelProvider)new OrgPositionLabelProvider());
            this.tableViewer_orgPos.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    if (LoginDialogue.this.tableViewer_orgPos.getCheckedElements().length == 0) {
                        LoginDialogue.this.setMessage(LoginDialogue.this.messages.getString("LDMessage6"), true);
                        LoginDialogue.this.getButton(0).setEnabled(false);
                    } else {
                        LoginDialogue.this.setMessage(LoginDialogue.this.messages.getString("LDMessage6"), false);
                        LoginDialogue.this.getButton(0).setEnabled(true);
                    }
                }
            });
        } else {
            this.label_orgPos = new Label(dialogueArea, 0);
            layoutData = new GridData(4, 4, false, false);
            layoutData.verticalAlignment = 0x1000000;
            layoutData.widthHint = preferredLeftColumnLabelWidth;
            layoutData.exclude = true;
            this.label_orgPos.setLayoutData((Object)layoutData);
            this.label_orgPos.setText(this.messages.getString("OrgPosLbl"));
            this.label_orgPos.setVisible(false);
            this.combo_orgPos = new Combo(dialogueArea, 12);
            layoutData = new GridData(4, 4, false, false);
            layoutData.exclude = true;
            this.combo_orgPos.setLayoutData((Object)layoutData);
            this.combo_orgPos.setVisible(false);
            this.comboViewer_orgPos = new ComboViewer(this.combo_orgPos);
            this.comboViewer_orgPos.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.comboViewer_orgPos.setLabelProvider((IBaseLabelProvider)new OrgPositionLabelProvider());
        }
        Label label_spacer = new Label(dialogueArea, 258);
        layoutData = new GridData(4, 4, false, false);
        layoutData.heightHint = 10;
        layoutData.horizontalSpan = 2;
        label_spacer.setLayoutData((Object)layoutData);
        Composite errorGroup = new Composite(dialogueArea, 0);
        layoutData = new GridData(4, 4, true, false);
        layoutData.horizontalSpan = 2;
        errorGroup.setLayoutData((Object)layoutData);
        GridLayout errorLayout = new GridLayout(2, false);
        errorLayout.marginWidth = 0;
        errorLayout.marginHeight = 0;
        errorGroup.setLayout((Layout)errorLayout);
        this.label_messageIndicator = new Label(errorGroup, 0);
        this.label_messageIndicator.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"));
        layoutData = new GridData(4, 4, false, false);
        layoutData.verticalAlignment = 128;
        this.label_messageIndicator.setLayoutData((Object)layoutData);
        this.label_messageText = new Label(errorGroup, 64);
        layoutData = new GridData(4, 4, true, false);
        layoutData.widthHint = 200;
        this.label_messageText.setLayoutData((Object)layoutData);
        this.label_messageText.setText("This is just a dummy text. This is just a dummy text.");
        if (this.password != null) {
            this.text_password.setText(this.password);
        }
        return dialogueArea;
    }

    private List<QualifiedAgent> getSelectedOrgPositions() {
        if (this.multipleOrgPositionSelectionEnabled) {
            Object[] elements = this.tableViewer_orgPos.getCheckedElements();
            ArrayList<QualifiedAgent> orgPositions = new ArrayList<QualifiedAgent>();
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                orgPositions.add((QualifiedAgent)element);
                ++n2;
            }
            return orgPositions;
        }
        StructuredSelection selection = (StructuredSelection)this.comboViewer_orgPos.getSelection();
        return Collections.singletonList((QualifiedAgent)selection.getFirstElement());
    }

    private void resizeAndLayout() {
        Point currentSize = this.getShell().getSize();
        Point preferredSize = this.getInitialSize();
        if (preferredSize.y > currentSize.y) {
            this.getShell().setSize(preferredSize);
        }
        Control[] controlArray = this.getShell().getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Composite) {
                ((Composite)control).layout(true, true);
            }
            ++n2;
        }
    }

    private void setMode(Mode mode) {
        Button okButton = this.getButton(0);
        switch (mode) {
            case AUTHENTICATION: {
                this.mode = mode;
                ((GridData)this.label_orgPos.getLayoutData()).exclude = true;
                if (this.multipleOrgPositionSelectionEnabled) {
                    ((GridData)this.table_orgPos.getLayoutData()).exclude = true;
                } else {
                    ((GridData)this.combo_orgPos.getLayoutData()).exclude = true;
                }
                okButton.setText(this.messages.getString("AuthenticateBtn"));
                this.setMessage(this.messages.getString("LDMessage1"), false);
                break;
            }
            case ORG_POSITION_SELECTION: {
                this.mode = mode;
                ((GridData)this.label_orgPos.getLayoutData()).exclude = false;
                this.label_orgPos.setVisible(true);
                if (this.multipleOrgPositionSelectionEnabled) {
                    ((GridData)this.table_orgPos.getLayoutData()).exclude = false;
                    this.table_orgPos.setVisible(true);
                } else {
                    ((GridData)this.combo_orgPos.getLayoutData()).exclude = false;
                    this.combo_orgPos.setVisible(true);
                }
                okButton.setText(this.messages.getString("LoginBtn"));
                this.text_userName.setEnabled(false);
                this.text_password.setEnabled(false);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.resizeAndLayout();
    }

    void setMessage(String message, boolean isError) {
        this.label_messageIndicator.setVisible(true);
        if (isError) {
            this.label_messageIndicator.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"));
        } else {
            this.label_messageIndicator.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK"));
        }
        this.label_messageText.setText(message);
        this.label_messageText.setVisible(true);
        this.resizeAndLayout();
    }

    protected void okPressed() {
        Mode mode = this.mode;
        Integer orgPosCount = null;
        if (mode == Mode.AUTHENTICATION) {
            orgPosCount = this.authenticate();
        }
        if (mode == Mode.ORG_POSITION_SELECTION || orgPosCount != null && orgPosCount == 1) {
            try {
                this.clientSessionFactories = this.retrieveSessionFactoriesFor(this.getSelectedOrgPositions());
                this.wasAuthenticationSuccessful = true;
                super.okPressed();
            }
            catch (DataSourceException ex) {
                this.setMessage(this.messages.getString("LDMessage2"), true);
                this.logger.log(Level.SEVERE, "The authentication could not be performed. There was an error with the data source.", ex);
                return;
            }
            catch (AuthenticationException authenticationException) {
                this.setMessage(this.messages.getString("LDMessage3"), true);
                return;
            }
        }
    }

    private int authenticate() {
        if (this.text_userName.getText().length() == 0) {
            this.setMessage(this.messages.getString("LDMessage4"), true);
            this.text_userName.setFocus();
            return 0;
        }
        this.userName = this.text_userName.getText();
        this.password = this.text_password.getText();
        this.setMessage(this.messages.getString("LDMessage5"), false);
        this.getContents().update();
        try {
            List positions = this.authentication.authenticate(this.userName, this.password);
            if (positions.size() == 0) {
                this.setMode(Mode.ORG_POSITION_SELECTION);
                this.getButton(0).setEnabled(false);
                this.setMessage(this.messages.getString("LDMessage10"), true);
            } else if (this.orgPositionSelectionEnabled) {
                if (this.multipleOrgPositionSelectionEnabled) {
                    this.setMessage(this.messages.getString("LDMessage6"), false);
                    this.tableViewer_orgPos.setInput((Object)positions);
                    this.tableViewer_orgPos.setAllChecked(true);
                    for (QualifiedAgent qualifiedAgent : positions) {
                        if (qualifiedAgent.getOrgPositionID() != -4L && qualifiedAgent.getOrgPositionID() != -3L) continue;
                        this.tableViewer_orgPos.setChecked((Object)qualifiedAgent, false);
                    }
                } else {
                    this.setMessage(this.messages.getString("LDMessage7"), false);
                    this.comboViewer_orgPos.setInput((Object)positions);
                    this.comboViewer_orgPos.setSelection((ISelection)new StructuredSelection(positions.get(0)));
                }
                this.setMode(Mode.ORG_POSITION_SELECTION);
            } else {
                this.clientSessionFactories = this.retrieveSessionFactoriesFor(positions);
                this.wasAuthenticationSuccessful = true;
                super.okPressed();
            }
            return positions.size();
        }
        catch (DataSourceException ex) {
            this.setMessage(this.messages.getString("LDMessage8"), true);
            this.logger.log(Level.SEVERE, "The authentication could not be performed. There was an error with the data source.", ex);
            return 0;
        }
        catch (AuthenticationException ex) {
            this.text_userName.setFocus();
            String msg = this.messages.getString("LDMessage9");
            if (ex.getMessage() != null) {
                msg = String.valueOf(msg) + "\n\n(" + ex.getMessage() + ")";
            }
            this.setMessage(msg, true);
            return 0;
        }
    }

    private ClientSessionFactory[] retrieveSessionFactoriesFor(List<QualifiedAgent> orgPositions) throws AuthenticationException, DataSourceException {
        String appName = Platform.getProduct().getDefiningBundle().getSymbolicName();
        NameOrgPosSesIDAppNameHandler callbackHandler = new NameOrgPosSesIDAppNameHandler(orgPositions, appName, this.userSessionID);
        try {
            return this.authentication.authenticateCombined("UTF-8_PASSWORD", this.password.getBytes("UTF-8"), (AFCallbackHandler)callbackHandler);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalServiceException("UTF-8 is not available");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return this.retrieveSessionFactoriesForOld(orgPositions);
        }
    }

    private ClientSessionFactory[] retrieveSessionFactoriesForOld(List<QualifiedAgent> orgPositions) throws AuthenticationException, DataSourceException {
        ClientSessionFactory[] sessionFactories = new ClientSessionFactory[orgPositions.size()];
        int index = 0;
        for (QualifiedAgent orgPos : orgPositions) {
            sessionFactories[index] = this.userSessionID != null ? this.authentication.authenticate(this.userName, orgPos.getOrgPositionID(), this.password, this.userSessionID) : this.authentication.authenticate(this.userName, orgPos.getOrgPositionID(), this.password);
            ++index;
        }
        return sessionFactories;
    }

    private static enum Mode {
        AUTHENTICATION,
        ORG_POSITION_SELECTION;

    }

    static class OrgPositionLabelProvider
    extends LabelProvider {
        OrgPositionLabelProvider() {
        }

        public String getText(Object element) {
            QualifiedAgent qa = (QualifiedAgent)element;
            return String.valueOf(qa.getOrgPositionName()) + " (" + qa.getOrgPositionID() + ")";
        }
    }
}

