/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.processmodel.timemodel;

import de.aristaflow.adept2.base.security.AuthenticationException;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionFactory;
import de.aristaflow.adept2.core.checks.processmodel.AbstractProcessTemplateCheck;
import de.aristaflow.adept2.core.checks.processmodel.ProcessCheckService;
import de.aristaflow.adept2.core.timemanager.TimeManager;
import de.aristaflow.adept2.model.common.timedata.CalendarElement;
import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.common.timedata.TimePoint;
import de.aristaflow.adept2.model.common.timedata.defaultimplementation.DefaultTimeDistance;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.globals.TimeModelConstants;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.StructuredConstraintEdge;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemporalNode;
import de.aristaflow.adept2.model.processmodel.TemporalTemplate;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultTemporalTemplate;
import de.aristaflow.adept2.model.processmodel.timemodel.ActivityDuration;
import de.aristaflow.adept2.model.processmodel.timemodel.FixedDate;
import de.aristaflow.adept2.model.processmodel.timemodel.ProcessDuration;
import de.aristaflow.adept2.model.processmodel.timemodel.ScheduleRestrictedElement;
import de.aristaflow.adept2.model.processmodel.timemodel.TimeLag;
import de.aristaflow.adept2.model.processmodel.timemodel.ValidityPeriod;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.timemodel.TimeModelFactory;
import de.aristaflow.adept2.model.timemodel.TimeModelOperations;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.DataSourceException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.Configuration;

public class BasicTemporalProcessCheck
extends AbstractProcessTemplateCheck {
    private static final String ID = "BasicTimeModelCheck";
    private static final boolean XOR_SPLIT_HAS_DURATION = false;
    private static final boolean ENDLOOP_HAS_DURATION = false;
    private static final String PROCESS_DURATION_MISSING = "ProcessDuration.Missing";
    private static final String PROCESS_DURATION_MIN_MAX_MISSING = "ProcessDuration.MinMaxMissing";
    private static final String ACTIVITY_DURATION_MISSING = "ActivityDuration.Missing";
    private static final String ACTIVITY_DURATION_ZERO = "ActivityDuration.Zero";
    private static final String STUCTURAL_NODE_HAS_DURATION = "ActivityDuration.StructuralNode";
    private static final String XOR_SPLIT_DURATION_MISSING = "ActivityDuration.XOR.Missing";
    private static final String ENDLOOP_DURATION_MISSING = "ActivityDuration.Loop.Missing";
    private static final String STUCTURAL_NODE_HAS_VALIDITY = "ValidityPeriod.StructuralNode";
    private static final String STUCTURAL_NODE_HAS_SCHEDULE = "ScheduleRestrictedElement.StructuralNode";
    private static final String STUCTURAL_NODE_HAS_FIXEDDATE = "FixedDate.StructuralNode";
    protected Map<String, CheckReport.ResultType> checkReportLevel;
    private TimeModelOperations timeModelOperations;
    private ProcessCheckService checkService;
    private Registry registry;
    private TimeManager timeManager;

    public BasicTemporalProcessCheck(Configuration configuration, ProcessCheckService checkService, Registry registry) {
        super(ID);
        this.checkService = checkService;
        this.registry = registry;
        this.initCheckLevels();
    }

    public BasicTemporalProcessCheck(TimeModelOperations timeModelOperations) {
        super(ID);
        this.timeModelOperations = timeModelOperations;
        this.initCheckLevels();
    }

    protected void initCheckLevels() {
        this.checkReportLevel = new HashMap<String, CheckReport.ResultType>();
        this.checkReportLevel.put(ACTIVITY_DURATION_MISSING, CheckReport.ResultType.WARNING);
        this.checkReportLevel.put(ACTIVITY_DURATION_ZERO, CheckReport.ResultType.FAILURE);
        this.checkReportLevel.put(STUCTURAL_NODE_HAS_DURATION, CheckReport.ResultType.WARNING);
        this.checkReportLevel.put(XOR_SPLIT_DURATION_MISSING, CheckReport.ResultType.WARNING);
        this.checkReportLevel.put(ENDLOOP_DURATION_MISSING, CheckReport.ResultType.WARNING);
        this.checkReportLevel.put(STUCTURAL_NODE_HAS_VALIDITY, CheckReport.ResultType.FAILURE);
        this.checkReportLevel.put(STUCTURAL_NODE_HAS_SCHEDULE, CheckReport.ResultType.FAILURE);
        this.checkReportLevel.put(STUCTURAL_NODE_HAS_FIXEDDATE, CheckReport.ResultType.FAILURE);
        this.checkReportLevel.put(PROCESS_DURATION_MISSING, CheckReport.ResultType.WARNING);
        this.checkReportLevel.put(PROCESS_DURATION_MIN_MAX_MISSING, CheckReport.ResultType.WARNING);
    }

    protected TimeManager getTimeManager() {
        if (this.timeManager == null) {
            SessionFactory sessionFactory;
            URI[] uris = this.checkService.getURIs();
            try {
                sessionFactory = this.registry.getSecurityManager().authenticatePrivileged(-2L, -2L, "password");
            }
            catch (AuthenticationException ae) {
                throw new InternalServiceException("Failed to authenticate at the security manager due to wrongauthentication data. Check the configuration of this SubprocessManager.", (Throwable)ae);
            }
            catch (DataSourceException dse) {
                throw new InternalServiceException("Failed to authenticate at the security manager due to unavailability of the data.", (Throwable)dse);
            }
            try {
                this.timeManager = (TimeManager)this.registry.getServiceOfType(sessionFactory.getSessionToken(uris), "TimeManager", TimeManager.class);
            }
            catch (ServiceNotKnownException e) {
                throw new InternalServiceException("Failed to get Time Manager Service.", (Throwable)e);
            }
        }
        return this.timeManager;
    }

    public TimeModelOperations getTimeModelOperations() {
        if (this.timeModelOperations == null) {
            TimeManager timeManager = this.getTimeManager();
            TimeModelFactory factory = timeManager.getTimeModellingService().getTimeModelFactory();
            this.timeModelOperations = factory.getTimeModelOperations();
        }
        return this.timeModelOperations;
    }

    protected CheckReport.ResultType getReportType(String id) {
        CheckReport.ResultType type = this.checkReportLevel.get(id);
        if (type != null) {
            return type;
        }
        this.logger.warning(String.format("Not ReportType defined for key '%s'!", id));
        return CheckReport.ResultType.INFO;
    }

    protected void performCheckSpi(Template template, NodeRelations relations, CheckReport checkReport) {
        DefaultTemporalTemplate temporalTemplate = new DefaultTemporalTemplate(template);
        this.performCheckTemplate(temporalTemplate, checkReport);
        this.performCheckNodes(temporalTemplate, checkReport);
        this.performCheckConstraintEdges(temporalTemplate, checkReport);
    }

    protected void performCheckTemplate(TemporalTemplate template, CheckReport checkReport) {
        this.performCheckProcessDuration(template, checkReport);
    }

    protected void performCheckProcessDuration(TemporalTemplate template, CheckReport checkReport) {
        ProcessDuration processDuration = template.getProcessDuration();
        if (processDuration != null) {
            this.checkProcessDuration(processDuration, template, checkReport);
        } else {
            String message = String.format("The template should have a process duration assigned!", new Object[0]);
            this.addReportEntry(this.getReportType(PROCESS_DURATION_MISSING), message, new Object[]{template});
        }
    }

    protected void performCheckConstraintEdges(TemporalTemplate template, CheckReport checkReport) {
        for (StructuredConstraintEdge edge : template.getConstraintEdgeStructure()) {
            TimeModelConstants.RelationType[] relationTypeArray = TimeModelConstants.RelationType.values();
            int n = relationTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                TimeModelConstants.RelationType r = relationTypeArray[n2];
                TimeLag timeLag = template.getTimeLagConstraint(edge.getSourceNodeID(), edge.getDestinationNodeID(), r);
                if (timeLag != null) {
                    this.checkTimeLag(template, timeLag, edge, checkReport);
                }
                ++n2;
            }
        }
    }

    protected void performCheckNodes(TemporalTemplate template, CheckReport checkReport) {
        for (Node node : template.getNodes()) {
            TemporalNode temporalNode = template.getNode(node.getID());
            this.performCheckActivityDuration(temporalNode, template, checkReport);
            this.performCheckFixedDate(temporalNode, template, checkReport);
            this.performCheckSchedule(temporalNode, template, checkReport);
            this.performCheckValidityPeriod(temporalNode, template, checkReport);
        }
    }

    protected void checkTimeLag(TemporalTemplate template, TimeLag timeLag, StructuredConstraintEdge edge, CheckReport checkReport) {
        String message;
        boolean minimumTimeLagOK = true;
        boolean maximumTimeLagOK = true;
        if (timeLag.getLowerMinimumTimeLag() == null) {
            if (timeLag.getUpperMinimumTimeLag() != null) {
                message = String.format("Upper Minimum TimeLag must be null in case Lower Minimum TimeLag is null!", new Object[0]);
                this.addReportEntry(CheckReport.ResultType.WARNING, message, new Object[]{template.getNode(edge.getSourceNodeID()), template.getNode(edge.getDestinationNodeID())});
            }
            minimumTimeLagOK = false;
        } else {
            minimumTimeLagOK &= this.checkTimePoint(timeLag.getLowerMinimumTimeLag(), checkReport, template.getNode(edge.getSourceNodeID()), template.getNode(edge.getDestinationNodeID()));
            if (timeLag.getUpperMinimumTimeLag() != null && (minimumTimeLagOK &= this.checkTimePoint(timeLag.getUpperMinimumTimeLag(), checkReport, template.getNode(edge.getSourceNodeID()), template.getNode(edge.getDestinationNodeID()))) && this.getTimeModelOperations().compare(timeLag.getLowerMinimumTimeLag(), timeLag.getUpperMinimumTimeLag()) > 0) {
                message = String.format("Lower Minimum TimeLag may not be bigger than Upper Minimum TimeLag!", new Object[0]);
                this.addReportEntry(CheckReport.ResultType.FAILURE, message, new Object[]{template.getNode(edge.getSourceNodeID()), template.getNode(edge.getDestinationNodeID())});
            }
        }
        if (timeLag.getUpperMaximumTimeLag() == null) {
            if (timeLag.getLowerMaximumTimeLag() != null) {
                message = String.format("Lower Maximum TimeLag must be null in case Upper Maximum TimeLag is null!", new Object[0]);
                this.addReportEntry(CheckReport.ResultType.WARNING, message, new Object[]{template.getNode(edge.getSourceNodeID()), template.getNode(edge.getDestinationNodeID())});
            }
            maximumTimeLagOK = false;
        } else {
            maximumTimeLagOK &= this.checkTimePoint(timeLag.getLowerMaximumTimeLag(), checkReport, template.getNode(edge.getSourceNodeID()), template.getNode(edge.getDestinationNodeID()));
            if (timeLag.getLowerMaximumTimeLag() != null && (maximumTimeLagOK &= this.checkTimePoint(timeLag.getUpperMaximumTimeLag(), checkReport, template.getNode(edge.getSourceNodeID()), template.getNode(edge.getDestinationNodeID()))) && this.getTimeModelOperations().compare(timeLag.getLowerMaximumTimeLag(), timeLag.getUpperMaximumTimeLag()) > 0) {
                message = String.format("Lower Maxmimum TimeLag may not be bigger than Upper Maximum TimeLag!", new Object[0]);
                this.addReportEntry(CheckReport.ResultType.FAILURE, message, new Object[]{template.getNode(edge.getSourceNodeID()), template.getNode(edge.getDestinationNodeID())});
            }
        }
        if (timeLag.getLowerMinimumTimeLag() == null && timeLag.getUpperMaximumTimeLag() == null) {
            if (timeLag.getTimeLagUpdateHandler() == null) {
                message = String.format("Either minimum TimeLag, maximum TimeLag or activity update procedure needs to be provided!", new Object[0]);
                this.addReportEntry(CheckReport.ResultType.FAILURE, message, new Object[]{template.getNode(edge.getSourceNodeID()), template.getNode(edge.getDestinationNodeID())});
            }
        } else if (minimumTimeLagOK && maximumTimeLagOK && this.getTimeModelOperations().compare(timeLag.getLowerMinimumTimeLag(), timeLag.getUpperMaximumTimeLag()) > 0) {
            message = String.format("Lower Minimum TimeLag may not be bigger than Upper Maximum TimeLag!", new Object[0]);
            this.addReportEntry(CheckReport.ResultType.FAILURE, message, new Object[]{template.getNode(edge.getSourceNodeID()), template.getNode(edge.getDestinationNodeID())});
        }
    }

    protected void checkProcessDuration(ProcessDuration processDuration, TemporalTemplate template, CheckReport checkReport) {
        String message;
        boolean guardMinimumDurationOK = true;
        boolean guardMaximumDurationOK = true;
        boolean flexibleMaximumDurationOK = true;
        if (processDuration.getMinimumDuration() == null) {
            if (processDuration.getGuardMaximumDuration() != null) {
                message = String.format("The template has a maximum contingent process duration but no minimum contingent process duration!", new Object[0]);
                this.addReportEntry(this.getReportType(PROCESS_DURATION_MIN_MAX_MISSING), message, new Object[]{template});
            } else {
                message = String.format("The template is missing a minimum contingent process duration!", new Object[0]);
                this.addReportEntry(this.getReportType(PROCESS_DURATION_MISSING), message, new Object[]{template});
            }
            guardMinimumDurationOK = false;
        } else {
            guardMinimumDurationOK &= this.checkTimePoint(processDuration.getMinimumDuration(), checkReport, template);
        }
        if (processDuration.getGuardMaximumDuration() == null) {
            if (processDuration.getMinimumDuration() != null) {
                message = String.format("The template has a minimum contingent process duration but no maximum contingent process duration!", new Object[0]);
                this.addReportEntry(this.getReportType(PROCESS_DURATION_MIN_MAX_MISSING), message, new Object[]{template});
            } else {
                message = String.format("The template is missing a maximum contingent process duration!", new Object[0]);
                this.addReportEntry(this.getReportType(PROCESS_DURATION_MISSING), message, new Object[]{template});
            }
            guardMaximumDurationOK = false;
        } else {
            guardMaximumDurationOK &= this.checkTimePoint(processDuration.getGuardMaximumDuration(), checkReport, template);
        }
        flexibleMaximumDurationOK = processDuration.getMaximumDuration() != null ? (flexibleMaximumDurationOK &= this.checkTimePoint(processDuration.getMaximumDuration(), checkReport, template)) : false;
        if (guardMinimumDurationOK && guardMaximumDurationOK && this.getTimeModelOperations().compare(processDuration.getMinimumDuration(), processDuration.getGuardMaximumDuration()) > 0) {
            message = String.format("Contingent minimum process duration may not be bigger than contingent maximum process duration!", new Object[0]);
            this.addReportEntry(CheckReport.ResultType.FAILURE, message, new Object[]{template});
        }
        if (guardMaximumDurationOK && flexibleMaximumDurationOK && this.getTimeModelOperations().compare(processDuration.getGuardMaximumDuration(), processDuration.getMaximumDuration()) > 0) {
            message = String.format("Flexible minimum process duration may not be lower than contingent maximum process duration!", new Object[0]);
            this.addReportEntry(CheckReport.ResultType.FAILURE, message, new Object[]{template});
        }
    }

    protected void performCheckValidityPeriod(TemporalNode node, TemporalTemplate template, CheckReport checkReport) {
        ProcessConstants.NodeType type = template.getNodeType(node.getID());
        ValidityPeriod startValidity = node.getStartValidityPeriod();
        ValidityPeriod completionValidity = node.getCompletionValidityPeriod();
        switch (type) {
            case NT_STARTFLOW: 
            case NT_ENDFLOW: 
            case NT_AND_SPLIT: 
            case NT_AND_JOIN: 
            case NT_XOR_SPLIT: 
            case NT_XOR_JOIN: 
            case NT_STARTLOOP: 
            case NT_ENDLOOP: {
                if (startValidity == null && completionValidity == null) break;
                String message = String.format("Node '%1$s' (%2$d) is a structural Node of type '%3$s' and therefore should not have a Validity Period assigned!", node.getName(), node.getID(), type);
                this.addReportEntry(this.getReportType(STUCTURAL_NODE_HAS_VALIDITY), message, new Object[]{node});
                break;
            }
            case NT_NORMAL: {
                if (startValidity != null) {
                    this.checkValidityPeriod(startValidity, node, checkReport);
                }
                if (completionValidity == null) break;
                this.checkValidityPeriod(completionValidity, node, checkReport);
            }
        }
    }

    protected void checkValidityPeriod(ValidityPeriod validityPeriod, TemporalNode node, CheckReport checkReport) {
        String message;
        boolean periodOK = true;
        if (validityPeriod.getValidFrom() != null) {
            periodOK &= this.checkCalendarElement(validityPeriod.getValidFrom(), node, checkReport);
        }
        if (validityPeriod.getValidUntil() != null) {
            periodOK &= this.checkCalendarElement(validityPeriod.getValidUntil(), node, checkReport);
        }
        if (validityPeriod.getValidFrom() == null && validityPeriod.getValidUntil() == null && validityPeriod.getValidityPeriodSource() == null) {
            message = String.format("Either valid from, valid until or a source for the validity period needs to be provided!", new Object[0]);
            this.addReportEntry(CheckReport.ResultType.FAILURE, message, new Object[]{node});
        }
        if (periodOK && validityPeriod.getValidFrom() != null && validityPeriod.getValidUntil() != null && this.getTimeModelOperations().compare(validityPeriod.getValidFrom(), validityPeriod.getValidUntil()) >= 0) {
            message = String.format("The from value of the validity period may not be bigger than until value!", new Object[0]);
            this.addReportEntry(CheckReport.ResultType.FAILURE, message, new Object[]{node});
        }
    }

    protected boolean checkCalendarElement(CalendarElement calendarElement, Object affectedElement, CheckReport checkReport) {
        if (calendarElement == null) {
            return true;
        }
        if (calendarElement.getTimeInMillis() < 0L) {
            String message = String.format("Value of calendarElement may not be < 0!", new Object[0]);
            this.addReportEntry(CheckReport.ResultType.FAILURE, message, new Object[]{affectedElement});
            return false;
        }
        return true;
    }

    protected void performCheckSchedule(TemporalNode node, TemporalTemplate template, CheckReport checkReport) {
        ProcessConstants.NodeType type = template.getNodeType(node.getID());
        ScheduleRestrictedElement startSchedule = node.getStartSchedule();
        ScheduleRestrictedElement completionSchedule = node.getCompletionSchedule();
        switch (type) {
            case NT_STARTFLOW: 
            case NT_ENDFLOW: 
            case NT_AND_SPLIT: 
            case NT_AND_JOIN: 
            case NT_XOR_SPLIT: 
            case NT_XOR_JOIN: 
            case NT_STARTLOOP: 
            case NT_ENDLOOP: {
                if (startSchedule == null && completionSchedule == null) break;
                String message = String.format("Node '%1$s' (%2$d) is a structural Node of type '%3$s' and therefore should not have a Schedule Restricted Element assigned!", node.getName(), node.getID(), type);
                this.addReportEntry(this.getReportType(STUCTURAL_NODE_HAS_SCHEDULE), message, new Object[]{node});
                break;
            }
            case NT_NORMAL: {
                if (startSchedule != null) {
                    this.checkSchedule(startSchedule, node, checkReport);
                }
                if (completionSchedule == null) break;
                this.checkSchedule(completionSchedule, node, checkReport);
            }
        }
    }

    protected void checkSchedule(ScheduleRestrictedElement scheduleRestrictedElement, Node node, CheckReport checkReport) {
    }

    protected void performCheckFixedDate(TemporalNode node, TemporalTemplate template, CheckReport checkReport) {
        ProcessConstants.NodeType type = template.getNodeType(node.getID());
        FixedDate startFixedDate = node.getStartFixedDate();
        FixedDate completionFixedDate = node.getCompletionFixedDate();
        switch (type) {
            case NT_STARTFLOW: 
            case NT_ENDFLOW: 
            case NT_AND_SPLIT: 
            case NT_AND_JOIN: 
            case NT_XOR_SPLIT: 
            case NT_XOR_JOIN: 
            case NT_STARTLOOP: 
            case NT_ENDLOOP: {
                if (startFixedDate == null && completionFixedDate == null) break;
                String message = String.format("Node '%1$s' (%2$d) is a structural Node of type '%3$s' and therefore should not have a Fixed Date assigned!", node.getName(), node.getID(), type);
                this.addReportEntry(this.getReportType(STUCTURAL_NODE_HAS_FIXEDDATE), message, new Object[]{node});
                break;
            }
            case NT_NORMAL: {
                if (startFixedDate != null) {
                    this.checkFixedDate(startFixedDate, node, checkReport);
                }
                if (completionFixedDate == null) break;
                this.checkFixedDate(completionFixedDate, node, checkReport);
            }
        }
    }

    protected void checkFixedDate(FixedDate fixedDate, Node node, CheckReport checkReport) {
    }

    protected void performCheckActivityDuration(TemporalNode node, TemporalTemplate template, CheckReport checkReport) {
        ProcessConstants.NodeType type = template.getNodeType(node.getID());
        ActivityDuration activityDuration = node.getActivityDuration();
        switch (type) {
            case NT_STARTFLOW: 
            case NT_ENDFLOW: 
            case NT_AND_SPLIT: 
            case NT_AND_JOIN: 
            case NT_XOR_JOIN: 
            case NT_STARTLOOP: {
                if (activityDuration == null) break;
                String message = String.format("Node '%1$s' (%2$d) is a structural Node of type '%3$s' and therefore should not have an Activity Duration assigned!", node.getName(), node.getID(), type);
                this.addReportEntry(this.getReportType(STUCTURAL_NODE_HAS_DURATION), message, new Object[]{node});
                break;
            }
            case NT_NORMAL: {
                if (activityDuration == null) {
                    String message = String.format("Node '%1$s' (%2$d) does not have an Activity Duration assigned!", node.getName(), node.getID());
                    this.addReportEntry(this.getReportType(ACTIVITY_DURATION_MISSING), message, new Object[]{node});
                    break;
                }
                this.checkActivityDuration(activityDuration, node, checkReport);
                break;
            }
            case NT_XOR_SPLIT: {
                if (activityDuration == null) break;
                String message = String.format("Node '%1$s' (%2$d) is a structural Node of type '%3$s' and therefore should not have an Activity Duration assigned!", node.getName(), node.getID(), type);
                this.addReportEntry(this.getReportType(STUCTURAL_NODE_HAS_DURATION), message, new Object[]{node});
                break;
            }
            case NT_ENDLOOP: {
                if (activityDuration == null) break;
                String message = String.format("Node '%1$s' (%2$d) is a structural Node of type '%3$s' and therefore should not have an Activity Duration assigned!", node.getName(), node.getID(), type);
                this.addReportEntry(this.getReportType(STUCTURAL_NODE_HAS_DURATION), message, new Object[]{node});
            }
        }
    }

    protected void checkActivityDuration(ActivityDuration activityDuration, TemporalNode node, CheckReport checkReport) {
        String message;
        String message2;
        TimeDistance distance;
        boolean flexibleMinimumDurationOK = true;
        boolean contingentMaximumDurationOK = true;
        boolean flexibleMaximumDurationOK = true;
        if (activityDuration.getMinimumDuration() != null) {
            flexibleMinimumDurationOK &= this.checkTimePoint(activityDuration.getMinimumDuration(), checkReport, node);
            distance = this.getTimeModelOperations().convertToTimeDistance(activityDuration.getMinimumDuration());
            if (distance.compareTo(DefaultTimeDistance.ZERO_TIME_DISTANCE) <= 0) {
                message2 = String.format("Flexible minimum duration must be greater than zero! (Currently: %s)", distance);
                this.addReportEntry(this.getReportType(ACTIVITY_DURATION_ZERO), message2, new Object[]{node});
            }
        } else {
            message = "Flexible minimum duration must be provided!";
            this.addReportEntry(CheckReport.ResultType.FAILURE, message, new Object[]{node});
            flexibleMinimumDurationOK = false;
        }
        if (activityDuration.getGuardMinimumDuration() != null) {
            this.checkTimePoint(activityDuration.getGuardMinimumDuration(), checkReport, node);
            distance = this.getTimeModelOperations().convertToTimeDistance(activityDuration.getGuardMinimumDuration());
            if (distance.compareTo(DefaultTimeDistance.ZERO_TIME_DISTANCE) <= 0) {
                message2 = String.format("Contingent minimum duration must be greater than zero! (Currently: %s)", distance);
                this.addReportEntry(this.getReportType(ACTIVITY_DURATION_ZERO), message2, new Object[]{node});
            }
        }
        contingentMaximumDurationOK = activityDuration.getGuardMaximumDuration() != null ? (contingentMaximumDurationOK &= this.checkTimePoint(activityDuration.getGuardMaximumDuration(), checkReport, node)) : false;
        flexibleMaximumDurationOK = activityDuration.getMaximumDuration() != null ? (flexibleMaximumDurationOK &= this.checkTimePoint(activityDuration.getMaximumDuration(), checkReport, node)) : false;
        if (!contingentMaximumDurationOK && !flexibleMaximumDurationOK) {
            message = String.format("Maximum duration must be provided!", new Object[0]);
            this.addReportEntry(CheckReport.ResultType.FAILURE, message, new Object[]{node});
        }
        if (contingentMaximumDurationOK && flexibleMinimumDurationOK && this.getTimeModelOperations().compare(activityDuration.getMinimumDuration(), activityDuration.getGuardMaximumDuration()) > 0) {
            message = String.format("Contingent minimum duration may not be bigger than contingent maximum duration!", new Object[0]);
            this.addReportEntry(CheckReport.ResultType.FAILURE, message, new Object[]{node});
        }
        if (flexibleMaximumDurationOK && contingentMaximumDurationOK && this.getTimeModelOperations().compare(activityDuration.getGuardMaximumDuration(), activityDuration.getMaximumDuration()) > 0) {
            message = String.format("Contingent maxmimum duration may not be bigger than flexible maximum duration!", new Object[0]);
            this.addReportEntry(CheckReport.ResultType.FAILURE, message, new Object[]{node});
        }
    }

    protected boolean checkTimePoint(TimePoint timePoint, Object affectedElement, CheckReport checkReport) {
        return this.checkTimePoint(timePoint, checkReport, affectedElement);
    }

    protected boolean checkTimePoint(TimePoint timePoint, CheckReport checkReport, Object ... affectedElement) {
        if (timePoint == null) {
            return true;
        }
        if (timePoint.getMonths() == Long.MIN_VALUE && timePoint.getDays() == Long.MIN_VALUE && timePoint.getHours() == Long.MIN_VALUE && timePoint.getMinutes() == Long.MIN_VALUE && timePoint.getSeconds() == Long.MIN_VALUE) {
            String message = String.format("At least one value of time point needs to be specified!", new Object[0]);
            this.addReportEntry(CheckReport.ResultType.FAILURE, message, affectedElement);
            return false;
        }
        return true;
    }
}

