/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.timemodel;

import de.aristaflow.adept2.core.checks.timemodel.TimeModelCheck;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.timemodel.TimeModel;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TimeModelCheckRunner
implements TimeModelCheck {
    protected final TimeModelCheck[] checks;
    protected final boolean stopOnError;
    protected Logger logger = LoggerTools.getLogger((Object)this);

    public TimeModelCheckRunner(boolean stopOnError, TimeModelCheck[] checks) {
        this.stopOnError = stopOnError;
        this.checks = checks != null ? (TimeModelCheck[])checks.clone() : null;
    }

    public TimeModelCheckRunner(TimeModelCheck ... checks) {
        this(true, checks);
    }

    @Override
    public boolean performCheck(TimeModel timeModel, Template template, NodeRelations relations, CheckReport checkReport) {
        boolean allOK = true;
        TimeModelCheck[] timeModelCheckArray = this.checks;
        int n = this.checks.length;
        int n2 = 0;
        while (n2 < n) {
            boolean checkOK;
            TimeModelCheck check = timeModelCheckArray[n2];
            this.logger.fine(String.format("Running check: %s", check.getClass().getSimpleName()));
            try {
                checkOK = check.performCheck(timeModel, template, relations, checkReport);
            }
            catch (RuntimeException e) {
                allOK = false;
                String message = String.format("An exception occurred performing the check '%1$s', failing and skipping subsequent checks!", check.getClass().getSimpleName());
                this.logger.log(Level.SEVERE, message, e);
                if (checkReport == null) break;
                checkReport.addReportEntry(message, CheckReport.ResultType.FAILURE, message, new URI[0]);
                break;
            }
            if (!checkOK) {
                allOK = false;
                this.logger.info("Check '" + check.getClass().getSimpleName() + "' failed, skipping following checks.");
                if (this.stopOnError) {
                    return false;
                }
            }
            ++n2;
        }
        return allOK;
    }

    @Override
    public boolean performCheck(TimeModel timeModel, CheckReport checkReport) {
        return this.performCheck(timeModel, null, null, checkReport);
    }
}

