/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.timemodel.tcnimplementation;

import de.aristaflow.adept2.base.security.AuthenticationException;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionFactory;
import de.aristaflow.adept2.core.checks.timemodel.TimeModelCheckService;
import de.aristaflow.adept2.core.timemanager.TimeManager;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.model.timemodel.TimeModel;
import de.aristaflow.adept2.model.timemodel.TimeModelFactory;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.logging.Logger;
import org.apache.commons.configuration.Configuration;

public abstract class AbstractTimeModelCheck {
    protected final String id;
    protected final TimeModelFactory factory;
    private final ThreadLocal<CheckReport.ResultType> result = new ThreadLocal();
    private final ThreadLocal<CheckReport> checkReport = new ThreadLocal();
    private Logger logger = LoggerTools.getLogger((Object)this);

    public AbstractTimeModelCheck(String id, Configuration configuration, TimeModelCheckService checkService, Registry registry) {
        TimeManager timeManager;
        SessionFactory sessionFactory;
        this.id = id;
        URI[] uris = checkService.getURIs();
        try {
            sessionFactory = registry.getSecurityManager().authenticatePrivileged(-2L, -2L, "password");
        }
        catch (AuthenticationException ae) {
            throw new InternalServiceException("Failed to authenticate at the security manager due to wrongauthentication data. Check the configuration of this SubprocessManager.", (Throwable)ae);
        }
        catch (DataSourceException dse) {
            throw new InternalServiceException("Failed to authenticate at the security manager due to unavailability of the data.", (Throwable)dse);
        }
        try {
            timeManager = (TimeManager)registry.getServiceOfType(sessionFactory.getSessionToken(uris), "TimeManager", TimeManager.class);
        }
        catch (ServiceNotKnownException e) {
            throw new InternalServiceException("Failed to get Time Manager Service.", (Throwable)e);
        }
        this.factory = timeManager.getTimeModellingService().getTimeModelFactory();
    }

    public boolean performCheck(TimeModel timeModel, Template template, NodeRelations relations, CheckReport checkReport) {
        try {
            this.result.set(CheckReport.ResultType.OK);
            this.checkReport.set(checkReport);
            this.performCheckSpi(timeModel, template, relations);
            boolean bl = this.result.get().ordinal() < CheckReport.ResultType.WARNING.ordinal();
            return bl;
        }
        finally {
            this.checkReport.remove();
            this.result.remove();
        }
    }

    protected abstract void performCheckSpi(TimeModel var1, Template var2, NodeRelations var3);

    public boolean performCheck(TimeModel timeModel, CheckReport checkReport) {
        return this.performCheck(timeModel, null, null, checkReport);
    }

    protected final void addReportEntry(CheckReport.ResultType resultType, String message, Object ... elements) {
        this.logger.info(message);
        CheckReport checkReport = this.checkReport.get();
        if (checkReport != null) {
            URI[] uris = this.getURIsForElement(checkReport.getBase(), elements);
            checkReport.addReportEntry(this.id, resultType, message, uris);
        }
        if (this.result.get().ordinal() < resultType.ordinal()) {
            this.result.set(resultType);
        }
    }

    private URI[] getURIsForElement(URI base, Object[] element) {
        URI[] res = new URI[element.length];
        int i = 0;
        while (i < res.length) {
            if (element[i] instanceof DataElement) {
                res[i] = ProcessElementIdentifierTools.getDataElementIdentifier((URI)base, (DataElement)((DataElement)element[i]));
            } else if (element[i] instanceof Node) {
                res[i] = ProcessElementIdentifierTools.getNodeIdentifier((URI)base, (Node)((Node)element[i]));
            }
            ++i;
        }
        return res;
    }
}

