/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.timemanager.defaultimplementation;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.AbstractSubService;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.checks.timemodel.TimeModelCheck;
import de.aristaflow.adept2.core.checks.timemodel.TimeModelCheckRunner;
import de.aristaflow.adept2.core.processmanager.ProcessManager;
import de.aristaflow.adept2.core.timemanager.InstanceTimeManager;
import de.aristaflow.adept2.core.timemanager.TimePrediction;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.DefaultTemplateTimeManager;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.DefaultTimeManager;
import de.aristaflow.adept2.core.timemanager.storage.InstanceTimeModelStorage;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.timemodel.ChangeableTimeModelStatus;
import de.aristaflow.adept2.model.timemodel.InstanceTimeContext;
import de.aristaflow.adept2.model.timemodel.InstanceTimeModel;
import de.aristaflow.adept2.model.timemodel.TemplateTimeModel;
import de.aristaflow.adept2.model.timemodel.TimeModel;
import de.aristaflow.adept2.model.timemodel.TimeModelFactory;
import de.aristaflow.adept2.model.timemodel.TimeModelStatus;
import de.aristaflow.adept2.model.timemodel.UpdateableInstanceTimeContext;
import de.aristaflow.adept2.model.timemodel.UpdateableInstanceTimeModel;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LockException;
import java.net.URI;
import java.util.UUID;
import java.util.logging.Level;

public class DefaultInstanceTimeManager
extends AbstractSubService
implements InstanceTimeManager {
    private final InstanceTimeModelStorage instanceTimeModelStorage;
    private final DefaultTimeManager timeManager;
    private final DefaultTemplateTimeManager templateTimeManager;
    private final TimeModelFactory timeModelFactory;
    private ProcessManager processManager;

    public DefaultInstanceTimeManager(DefaultTimeManager timeManager, TimeModelFactory timeModelFactory, DefaultTemplateTimeManager templateTimeManager, InstanceTimeModelStorage instanceTimeModelStorage) {
        super((AbstractADEPT2Service)timeManager);
        this.timeManager = timeManager;
        this.instanceTimeModelStorage = instanceTimeModelStorage;
        this.timeModelFactory = timeModelFactory;
        this.templateTimeManager = templateTimeManager;
    }

    public void init() throws AbortServiceException {
        this.processManager = this.timeManager.getProcessManager();
    }

    @Override
    public InstanceTimeContext getInstanceTimeContext(SessionToken sessionToken, UUID instanceID) {
        try {
            InstanceTimeContext instanceTimeData = this.instanceTimeModelStorage.getInstanceTimeContextReadonly(instanceID);
            return instanceTimeData;
        }
        catch (DataSourceException e) {
            this.logger.log(Level.SEVERE, "DataSourceException", e);
            return null;
        }
    }

    @Override
    public TimePrediction getTimePrediction(SessionToken sessionToken, UUID instanceID) {
        return null;
    }

    private boolean checkTimeModel(SessionToken session, TimeModel timeModel, CheckReport report) {
        boolean ret = true;
        TimeModelCheck[] checks = this.timeManager.getTimeModelChecks(session);
        TimeModelCheckRunner allChecks = new TimeModelCheckRunner(false, checks);
        return ret &= allChecks.performCheck(timeModel, report);
    }

    public InstanceTimeModelStorage getStorage() {
        return this.instanceTimeModelStorage;
    }

    public void updateTimeModelStatus(SessionToken session, TimeModelStatus status) throws LockException {
        if (status.getTimeModelUpdateStatus().ordinal() <= TimeModelStatus.TimeModelUpdateStatus.NO_UPDATE.ordinal()) {
            try {
                if (!this.instanceTimeModelStorage.hasTimeModelForInstance(status.getInstanceID())) {
                    throw new IllegalStateException(String.format("Time Model Update for instance '%1$s' may only be enabled in case there is a valid time model available", status.getInstanceID()));
                }
            }
            catch (DataSourceException dataSourceException) {
                throw new IllegalStateException(String.format("Time Model Update for instance '%1$s' may only be enabled in case there is a valid time model available", status.getInstanceID()));
            }
        }
        try {
            this.instanceTimeModelStorage.updateTimeModelStatus(session, status);
        }
        catch (DataSourceException e) {
            this.logger.log(Level.SEVERE, "DataSourceException", e);
        }
    }

    public ChangeableTimeModelStatus getAndLockTimeModelStatus(SessionToken session, UUID instanceID) {
        try {
            return this.instanceTimeModelStorage.getAndLockTimeModelStatus(session, instanceID);
        }
        catch (DataSourceException e) {
            this.logger.log(Level.SEVERE, "DataSourceException", e);
            return null;
        }
    }

    public void unlockTimeModelStatus(SessionToken session, UUID instanceID) throws LockException {
        this.instanceTimeModelStorage.unlockTimeModelStatus(session, instanceID);
    }

    @Override
    public TimeModelStatus getTimeModelStatusReadonly(UUID instanceID) {
        try {
            return this.instanceTimeModelStorage.getTimeModelStatusReadonly(instanceID);
        }
        catch (DataSourceException e) {
            this.logger.log(Level.SEVERE, "DataSourceException", e);
            return null;
        }
    }

    public UpdateableInstanceTimeContext getAndLockInstanceTimeContext(SessionToken session, UUID instanceID) throws DataSourceException {
        return this.instanceTimeModelStorage.getAndLockInstanceTimeContext(session, instanceID);
    }

    public void updateInstanceTimeContext(SessionToken session, InstanceTimeContext timeData) throws LockException, DataSourceException {
        this.instanceTimeModelStorage.updateInstanceTimeContext(session, timeData);
    }

    public void unlockInstanceTimeContext(SessionToken session, UUID instanceID) throws LockException {
        this.instanceTimeModelStorage.unlockInstanceTimeContext(session, instanceID);
    }

    public UpdateableInstanceTimeContext createAndLockInstanceTimeContext(SessionToken session, UUID instanceID) throws DataSourceException {
        return this.instanceTimeModelStorage.createAndLockInstanceTimeContext(session, instanceID);
    }

    private Instance getInstance(SessionToken parentSession, UUID instanceID) {
        SessionToken session = this.subSession(parentSession);
        Instance instance = this.processManager.getInstanceManager().getInstance(session, instanceID);
        return instance;
    }

    private SessionToken subSession(SessionToken parentSession) {
        return this.timeManager.subSession(parentSession);
    }

    public UpdateableInstanceTimeModel createAndLockInstanceTimeModel(SessionToken session, UUID templateID, UUID instanceID, CheckReport checkReport) throws DataSourceException {
        UpdateableInstanceTimeModel timeModel = null;
        TemplateTimeModel templateTimeModel = this.templateTimeManager.getTimeModel(session, templateID);
        if (templateTimeModel != null) {
            Instance instance = this.getInstance(session, instanceID);
            InstanceTimeContext timeContext = this.instanceTimeModelStorage.getInstanceTimeContextReadonly(instanceID);
            timeModel = (UpdateableInstanceTimeModel)this.timeModelFactory.createTimeModelForInstance(instance, timeContext, templateTimeModel);
            this.checkTimeModel(session, timeModel, checkReport);
            if (checkReport.getCheckResult().ordinal() <= CheckReport.ResultType.WARNING.ordinal()) {
                this.instanceTimeModelStorage.lockInstanceTimeModel(session, instanceID);
                try {
                    this.instanceTimeModelStorage.updateInstanceTimeModel(session, instanceID, timeModel);
                }
                catch (DataSourceException e) {
                    this.logger.log(Level.SEVERE, "DataSourceException", e);
                }
                catch (LockException e) {
                    this.logger.log(Level.SEVERE, "LockException", e);
                }
            }
        } else {
            checkReport.addReportEntry("General", CheckReport.ResultType.FAILURE, "No template time model available!", new URI[0]);
        }
        return timeModel;
    }

    public void unlockTimeModel(SessionToken session, UUID instanceID) throws LockException {
        this.instanceTimeModelStorage.unlockInstanceTimeModel(session, instanceID);
    }

    public UpdateableInstanceTimeModel getAndLockTimeModel(SessionToken session, UUID instanceID) throws DataSourceException {
        return this.instanceTimeModelStorage.getAndLockInstanceTimeModel(session, instanceID);
    }

    @Override
    public InstanceTimeModel getInstanceTimeModelReadonly(SessionToken session, UUID instanceID) throws DataSourceException {
        return this.instanceTimeModelStorage.getInstanceTimeModelReadonly(instanceID);
    }

    public void updateTimeModel(SessionToken session, UpdateableInstanceTimeModel timeModel) {
    }
}

