/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.timemanager.defaultimplementation;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.AbstractSubService;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheckRunner;
import de.aristaflow.adept2.core.checks.timemodel.TimeModelCheck;
import de.aristaflow.adept2.core.checks.timemodel.TimeModelCheckRunner;
import de.aristaflow.adept2.core.processmanager.ProcessManager;
import de.aristaflow.adept2.core.timemanager.TemplateTimeManager;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.DefaultTimeManager;
import de.aristaflow.adept2.core.timemanager.storage.TemplateTimeModelStorage;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemporalTemplate;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultTemporalTemplate;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.model.timemodel.TemplateTimeModel;
import de.aristaflow.adept2.model.timemodel.TimeModel;
import de.aristaflow.adept2.model.timemodel.TimeModelFactory;
import de.aristaflow.adept2.util.CheckReport;
import java.net.URI;
import java.util.UUID;
import java.util.logging.Level;

public class DefaultTemplateTimeManager
extends AbstractSubService
implements TemplateTimeManager {
    private TemplateTimeModelStorage storage;
    private final DefaultTimeManager timeManager;
    private ProcessManager processManager;
    private TimeModelFactory timeModelFactory;

    public DefaultTemplateTimeManager(DefaultTimeManager timeManager, TimeModelFactory timeModelFactory, TemplateTimeModelStorage templateTimeStorage) {
        super(new String[]{"ProcessManager"}, new String[0], (AbstractADEPT2Service)timeManager);
        this.timeManager = timeManager;
        this.timeModelFactory = timeModelFactory;
        this.storage = templateTimeStorage;
    }

    public void init() throws AbortServiceException {
        this.processManager = this.timeManager.getProcessManager();
    }

    @Override
    public UUID[] getAllTimeModelIDs(SessionToken session) {
        return this.storage.getAllTimeModels();
    }

    @Override
    public TemplateTimeModel getTimeModel(SessionToken session, UUID templateID) {
        TemplateTimeModel templateTimeModel = this.storage.getTimeModel(templateID);
        if (templateTimeModel == null) {
            CheckReport checkReport = new CheckReport(this.getURIs()[0]);
            templateTimeModel = this.createAndGetTemplateTimeModel(session, templateID, checkReport);
            if (checkReport.getCheckResult().ordinal() >= CheckReport.ResultType.FAILURE.ordinal()) {
                templateTimeModel = null;
                this.logger.log(Level.SEVERE, checkReport.getReportSummary());
            }
        }
        return templateTimeModel;
    }

    @Override
    public TemplateTimeModel createAndGetTemplateTimeModel(SessionToken parentSession, UUID templateID, CheckReport checkReport) {
        SessionToken session = this.subSession(parentSession);
        TemplateTimeModel timeModel = null;
        TemporalTemplate template = this.getTemplate(session, templateID);
        if (this.checkTemplate(session, template, checkReport)) {
            timeModel = this.timeModelFactory.createTimeModelForTemplate(template);
            if (this.checkTimeModel(session, timeModel, template, checkReport)) {
                this.storage.storeTimeModel(template.getID(), timeModel);
            } else {
                checkReport.addReportEntry("TemplateTimeManager", CheckReport.ResultType.FAILURE, "TimeModel contains errors", new URI[]{ProcessElementIdentifierTools.getTemplateIdentifier((Template)template, (String)"TemplateTimeManager")});
            }
        } else {
            checkReport.addReportEntry("TemplateTimeManager", CheckReport.ResultType.FAILURE, "Template contains errors", new URI[]{ProcessElementIdentifierTools.getTemplateIdentifier((Template)template, (String)"TemplateTimeManager")});
        }
        return timeModel;
    }

    private SessionToken subSession(SessionToken parentSession) {
        return this.timeManager.subSession(parentSession);
    }

    public TemporalTemplate getTemplate(SessionToken parentSession, UUID templateID) {
        SessionToken session = this.subSession(parentSession);
        Template template = this.processManager.getTemplateManager().getTemplate(session, templateID);
        return new DefaultTemporalTemplate(template);
    }

    private boolean checkTemplate(SessionToken session, Template template, CheckReport report) {
        super.sessionActive(session);
        try {
            boolean ret = true;
            ProcessTemplateCheck[] checks = this.timeManager.getTemplateChecks(session);
            ProcessTemplateCheckRunner allChecks = new ProcessTemplateCheckRunner(checks);
            boolean bl = ret &= allChecks.performCheck(template, new NodeRelations(template), report);
            return bl;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    private boolean checkTimeModel(SessionToken session, TimeModel timeModel, Template template, CheckReport report) {
        super.sessionActive(session);
        try {
            boolean ret = true;
            TimeModelCheck[] checks = this.timeManager.getTimeModelChecks(session);
            TimeModelCheckRunner allChecks = new TimeModelCheckRunner(false, checks);
            boolean bl = ret &= allChecks.performCheck(timeModel, template, new NodeRelations(template), report);
            return bl;
        }
        finally {
            super.sessionFinished(session);
        }
    }
}

