/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.timemanager.defaultimplementation;

import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.core.complexeventmanager.EventClassManager;
import de.aristaflow.adept2.core.complexeventmanager.EventFilter;
import de.aristaflow.adept2.core.complexeventmanager.EventListener;
import de.aristaflow.adept2.core.complexeventmanager.EventManager;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.processexecution.ProcessExecutionManager;
import de.aristaflow.adept2.model.eventmodel.EventClass;
import de.aristaflow.adept2.model.eventmodel.EventReference;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultTimeEventNotification
implements EventListener,
EventFilter {
    protected Logger logger = LoggerTools.getLogger((Object)this);
    private final Set<String> consumedEvents;
    private final EventClassManager eventClassManager;
    private final ProcessExecutionManager processExecutionManager;

    public DefaultTimeEventNotification(ProcessExecutionManager processExecutionManager, EventManager eventManager, String ... consumedEvents) {
        this.processExecutionManager = processExecutionManager;
        this.consumedEvents = new HashSet<String>(Arrays.asList(consumedEvents));
        this.eventClassManager = eventManager.getEventClassManager();
    }

    public void eventOccurred(EventReference event) {
        if (this.getEventClass(event).getClassification().contains("de.aristaflow.adept2.core.executionmanager.InstanceEvent")) {
            try {
                this.processExecutionManager.processEvent(event);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Exception while processing event!", e);
            }
        } else {
            String msg = String.format("Received Event which is not a InstanceEventReference (%s)", event);
            this.logger.severe(msg);
            throw new InternalServiceException(msg);
        }
    }

    private EventClass getEventClass(EventReference event) {
        EventClass eventClass = this.eventClassManager.getEventClass(event.getEventClassID());
        return eventClass;
    }

    public boolean filter(EventReference event) {
        return this.getEventClass(event).getClassification().contains("de.aristaflow.adept2.core.executionmanager.InstanceEvent");
    }

    public Set<String> getConsumedEventClasses() {
        return Collections.unmodifiableSet(new HashSet<String>(this.consumedEvents));
    }
}

