/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.timemanager.defaultimplementation;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.configuration.ConfigurationDescription;
import de.aristaflow.adept2.base.configuration.Property;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceAccessControlException;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SecurityTokenIntegrityException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.core.checks.processmodel.timemodel.DefaultTimedProcessModelCheckService;
import de.aristaflow.adept2.core.checks.processmodel.timemodel.TemporalProcessCheckService;
import de.aristaflow.adept2.core.checks.timemodel.TimeModelCheck;
import de.aristaflow.adept2.core.checks.timemodel.TimeModelCheckService;
import de.aristaflow.adept2.core.checks.timemodel.tcnimplementation.TCNTimModelCheckService;
import de.aristaflow.adept2.core.complexeventmanager.EventManager;
import de.aristaflow.adept2.core.executionmanager.ExecutionManager;
import de.aristaflow.adept2.core.processmanager.ProcessManager;
import de.aristaflow.adept2.core.timemanager.InstanceTimeManager;
import de.aristaflow.adept2.core.timemanager.TemplateTimeManager;
import de.aristaflow.adept2.core.timemanager.TimeManager;
import de.aristaflow.adept2.core.timemanager.TimeModellingService;
import de.aristaflow.adept2.core.timemanager.WorklistInteraction;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.DefaultInstanceTimeManager;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.DefaultTemplateTimeManager;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.DefaultTimeModellingService;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.TimeAwareWorklistInteraction;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.WorklistAccess;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.escalation.defaultimplementation.DefaultEscalationManager;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.processexecution.defaultimplementation.DefaultActivityStarting;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.processexecution.defaultimplementation.DefaultActivityTermination;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.processexecution.defaultimplementation.DefaultInstanceStarting;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.processexecution.defaultimplementation.DefaultInstanceTermination;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.processexecution.defaultimplementation.DefaultProcessExecutionManager;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.timeControl.defaultimplementation.DefaultInstanceTimeControlManager;
import de.aristaflow.adept2.core.timemanager.storage.transientstorage.TransientInstanceTimeModelStorage;
import de.aristaflow.adept2.core.timemanager.storage.transientstorage.TransientTemplateTimeStorage;
import de.aristaflow.adept2.core.timemanager.storage.xmlstorage.XMLTimeManagerStorage;
import de.aristaflow.adept2.model.timemodel.TimeModelFactory;
import de.aristaflow.adept2.util.ArrayTools;
import java.net.URI;
import java.util.logging.Level;
import org.apache.commons.configuration.Configuration;

@ConfigurationDescription(properties={@Property(name="StorageDataDir", type=Property.Type.STRING, isRequired=true, description="Save Path for Time Manager Persistence.")})
public class DefaultTimeManager
extends AbstractADEPT2Service
implements TimeManager {
    private static final boolean TEST_MODE = false;
    private EventManager eventManager;
    private DefaultInstanceTimeManager instanceTimeManager;
    private DefaultTemplateTimeManager templateTimeManager;
    private DefaultInstanceTimeControlManager instanceTimeControlManager;
    private DefaultProcessExecutionManager processExecutionManager;
    private TimeModelFactory timeModelFactory;
    private TemporalProcessCheckService processModelChecks;
    private TimeModelCheckService timeModelChecks;
    private DefaultInstanceStarting instanceStarting;
    private DefaultInstanceTermination instanceTermination;
    private DefaultActivityStarting activityStarting;
    private DefaultActivityTermination activityTermination;
    private final Configuration configuration;
    private TimeModellingService timeModellingService;
    private ProcessManager processManager;
    private DefaultEscalationManager escalationManager;
    private ExecutionManager executionManager;
    private TimeAwareWorklistInteraction worklistInteraction;

    public DefaultTimeManager(Configuration configuration, Registry registry, String[] startupRequiredServices, String[] runtimeRequiredServices) {
        super(configuration, registry, (String[])ArrayTools.join((Object[][])new String[][]{startupRequiredServices, {"ComplexEventManager", "ProcessManager", "ExecutionManager"}}), runtimeRequiredServices);
        this.configuration = configuration;
        this.logger.log(Level.INFO, "Time Manager initialized");
    }

    public DefaultTimeManager(Configuration configuration, Registry registry) {
        this(configuration, registry, new String[0], new String[0]);
    }

    public void init(URI[] myURIs) throws AbortServiceException {
        super.init(myURIs, -2, -2, "password");
        SessionToken initSession = this.createSessionToken();
        try {
            this.eventManager = (EventManager)this.registry.getServiceOfType(initSession, "ComplexEventManager", EventManager.class);
        }
        catch (ServiceNotKnownException e) {
            throw new InternalServiceException(e.getMessage());
        }
        try {
            this.processManager = (ProcessManager)this.registry.getServiceOfType(initSession, "ProcessManager", ProcessManager.class);
        }
        catch (ServiceNotKnownException e) {
            throw new InternalServiceException(e.getMessage());
        }
        try {
            this.executionManager = (ExecutionManager)this.registry.getServiceOfType(initSession, "ExecutionManager", ExecutionManager.class);
        }
        catch (ServiceNotKnownException e) {
            throw new InternalServiceException(e.getMessage());
        }
        this.escalationManager = new DefaultEscalationManager(this.configuration, this.registry);
        this.timeModelFactory = (TimeModelFactory)this.registry.getModelFactory("TimeModelFactory", TimeModelFactory.class);
        TransientInstanceTimeModelStorage instanceTimeModelStorage = new TransientInstanceTimeModelStorage();
        TransientTemplateTimeStorage templateTimeStorage = new TransientTemplateTimeStorage();
        XMLTimeManagerStorage timeManagerStorage = new XMLTimeManagerStorage(this.configuration, this.timeModelFactory);
        this.templateTimeManager = new DefaultTemplateTimeManager(this, this.timeModelFactory, templateTimeStorage);
        this.instanceTimeManager = new DefaultInstanceTimeManager(this, this.timeModelFactory, this.templateTimeManager, instanceTimeModelStorage);
        this.timeModellingService = new DefaultTimeModellingService(this, this.timeModelFactory, this.templateTimeManager, timeManagerStorage);
        this.instanceStarting = new DefaultInstanceStarting(this, this.timeModelFactory, this.templateTimeManager, this.instanceTimeManager, this.escalationManager);
        this.instanceTermination = new DefaultInstanceTermination(this, this.instanceTimeManager);
        this.activityStarting = new DefaultActivityStarting(this, this.timeModelFactory, this.instanceTimeManager);
        this.activityTermination = new DefaultActivityTermination(this, this.timeModelFactory, this.instanceTimeManager);
        this.processExecutionManager = new DefaultProcessExecutionManager(this, this.instanceTimeManager, this.eventManager, this.instanceStarting, this.instanceTermination, this.activityStarting, this.activityTermination);
        this.instanceTimeControlManager = new DefaultInstanceTimeControlManager(this);
        this.worklistInteraction = new TimeAwareWorklistInteraction(this);
        this.processModelChecks = new DefaultTimedProcessModelCheckService(this.configuration, this.registry);
        this.timeModelChecks = new TCNTimModelCheckService(this.configuration, this.registry);
        this.escalationManager.init(myURIs);
        this.templateTimeManager.init();
        this.instanceTimeManager.init();
        this.instanceStarting.init();
        this.instanceTermination.init();
        this.activityStarting.init();
        this.activityTermination.init();
        this.processExecutionManager.init();
        this.instanceTimeControlManager.init();
        this.processModelChecks.init(myURIs);
        this.timeModelChecks.init(myURIs);
    }

    public void start() throws AbortServiceException {
        super.start();
        this.escalationManager.start();
        this.templateTimeManager.start();
        this.instanceTimeManager.start();
        this.instanceStarting.start();
        this.instanceTermination.start();
        this.activityStarting.start();
        this.activityTermination.start();
        this.processExecutionManager.start();
        this.instanceTimeControlManager.start();
    }

    public void shutdown() {
        this.escalationManager.shutdown();
        this.templateTimeManager.shutdown();
        this.instanceTimeManager.shutdown();
        this.instanceStarting.shutdown();
        this.instanceTermination.shutdown();
        this.activityStarting.shutdown();
        this.activityTermination.shutdown();
        this.processExecutionManager.shutdown();
        this.instanceTimeControlManager.shutdown();
        super.shutdown();
    }

    public void emergencyShutdown() {
        this.escalationManager.emergencyShutdown();
        this.templateTimeManager.emergencyShutdown();
        this.instanceTimeManager.emergencyShutdown();
        this.instanceStarting.emergencyShutdown();
        this.instanceTermination.emergencyShutdown();
        this.activityStarting.emergencyShutdown();
        this.activityTermination.emergencyShutdown();
        this.processExecutionManager.emergencyShutdown();
        this.instanceTimeControlManager.emergencyShutdown();
        super.emergencyShutdown();
    }

    @Override
    public InstanceTimeManager getInstanceTimeManager() {
        return this.instanceTimeManager;
    }

    @Override
    public TemplateTimeManager getTemplateTimeManager() {
        return this.templateTimeManager;
    }

    public TimeModelCheck[] getTimeModelChecks(SessionToken session) {
        TimeModelCheck checks = this.timeModelChecks.getExecutionProductionChecks();
        return new TimeModelCheck[]{checks};
    }

    public ProcessTemplateCheck[] getTemplateChecks(SessionToken session) {
        ProcessTemplateCheck checks = this.processModelChecks.getExecutionProductionChecks();
        return new ProcessTemplateCheck[]{this.processModelChecks.getProcessTemplateStructureChecks(), checks};
    }

    public SessionToken subSession(SessionToken parentSession) {
        this.checkAccessRights(parentSession);
        return this.getSessionFactory().getPrivilegedChildSession(parentSession, this.getURIs());
    }

    public Registry getDependencyRegistry() {
        return super.getDependencyRegistry();
    }

    private final void checkAccessRights(SessionToken sessionToken) {
        try {
            this.sessionFactory.checkIntegrity(sessionToken);
        }
        catch (SecurityTokenIntegrityException stie) {
            throw new ServiceAccessControlException("The designated session token failed the verification!", (Throwable)stie);
        }
    }

    @Override
    public TimeModellingService getTimeModellingService() {
        return this.timeModellingService;
    }

    public ProcessManager getProcessManager() {
        return this.processManager;
    }

    public ExecutionManager getExecutionManager() {
        return this.executionManager;
    }

    public SessionToken createSessionToken() {
        return super.createSessionToken();
    }

    @Override
    public WorklistInteraction getWorklistInteraction() {
        return this.worklistInteraction;
    }

    public WorklistAccess getWorklistAccess() {
        return this.worklistInteraction;
    }
}

