/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.timemanager.defaultimplementation;

import de.aristaflow.adept2.core.timemanager.ScheduleEvaluation;
import de.aristaflow.adept2.core.timemanager.ScheduleManager;
import de.aristaflow.adept2.core.timemanager.TimeModellingService;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.DefaultTemplateTimeManager;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.DefaultTimeManager;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.schedules.DefaultScheduleEvaluation;
import de.aristaflow.adept2.core.timemanager.storage.TimeManagerStorage;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemporalTemplate;
import de.aristaflow.adept2.model.timemodel.TemplateTimeModel;
import de.aristaflow.adept2.model.timemodel.TimeModelFactory;

public class DefaultTimeModellingService
implements TimeModellingService {
    private final TimeModelFactory timeModelFactory;
    private DefaultScheduleEvaluation scheduleEvaluation;
    private TimeManagerStorage timeManagerStorage;

    public DefaultTimeModellingService(DefaultTimeManager defaultTimeManager, TimeModelFactory timeModelFactory, DefaultTemplateTimeManager templateTimeManager, TimeManagerStorage timeManagerStorage) {
        this.timeModelFactory = timeModelFactory;
        this.timeManagerStorage = timeManagerStorage;
    }

    @Override
    public TemplateTimeModel createTimeModelForTemplate(Template template) {
        TemporalTemplate temporalTemplate = this.timeModelFactory.createTemporalTemplate(template);
        return this.timeModelFactory.createTimeModelForTemplate(temporalTemplate);
    }

    @Override
    public TimeModelFactory getTimeModelFactory() {
        return this.timeModelFactory;
    }

    @Override
    public ScheduleEvaluation getScheduleEvaluation() {
        if (this.scheduleEvaluation == null) {
            this.scheduleEvaluation = new DefaultScheduleEvaluation(this.timeManagerStorage);
        }
        return this.scheduleEvaluation;
    }

    @Override
    public ScheduleManager getScheduleManager() {
        if (this.scheduleEvaluation == null) {
            this.scheduleEvaluation = new DefaultScheduleEvaluation(this.timeManagerStorage);
        }
        return this.scheduleEvaluation;
    }
}

