/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.timemanager.defaultimplementation;

import de.aristaflow.adept2.core.timemanager.defaultimplementation.TriggerManager;
import de.aristaflow.adept2.util.Adept2ThreadFactory;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class DefaultTriggerManager
implements TriggerManager {
    protected final Logger logger = LoggerTools.getLogger((Object)this);
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(2, (ThreadFactory)new Adept2ThreadFactory("TriggerManager", this.logger));
    private final Map<TriggerManager.Trigger, ScheduledFuture<?>> triggers = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTrigger(TriggerManager.Trigger trigger) {
        if (this.convertTime(trigger.getTriggerTime()) <= 200L) {
            this.logger.info("Trigger date has already passed! Triggering now!");
            this.executor.execute(trigger.getRunnable());
            return;
        }
        Map<TriggerManager.Trigger, ScheduledFuture<?>> map = this.triggers;
        synchronized (map) {
            ScheduledFuture<?> schedule = this.executor.schedule(trigger.getRunnable(), this.convertTime(trigger.getTriggerTime()), TimeUnit.MILLISECONDS);
            this.triggers.put(trigger, schedule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelTrigger(TriggerManager.Trigger trigger) {
        Map<TriggerManager.Trigger, ScheduledFuture<?>> map = this.triggers;
        synchronized (map) {
            ScheduledFuture<?> scheduled = this.triggers.remove(trigger);
            if (scheduled != null) {
                scheduled.cancel(trigger.interruptOnCancel());
            }
        }
    }

    private long convertTime(long time) {
        return (time - System.currentTimeMillis() + 50L) / 100L * 100L;
    }

    @Override
    public void shutdown() {
        this.executor.shutdownNow();
        try {
            if (!this.executor.awaitTermination(10000L, TimeUnit.MILLISECONDS)) {
                this.logger.warning("Scheduler didn't terminate in time.");
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    public abstract class DefaultTrigger
    implements TriggerManager.Trigger {
        private final Runnable runnable;
        private final long triggerTime;
        private final boolean interruptOnCancel;

        public DefaultTrigger(long triggerTime, Runnable runnable, boolean interruptOnCancel) {
            this.triggerTime = triggerTime;
            this.runnable = runnable;
            this.interruptOnCancel = interruptOnCancel;
        }

        public DefaultTrigger(long triggerTime, Runnable runnable) {
            this(triggerTime, runnable, false);
        }

        @Override
        public Runnable getRunnable() {
            return this.runnable;
        }

        @Override
        public long getTriggerTime() {
            return this.triggerTime;
        }

        @Override
        public boolean interruptOnCancel() {
            return this.interruptOnCancel;
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof TriggerManager.Trigger) {
                return this.equals((TriggerManager.Trigger)other);
            }
            return false;
        }

        public abstract boolean equals(TriggerManager.Trigger var1);

        @Override
        public abstract int hashCode();
    }
}

