/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.timemanager.defaultimplementation;

import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.AbstractSubService;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.timemanager.WorklistInteraction;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.DefaultTimeManager;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.WorklistAccess;
import de.aristaflow.adept2.core.worklistmanager.WorklistNotification2;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public class TimeAwareWorklistInteraction
extends AbstractSubService
implements WorklistInteraction,
WorklistAccess {
    protected final Set<WorklistNotification2> worklistManagers = new HashSet<WorklistNotification2>();
    private DefaultTimeManager timeManager;

    public TimeAwareWorklistInteraction(DefaultTimeManager timeManager) {
        super(new String[0], new String[0], (AbstractADEPT2Service)timeManager);
        this.timeManager = timeManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWorklistManager(SessionToken session, WorklistNotification2 worklistManager) {
        Set<WorklistNotification2> set = this.worklistManagers;
        synchronized (set) {
            this.worklistManagers.add(worklistManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeWorklistManager(SessionToken session, WorklistNotification2 worklistManager) {
        Set<WorklistNotification2> set = this.worklistManagers;
        synchronized (set) {
            this.worklistManagers.remove(worklistManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<WorklistNotification2> getWorklistManagers() {
        HashSet<WorklistNotification2> ret;
        Set<WorklistNotification2> set = this.worklistManagers;
        synchronized (set) {
            ret = new HashSet<WorklistNotification2>(this.worklistManagers);
        }
        return Collections.unmodifiableSet(ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timeModelUpdated(SessionToken session, UUID instanceID) {
        System.out.println("Time Model Updated");
        super.sessionActive(session);
        try {
            Set<WorklistNotification2> wlManagers = this.getWorklistManagers();
            for (WorklistNotification2 worklistManager : wlManagers) {
                boolean worklistManagerPresent;
                Set<WorklistNotification2> set = this.worklistManagers;
                synchronized (set) {
                    worklistManagerPresent = this.worklistManagers.contains(worklistManager);
                }
                if (!worklistManagerPresent) continue;
                worklistManager.updateInstance(instanceID);
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }
}

