/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.timemanager.defaultimplementation.processexecution.defaultimplementation;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.AbstractSubService;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.DefaultInstanceTimeManager;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.DefaultTimeManager;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.WorklistAccess;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.processexecution.ActivityStarting;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.processexecution.defaultimplementation.TimeManagerTools;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.timemodelcontrol.TemporalExceptionHandling;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.timemodelcontrol.defaultimplementation.SysErrTemporalExceptionHandling;
import de.aristaflow.adept2.model.timemodel.ChangeableTimeModelStatus;
import de.aristaflow.adept2.model.timemodel.TimeModelFactory;
import de.aristaflow.adept2.model.timemodel.TimeModelStatus;
import de.aristaflow.adept2.model.timemodel.UpdateableInstanceTimeModel;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LockException;
import java.util.UUID;
import java.util.logging.Level;

public class DefaultActivityStarting
extends AbstractSubService
implements ActivityStarting {
    protected final DefaultInstanceTimeManager instanceTimeManager;
    protected final DefaultTimeManager timeManager;
    protected TemporalExceptionHandling temporalExceptionHandling;
    protected final TimeModelFactory timeModelFactory;

    public DefaultActivityStarting(DefaultTimeManager defaultTimeManager, TimeModelFactory timeModelFactory, DefaultInstanceTimeManager instanceTimeManager) {
        super((AbstractADEPT2Service)defaultTimeManager);
        this.timeManager = defaultTimeManager;
        this.timeModelFactory = timeModelFactory;
        this.instanceTimeManager = instanceTimeManager;
    }

    public void init() throws AbortServiceException {
        super.init();
        this.temporalExceptionHandling = new SysErrTemporalExceptionHandling();
    }

    private SessionToken subSession(SessionToken parentSession) {
        return this.timeManager.subSession(parentSession);
    }

    @Override
    public void activityStarted(SessionToken session, UUID instanceID, int nodeID, int iteration, long timestamp) {
        System.out.println(String.format("Activity (%1$d, %2$d) Started @ %3$d-> Updating Time Model", nodeID, iteration, timestamp));
        try {
            SessionToken childSession;
            ChangeableTimeModelStatus status;
            block14: {
                status = this.instanceTimeManager.getAndLockTimeModelStatus(session, instanceID);
                try {
                    if (status.getTimeModelUpdateStatus().ordinal() >= TimeModelStatus.TimeModelUpdateStatus.DISABLED.ordinal()) break block14;
                    childSession = this.subSession(session);
                    try {
                        UpdateableInstanceTimeModel timeModel = this.instanceTimeManager.getAndLockTimeModel(childSession, instanceID);
                        try {
                            timeModel.setActivityInstanceStartTime(nodeID, iteration, timestamp);
                            this.instanceTimeManager.updateTimeModel(childSession, timeModel);
                            if (status.getTimeModelUpdateStatus().ordinal() < TimeModelStatus.TimeModelUpdateStatus.NO_CALCULATION.ordinal()) {
                                boolean stateChanged = TimeManagerTools.updateTimeModel(childSession, this.timeModelFactory, timeModel, status, this.temporalExceptionHandling);
                                if (stateChanged) {
                                    this.instanceTimeManager.updateTimeModelStatus(childSession, status);
                                }
                                this.instanceTimeManager.updateTimeModel(childSession, timeModel);
                            }
                            this.handleValidityPeriodAtActivityStart(childSession, instanceID, timestamp, status);
                        }
                        finally {
                            this.instanceTimeManager.unlockTimeModel(childSession, instanceID);
                        }
                    }
                    catch (LockException e) {
                        this.logger.log(Level.SEVERE, "Lock Exception", e);
                    }
                    catch (DataSourceException e) {
                        this.logger.log(Level.SEVERE, "Data Source Exception", e);
                    }
                }
                finally {
                    this.instanceTimeManager.unlockTimeModelStatus(session, instanceID);
                }
            }
            if (status.getTimeModelUpdateStatus().ordinal() <= TimeModelStatus.TimeModelUpdateStatus.NO_UPDATE.ordinal()) {
                childSession = this.subSession(session);
                this.handleActivityDuration(childSession, instanceID, timestamp);
            }
            WorklistAccess notification = this.timeManager.getWorklistAccess();
            notification.timeModelUpdated(session, instanceID);
        }
        catch (LockException e) {
            this.logger.log(Level.SEVERE, "Lock Exception", e);
        }
    }

    private void handleActivityDuration(SessionToken childSession, UUID instanceID, long timestamp) {
    }

    private void handleValidityPeriodAtActivityStart(SessionToken childSession, UUID instanceID, long timestamp, ChangeableTimeModelStatus status) {
    }
}

