/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.timemanager.defaultimplementation.processexecution.defaultimplementation;

import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.AbstractSubService;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.DefaultInstanceTimeManager;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.DefaultTimeManager;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.processexecution.ActivityStarting;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.processexecution.ActivityStateUpdateManager;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.processexecution.ActivityTermination;
import de.aristaflow.adept2.model.timemodel.UpdateableInstanceTimeContext;
import de.aristaflow.adept2.util.Adept2ThreadFactory;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LockException;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class DefaultActivityStateUpdateManager
extends AbstractSubService
implements ActivityStateUpdateManager {
    private ActivityStarting activityStarting;
    private ActivityTermination activityTermination;
    private DefaultInstanceTimeManager instanceTimeManager;
    private ExecutorService executorService;

    public DefaultActivityStateUpdateManager(DefaultTimeManager timeManager, DefaultInstanceTimeManager instanceTimeManager, ActivityStarting activityStarting, ActivityTermination activityTermination) {
        super((AbstractADEPT2Service)timeManager);
        this.instanceTimeManager = instanceTimeManager;
        this.activityStarting = activityStarting;
        this.activityTermination = activityTermination;
    }

    public void init() {
        this.executorService = Executors.newCachedThreadPool((ThreadFactory)new Adept2ThreadFactory("ActivityStateUpdate", this.logger));
    }

    private void awaitExecutorServiceShutdown() {
        boolean terminated = false;
        while (!terminated) {
            try {
                terminated = this.executorService.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void emergencyShutdown() {
        this.executorService.shutdown();
        this.awaitExecutorServiceShutdown();
        super.emergencyShutdown();
    }

    public void shutdown() {
        this.executorService.shutdownNow();
        this.awaitExecutorServiceShutdown();
        super.shutdown();
    }

    @Override
    public void activityStarted(final SessionToken session, final UUID instanceID, final int nodeID, final int iteration, final long timestamp) {
        try {
            UpdateableInstanceTimeContext timeContext = this.instanceTimeManager.getAndLockInstanceTimeContext(session, instanceID);
            try {
                timeContext.setActivityStarted(nodeID, iteration, timestamp);
                this.instanceTimeManager.updateInstanceTimeContext(session, timeContext);
            }
            finally {
                this.instanceTimeManager.unlockInstanceTimeContext(session, instanceID);
            }
        }
        catch (DataSourceException e) {
            this.logger.log(Level.SEVERE, "DataSourceException", e);
        }
        catch (LockException e) {
            this.logger.log(Level.SEVERE, "LockException", e);
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultActivityStateUpdateManager.this.activityStarting.activityStarted(session, instanceID, nodeID, iteration, timestamp);
                }
                catch (Exception e) {
                    DefaultActivityStateUpdateManager.this.logger.log(Level.SEVERE, "An error occurred", e);
                }
            }
        });
    }

    @Override
    public void activityFinished(final SessionToken session, final UUID instanceID, final int nodeID, final int iteration, final long timestamp) {
        try {
            UpdateableInstanceTimeContext timeContext = this.instanceTimeManager.getAndLockInstanceTimeContext(session, instanceID);
            try {
                timeContext.setActivityFinished(nodeID, iteration, timestamp);
                this.instanceTimeManager.updateInstanceTimeContext(session, timeContext);
            }
            finally {
                this.instanceTimeManager.unlockInstanceTimeContext(session, instanceID);
            }
        }
        catch (DataSourceException e) {
            this.logger.log(Level.SEVERE, "DataSourceException", e);
        }
        catch (LockException e) {
            this.logger.log(Level.SEVERE, "LockException", e);
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                DefaultActivityStateUpdateManager.this.activityTermination.activityFinished(session, instanceID, nodeID, iteration, timestamp);
            }
        });
    }
}

