/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.timemanager.defaultimplementation.processexecution.defaultimplementation;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.AbstractSubService;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.processmanager.InstanceManager;
import de.aristaflow.adept2.core.processmanager.ProcessManager;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.DefaultInstanceTimeManager;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.DefaultTimeManager;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.WorklistAccess;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.processexecution.ActivityTermination;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.processexecution.defaultimplementation.TimeManagerTools;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.timemodelcontrol.TemporalExceptionHandling;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.timemodelcontrol.defaultimplementation.SysErrTemporalExceptionHandling;
import de.aristaflow.adept2.model.globals.TimeModelConstants;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.TemporalNode;
import de.aristaflow.adept2.model.processmodel.TemporalTemplate;
import de.aristaflow.adept2.model.processmodel.timemodel.FixedDate;
import de.aristaflow.adept2.model.processmodel.timemodel.FixedDateUpdateHandler;
import de.aristaflow.adept2.model.processmodel.timemodel.FixedDateUpdateProcedureData;
import de.aristaflow.adept2.model.processmodel.timemodel.defaultimplementation.DefaultFixedDateUpdateMeasures;
import de.aristaflow.adept2.model.processmodel.timemodel.updatehandlers.UpdateHandlerRegistry;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.model.timemodel.ChangeableTimeModelStatus;
import de.aristaflow.adept2.model.timemodel.InstanceTimeModel;
import de.aristaflow.adept2.model.timemodel.TimeModelFactory;
import de.aristaflow.adept2.model.timemodel.TimeModelStatus;
import de.aristaflow.adept2.model.timemodel.UpdateableInstanceTimeModel;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LockException;
import java.net.URI;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;

public class DefaultActivityTermination
extends AbstractSubService
implements ActivityTermination {
    private DefaultTimeManager timeManager;
    private DefaultInstanceTimeManager instanceTimeManager;
    private TimeModelFactory timeModelFactory;
    private TemporalExceptionHandling temporalExceptionHandling;

    public DefaultActivityTermination(DefaultTimeManager defaultTimeManager, TimeModelFactory timeModelFactory, DefaultInstanceTimeManager instanceTimeManager) {
        super((AbstractADEPT2Service)defaultTimeManager);
        this.timeManager = defaultTimeManager;
        this.timeModelFactory = timeModelFactory;
        this.instanceTimeManager = instanceTimeManager;
    }

    public void init() throws AbortServiceException {
        super.init();
        this.temporalExceptionHandling = new SysErrTemporalExceptionHandling();
    }

    private SessionToken subSession(SessionToken parentSession) {
        return this.timeManager.subSession(parentSession);
    }

    @Override
    public void activityFinished(SessionToken session, UUID instanceID, int nodeID, int iteration, long timestamp) {
        System.out.println(String.format("Activity (%1$d, %2$d) Finished @ %3$d-> Updating Time Model", nodeID, iteration, timestamp));
        try {
            SessionToken childSession;
            ChangeableTimeModelStatus status = this.instanceTimeManager.getAndLockTimeModelStatus(session, instanceID);
            try {
                if (status.getTimeModelUpdateStatus().ordinal() < TimeModelStatus.TimeModelUpdateStatus.DISABLED.ordinal()) {
                    childSession = this.subSession(session);
                    this.updateTimeModel(childSession, instanceID, nodeID, iteration, timestamp, status);
                }
            }
            finally {
                this.instanceTimeManager.unlockTimeModelStatus(session, instanceID);
            }
            if (status.getTimeModelUpdateStatus().ordinal() <= TimeModelStatus.TimeModelUpdateStatus.NO_UPDATE.ordinal()) {
                childSession = this.subSession(session);
                this.handleActivityDuration(childSession, instanceID, timestamp);
            }
            if (status.getTimeModelUpdateStatus().ordinal() < TimeModelStatus.TimeModelUpdateStatus.DISABLED.ordinal()) {
                childSession = this.subSession(session);
                this.handleTriggerEvents(childSession, instanceID, nodeID);
            }
            WorklistAccess notification = this.timeManager.getWorklistAccess();
            notification.timeModelUpdated(session, instanceID);
        }
        catch (LockException e) {
            this.logger.log(Level.SEVERE, "Lock Exception", e);
        }
    }

    private void updateTimeModel(SessionToken session, UUID instanceID, int nodeID, int iteration, long timestamp, ChangeableTimeModelStatus status) {
        try {
            UpdateableInstanceTimeModel timeModel = this.instanceTimeManager.getAndLockTimeModel(session, instanceID);
            try {
                timeModel.setActivityInstanceFinishTime(nodeID, iteration, timestamp);
                this.instanceTimeManager.updateTimeModel(session, timeModel);
                if (status.getTimeModelUpdateStatus().ordinal() < TimeModelStatus.TimeModelUpdateStatus.NO_CALCULATION.ordinal()) {
                    boolean stateChanged = TimeManagerTools.updateTimeModel(session, this.timeModelFactory, timeModel, status, this.temporalExceptionHandling);
                    if (stateChanged) {
                        this.instanceTimeManager.updateTimeModelStatus(session, status);
                    }
                    this.instanceTimeManager.updateTimeModel(session, timeModel);
                }
                this.handleValidityPeriodAtActivityTermination(session, instanceID, timestamp, status);
            }
            finally {
                this.instanceTimeManager.unlockTimeModel(session, instanceID);
            }
        }
        catch (LockException e) {
            this.logger.log(Level.SEVERE, "Lock Exception", e);
        }
        catch (DataSourceException e) {
            this.logger.log(Level.SEVERE, "Data Source Exception", e);
        }
    }

    private void handleTriggerEvents(SessionToken session, UUID instanceID, int nodeID) {
        try {
            InstanceTimeModel timeModel = this.instanceTimeManager.getInstanceTimeModelReadonly(session, instanceID);
            List<URI> updateTrigger = timeModel.getUpdateTrigger(nodeID);
            for (URI trigger : updateTrigger) {
                String elementType = ProcessElementIdentifierTools.getElementType((URI)trigger);
                if ("node".equals(elementType)) {
                    String targetNodeIDString = ProcessElementIdentifierTools.getElementID((URI)trigger);
                    int targetNodeID = Integer.parseInt(targetNodeIDString);
                    String field = ProcessElementIdentifierTools.getField((URI)trigger);
                    this.updateNodeField(session, instanceID, targetNodeID, field, trigger);
                    continue;
                }
                this.logger.log(Level.SEVERE, "Update trigger target is not a node: %s", trigger);
            }
        }
        catch (DataSourceException e) {
            this.logger.log(Level.SEVERE, "Data Source Exception", e);
        }
    }

    private void updateNodeField(SessionToken session, UUID instanceID, int targetNodeID, String field, URI trigger) {
        try {
            UpdateableInstanceTimeModel timeModel = this.instanceTimeManager.getAndLockTimeModel(session, instanceID);
            try {
                ProcessManager processManager = this.timeManager.getProcessManager();
                InstanceManager instanceManager = processManager.getInstanceManager();
                Instance instance = instanceManager.getInstance(session, instanceID);
                TemporalTemplate template = this.timeModelFactory.createTemporalTemplate(instance.getTemplate());
                TemporalNode node = template.getNode(targetNodeID);
                if ("startFixedDate".equals(field)) {
                    FixedDate fixedDate = node.getStartFixedDate();
                    if (fixedDate != null) {
                        this.updateFixedDate(session, targetNodeID, trigger, timeModel, instance, fixedDate, TimeModelConstants.ReferencePoint.START);
                    }
                } else if ("completionFixedDate".equals(field)) {
                    FixedDate fixedDate = node.getCompletionFixedDate();
                    if (fixedDate != null) {
                        this.updateFixedDate(session, targetNodeID, trigger, timeModel, instance, fixedDate, TimeModelConstants.ReferencePoint.COMPLETION);
                    }
                } else {
                    this.logger.log(Level.SEVERE, "Unkown field to be updated!", field);
                }
            }
            finally {
                try {
                    this.instanceTimeManager.unlockTimeModel(session, instanceID);
                }
                catch (LockException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (DataSourceException e) {
            e.printStackTrace();
        }
    }

    private void updateFixedDate(SessionToken session, int targetNodeID, URI trigger, UpdateableInstanceTimeModel timeModel, Instance instance, FixedDate fixedDate, TimeModelConstants.ReferencePoint referencePoint) {
        String procedureID;
        FixedDateUpdateHandler updateHandler;
        FixedDateUpdateProcedureData updateProcedureData = fixedDate.getFixedDateUpdateProcedure();
        if (updateProcedureData != null && (updateHandler = UpdateHandlerRegistry.getFixedDateUpdateHandler(procedureID = updateProcedureData.getProcedureID())) != null) {
            int nodeIteration = instance.getNodeIteration(targetNodeID);
            DefaultFixedDateUpdateMeasures updateMeasures = new DefaultFixedDateUpdateMeasures(this.timeManager.getDependencyRegistry(), this.timeManager.getExecutionManager(), instance, timeModel, targetNodeID, nodeIteration, fixedDate, referencePoint);
            updateHandler.updateFixedDate(session, targetNodeID, nodeIteration, trigger, updateProcedureData, updateMeasures);
        }
    }

    private void handleActivityDuration(SessionToken session, UUID instanceID, long timestamp) {
    }

    private void handleValidityPeriodAtActivityTermination(SessionToken session, UUID instanceID, long timestamp, ChangeableTimeModelStatus status) {
    }
}

