/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.timemanager.defaultimplementation.processexecution.defaultimplementation;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.AbstractSubService;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.DefaultInstanceTimeManager;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.DefaultTemplateTimeManager;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.DefaultTimeManager;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.WorklistAccess;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.escalation.EscalationManager;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.processexecution.InstanceStarting;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.processexecution.defaultimplementation.TimeManagerTools;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.timemodelcontrol.TemporalExceptionHandling;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.timemodelcontrol.defaultimplementation.SysErrTemporalExceptionHandling;
import de.aristaflow.adept2.model.common.timedata.CalendarElement;
import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.processmodel.TemporalTemplate;
import de.aristaflow.adept2.model.processmodel.timemodel.ProcessDuration;
import de.aristaflow.adept2.model.processmodel.timemodel.ValidityPeriod;
import de.aristaflow.adept2.model.timemodel.ChangeableTimeModelStatus;
import de.aristaflow.adept2.model.timemodel.InstanceTimeModel;
import de.aristaflow.adept2.model.timemodel.Interval;
import de.aristaflow.adept2.model.timemodel.TimeModelFactory;
import de.aristaflow.adept2.model.timemodel.TimeModelOperations;
import de.aristaflow.adept2.model.timemodel.TimeModelStatus;
import de.aristaflow.adept2.model.timemodel.UpdateableInstanceTimeModel;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LockException;
import java.util.UUID;
import java.util.logging.Level;

public class DefaultInstanceStarting
extends AbstractSubService
implements InstanceStarting {
    protected final DefaultTemplateTimeManager templateTimeManager;
    protected final DefaultInstanceTimeManager instanceTimeManager;
    protected TimeModelOperations timeModelTools;
    protected EscalationManager escalationManager;
    protected final TimeModelFactory timeModelFactory;
    protected TemporalExceptionHandling temporalExceptionHandling;
    protected final DefaultTimeManager timeManager;

    public DefaultInstanceStarting(DefaultTimeManager timeManager, TimeModelFactory timeModelFactory, DefaultTemplateTimeManager templateTimeManager, DefaultInstanceTimeManager instanceTimeManager, EscalationManager escalationManager) {
        super((AbstractADEPT2Service)timeManager);
        this.logger.setLevel(Level.ALL);
        this.timeManager = timeManager;
        this.timeModelFactory = timeModelFactory;
        this.templateTimeManager = templateTimeManager;
        this.instanceTimeManager = instanceTimeManager;
        this.escalationManager = escalationManager;
    }

    public void init() throws AbortServiceException {
        super.init();
        this.timeModelTools = this.timeModelFactory.getTimeModelOperations();
        this.temporalExceptionHandling = new SysErrTemporalExceptionHandling();
    }

    @Override
    public void instanceCreated(SessionToken parentSession, UUID templateID, UUID instanceID, long timestamp) {
        this.logger.entering(this.logger.getName(), "instanceCreated(SessionToken,UUID,UUID,long)");
        System.out.println("instanceCreated(" + instanceID + ")");
        SessionToken session = this.subSession(parentSession);
        ChangeableTimeModelStatus status = this.instanceTimeManager.getAndLockTimeModelStatus(session, instanceID);
        try {
            try {
                SessionToken childSession = this.subSession(session);
                this.instantiateTimeModel(childSession, templateID, instanceID, timestamp, status);
                if (status.getTimeModelUpdateStatus().ordinal() < TimeModelStatus.TimeModelUpdateStatus.NO_UPDATE.ordinal()) {
                    this.initializeInstanceExecution(childSession, instanceID, status);
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            try {
                try {
                    this.instanceTimeManager.updateTimeModelStatus(session, status);
                }
                finally {
                    this.instanceTimeManager.unlockTimeModelStatus(session, instanceID);
                }
            }
            catch (LockException e) {
                this.logger.log(Level.SEVERE, "LockException", e);
            }
        }
    }

    private SessionToken subSession(SessionToken parentSession) {
        return this.timeManager.subSession(parentSession);
    }

    private void instantiateTimeModel(SessionToken parentSession, UUID templateID, UUID instanceID, long timestamp, ChangeableTimeModelStatus status) {
        block12: {
            System.out.println("instantiateTimeModel(" + instanceID + ")");
            SessionToken session = this.subSession(parentSession);
            UpdateableInstanceTimeModel timeModel = null;
            status.setTimeModelUpdateStatus(TimeModelStatus.TimeModelUpdateStatus.ENABLED, null);
            status.setTimeModelStatus(TimeModelStatus.TimeModelState.UNKOWN);
            this.handleValidityPeriodAtProcessCreate(this.subSession(parentSession), templateID, timestamp, status);
            if (status.getTimeModelUpdateStatus().ordinal() < TimeModelStatus.TimeModelUpdateStatus.DISABLED.ordinal()) {
                timeModel = this.createTimeModel(session, templateID, instanceID, status);
            }
            if (timeModel != null) {
                System.out.println("Time Model for instance " + instanceID + " successfully created.");
                try {
                    try {
                        if (status.getTimeModelUpdateStatus().ordinal() >= TimeModelStatus.TimeModelUpdateStatus.DISABLED.ordinal()) break block12;
                        timeModel.setInstanceCreationTime(timestamp - 1000L);
                        this.instanceTimeManager.updateTimeModel(session, timeModel);
                        if (status.getTimeModelUpdateStatus().ordinal() < TimeModelStatus.TimeModelUpdateStatus.NO_CALCULATION.ordinal()) {
                            this.updateConstraints(session, timeModel, 0);
                            boolean stateChanged = TimeManagerTools.updateTimeModel(session, this.timeModelFactory, timeModel, status, this.temporalExceptionHandling);
                            if (stateChanged) {
                                this.instanceTimeManager.updateTimeModelStatus(session, status);
                            }
                            this.instanceTimeManager.updateTimeModel(session, timeModel);
                            System.out.println("Time Model for instance " + instanceID + " successfully initialized.");
                        }
                    }
                    finally {
                        this.instanceTimeManager.unlockTimeModel(session, instanceID);
                    }
                }
                catch (LockException e) {
                    this.logger.log(Level.SEVERE, "Lock Exception", e);
                }
            } else {
                assert (status.getTimeModelStatus().equals((Object)TimeModelStatus.TimeModelState.INVALID));
                assert (status.getTimeModelUpdateStatus().equals((Object)TimeModelStatus.TimeModelUpdateStatus.DISABLED));
            }
        }
    }

    private void handleValidityPeriodAtProcessCreate(SessionToken session, UUID templateID, long creationTimeStamp, ChangeableTimeModelStatus currentStatus) {
        ProcessDuration processDuration;
        TemporalTemplate template = this.templateTimeManager.getTemplate(session, templateID);
        ValidityPeriod validityPeriod = template.getStartValidityPeriod();
        if (validityPeriod != null) {
            String msg;
            if (this.timeModelTools.compare(validityPeriod.getValidFrom(), creationTimeStamp) > 0) {
                msg = String.format("Template '%1$s' not valid until %2$s!", templateID, validityPeriod.getValidFrom());
                this.logger.severe(msg);
                TimeManagerTools.downgradeUpdateStatus(currentStatus, TimeModelStatus.TimeModelUpdateStatus.NO_CALCULATION, msg);
            }
            if (this.timeModelTools.compare(validityPeriod.getValidUntil(), creationTimeStamp) < 0) {
                msg = String.format("Template '%1$s' only valid until %2$s!", templateID, validityPeriod.getValidUntil());
                this.logger.severe(msg);
                TimeManagerTools.downgradeUpdateStatus(currentStatus, TimeModelStatus.TimeModelUpdateStatus.NO_CALCULATION, msg);
            }
        }
        if ((validityPeriod = template.getCompletionValidityPeriod()) != null && (processDuration = template.getProcessDuration()) != null) {
            CalendarElement earliestProcessEnd = this.timeModelTools.add(creationTimeStamp, processDuration.getMinimumDuration());
            if (this.timeModelTools.compare(validityPeriod.getValidFrom(), earliestProcessEnd) > 0) {
                String msg = String.format("Template '%1$s' may not be completed before %2$s!", templateID, validityPeriod.getValidFrom());
                this.logger.severe(msg);
                TimeManagerTools.downgradeUpdateStatus(currentStatus, TimeModelStatus.TimeModelUpdateStatus.NO_CALCULATION, msg);
            }
            CalendarElement latestProcessEnd = this.timeModelTools.add(creationTimeStamp, processDuration.getMaximumDuration());
            if (this.timeModelTools.compare(validityPeriod.getValidUntil(), latestProcessEnd) < 0) {
                String msg = String.format("Template '%1$s' may not be completed after %2$s!", templateID, validityPeriod.getValidUntil());
                this.logger.severe(msg);
                TimeManagerTools.downgradeUpdateStatus(currentStatus, TimeModelStatus.TimeModelUpdateStatus.NO_CALCULATION, msg);
            }
        }
    }

    private UpdateableInstanceTimeModel createTimeModel(SessionToken session, UUID templateID, UUID instanceID, ChangeableTimeModelStatus status) {
        UpdateableInstanceTimeModel timeModel = null;
        CheckReport checkReport = new CheckReport(this.getURIs()[0]);
        try {
            timeModel = this.instanceTimeManager.createAndLockInstanceTimeModel(session, templateID, instanceID, checkReport);
        }
        catch (DataSourceException e) {
            this.logger.log(Level.SEVERE, "DataSourceException while trying to create Instance Time Model", e);
            TimeManagerTools.updateStatus(status, TimeModelStatus.TimeModelState.INVALID, TimeModelStatus.TimeModelUpdateStatus.DISABLED, "Unable to create Instance Time Model due to a DataSourceException!");
        }
        if (checkReport.getCheckResult().ordinal() > CheckReport.ResultType.WARNING.ordinal()) {
            String msg = String.format("Invalid Time Specification of Process Template %1$s! Reason:\n %2$s", templateID, checkReport.getReportSummary());
            this.logger.warning(msg);
            TimeManagerTools.updateStatus(status, TimeModelStatus.TimeModelState.INVALID, TimeModelStatus.TimeModelUpdateStatus.DISABLED, msg);
        }
        return timeModel;
    }

    private void initializeInstanceExecution(SessionToken parentSession, UUID instanceID, ChangeableTimeModelStatus status) {
        SessionToken session = this.subSession(parentSession);
        if (status.getTimeModelUpdateStatus().ordinal() < TimeModelStatus.TimeModelUpdateStatus.NO_UPDATE.ordinal()) {
            InstanceTimeModel timeModel;
            try {
                timeModel = this.instanceTimeManager.getInstanceTimeModelReadonly(session, instanceID);
            }
            catch (DataSourceException e) {
                this.logger.log(Level.SEVERE, "DataSourceException", e);
                return;
            }
            this.handleInstanceStartTime(timeModel);
            this.evaluateAndHandleValidityPeriod(timeModel);
            this.initializeRuntimeModel(timeModel);
        }
    }

    private void initializeRuntimeModel(InstanceTimeModel timeModel) {
    }

    private void evaluateAndHandleValidityPeriod(InstanceTimeModel timeModel) {
    }

    private void updateConstraints(SessionToken session, UpdateableInstanceTimeModel timeModel, int processInstantiationEvent) {
    }

    @Override
    public void instanceStarted(SessionToken session, UUID instanceID, long timestamp) {
        System.out.println(String.format("Instance (%1$s) Started @ %2$d -> Updating Time Model", instanceID, timestamp));
        try {
            SessionToken childSession;
            ChangeableTimeModelStatus status;
            block14: {
                status = this.instanceTimeManager.getAndLockTimeModelStatus(session, instanceID);
                System.out.println(String.format("Instance locked (%1$s)", instanceID, timestamp));
                try {
                    if (status.getTimeModelUpdateStatus().ordinal() >= TimeModelStatus.TimeModelUpdateStatus.DISABLED.ordinal()) break block14;
                    childSession = this.subSession(session);
                    try {
                        UpdateableInstanceTimeModel timeModel = this.instanceTimeManager.getAndLockTimeModel(childSession, instanceID);
                        try {
                            timeModel.setInstanceStartTime(timestamp);
                            this.instanceTimeManager.updateTimeModel(childSession, timeModel);
                            if (status.getTimeModelUpdateStatus().ordinal() < TimeModelStatus.TimeModelUpdateStatus.NO_CALCULATION.ordinal()) {
                                System.out.println(String.format("Updating Time Model of Instance (%1$s) @ %2$d", instanceID, timestamp));
                                boolean stateChanged = TimeManagerTools.updateTimeModel(session, this.timeModelFactory, timeModel, status, this.temporalExceptionHandling);
                                if (stateChanged) {
                                    this.instanceTimeManager.updateTimeModelStatus(session, status);
                                }
                                this.instanceTimeManager.updateTimeModel(childSession, timeModel);
                            }
                            this.handleValidityPeriodAtProcessStart(childSession, instanceID, timestamp, status);
                        }
                        finally {
                            this.instanceTimeManager.unlockTimeModel(childSession, instanceID);
                        }
                    }
                    catch (LockException e) {
                        this.logger.log(Level.SEVERE, "Lock Exception", e);
                    }
                    catch (DataSourceException e) {
                        this.logger.log(Level.SEVERE, "Data Source Exception", e);
                    }
                }
                finally {
                    this.instanceTimeManager.unlockTimeModelStatus(session, instanceID);
                }
            }
            if (status.getTimeModelUpdateStatus().ordinal() <= TimeModelStatus.TimeModelUpdateStatus.NO_UPDATE.ordinal()) {
                childSession = this.subSession(session);
                this.handleProcessDuration(childSession, instanceID, timestamp);
            }
            WorklistAccess notification = this.timeManager.getWorklistAccess();
            notification.timeModelUpdated(session, instanceID);
        }
        catch (LockException e) {
            this.logger.log(Level.SEVERE, "Lock Exception", e);
            throw new RuntimeException(e);
        }
    }

    private void handleProcessDuration(SessionToken session, UUID instanceID, long timestamp) {
    }

    private void handleInstanceStartTime(InstanceTimeModel timeModel) {
        timeModel.getInstanceStartTimeframe();
    }

    private void handleValidityPeriodAtProcessStart(SessionToken session, UUID instanceID, long creationTimeStamp, ChangeableTimeModelStatus currentStatus) throws LockException, DataSourceException {
        Interval<TimeDistance> processDuration;
        InstanceTimeModel instanceTimeModel = this.instanceTimeManager.getInstanceTimeModelReadonly(session, instanceID);
        UUID templateID = instanceTimeModel.getBaseTemplateID();
        TemporalTemplate template = this.templateTimeManager.getTemplate(session, templateID);
        ValidityPeriod validityPeriod = template.getStartValidityPeriod();
        if (validityPeriod != null) {
            String msg;
            if (this.timeModelTools.compare(validityPeriod.getValidFrom(), creationTimeStamp) > 0) {
                msg = String.format("Instance '%1$s' not valid until %2$s!", instanceID, validityPeriod.getValidFrom());
                this.logger.warning(msg);
                TimeManagerTools.downgradeUpdateStatus(currentStatus, TimeModelStatus.TimeModelUpdateStatus.NO_CALCULATION, msg);
                this.instanceTimeManager.updateTimeModelStatus(session, currentStatus);
            }
            if (this.timeModelTools.compare(validityPeriod.getValidUntil(), creationTimeStamp) < 0) {
                msg = String.format("Instance '%1$s' only valid until %2$s!", instanceID, validityPeriod.getValidUntil());
                this.logger.warning(msg);
                TimeManagerTools.downgradeUpdateStatus(currentStatus, TimeModelStatus.TimeModelUpdateStatus.NO_CALCULATION, msg);
                this.instanceTimeManager.updateTimeModelStatus(session, currentStatus);
            }
        }
        if ((validityPeriod = template.getCompletionValidityPeriod()) != null && (processDuration = this.getProcessInstanceDuration(session, instanceID)) != null) {
            CalendarElement earliestProcessEnd = this.timeModelTools.add(creationTimeStamp, processDuration.getMinValue());
            if (this.timeModelTools.compare(validityPeriod.getValidFrom(), earliestProcessEnd) > 0) {
                String msg = String.format("Template '%1$s' may not be completed before %2$s!", instanceID, validityPeriod.getValidFrom());
                this.logger.warning(msg);
                TimeManagerTools.downgradeUpdateStatus(currentStatus, TimeModelStatus.TimeModelUpdateStatus.NO_CALCULATION, msg);
                this.instanceTimeManager.updateTimeModelStatus(session, currentStatus);
            }
            CalendarElement latestProcessEnd = this.timeModelTools.add(creationTimeStamp, processDuration.getMaxValue());
            if (this.timeModelTools.compare(validityPeriod.getValidUntil(), latestProcessEnd) < 0) {
                String msg = String.format("Template '%1$s' may not be completed after %2$s!", instanceID, validityPeriod.getValidUntil());
                this.logger.warning(msg);
                TimeManagerTools.downgradeUpdateStatus(currentStatus, TimeModelStatus.TimeModelUpdateStatus.NO_CALCULATION, msg);
                this.instanceTimeManager.updateTimeModelStatus(session, currentStatus);
            }
        }
    }

    private Interval<TimeDistance> getProcessInstanceDuration(SessionToken session, UUID instanceID) throws DataSourceException {
        InstanceTimeModel timeModel = this.instanceTimeManager.getInstanceTimeModelReadonly(session, instanceID);
        return timeModel.getInstanceDuration();
    }
}

