/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.timemanager.defaultimplementation.processexecution.defaultimplementation;

import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.AbstractSubService;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.DefaultInstanceTimeManager;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.DefaultTimeManager;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.processexecution.InstanceStarting;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.processexecution.InstanceStateUpdateManager;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.processexecution.InstanceTermination;
import de.aristaflow.adept2.model.timemodel.UpdateableInstanceTimeContext;
import de.aristaflow.adept2.util.Adept2ThreadFactory;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LockException;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class DefaultInstanceStateUpdateManager
extends AbstractSubService
implements InstanceStateUpdateManager {
    private InstanceStarting instanceStarting;
    private InstanceTermination instanceTermination;
    private DefaultInstanceTimeManager instanceTimeManager;
    private ExecutorService executorService;

    public DefaultInstanceStateUpdateManager(DefaultTimeManager timeManager, DefaultInstanceTimeManager instanceTimeManager, InstanceStarting instanceStarting, InstanceTermination instanceTermination) {
        super((AbstractADEPT2Service)timeManager);
        this.instanceTimeManager = instanceTimeManager;
        this.instanceStarting = instanceStarting;
        this.instanceTermination = instanceTermination;
    }

    public void init() {
        this.executorService = Executors.newCachedThreadPool((ThreadFactory)new Adept2ThreadFactory("InstanceStateUpdate", this.logger));
    }

    private void awaitExecutorServiceShutdown() {
        boolean terminated = false;
        while (!terminated) {
            try {
                terminated = this.executorService.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void emergencyShutdown() {
        this.executorService.shutdown();
        this.awaitExecutorServiceShutdown();
        super.emergencyShutdown();
    }

    public void shutdown() {
        this.executorService.shutdownNow();
        this.awaitExecutorServiceShutdown();
        super.shutdown();
    }

    @Override
    public void instanceCreated(final SessionToken session, final UUID templateID, final UUID instanceID, final long timestamp) {
        try {
            UpdateableInstanceTimeContext timeContext = this.instanceTimeManager.createAndLockInstanceTimeContext(session, instanceID);
            try {
                timeContext.setInstanceCreated(timestamp);
                this.instanceTimeManager.updateInstanceTimeContext(session, timeContext);
            }
            finally {
                this.instanceTimeManager.unlockInstanceTimeContext(session, instanceID);
            }
        }
        catch (DataSourceException e) {
            this.logger.log(Level.SEVERE, "DataSourceException", e);
        }
        catch (LockException e) {
            this.logger.log(Level.SEVERE, "LockException", e);
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultInstanceStateUpdateManager.this.instanceStarting.instanceCreated(session, templateID, instanceID, timestamp);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DefaultInstanceStateUpdateManager.this.logger.log(Level.SEVERE, "An exception occurred in instanceCreate.", e);
                }
            }
        });
    }

    @Override
    public void instanceStarted(final SessionToken session, final UUID instanceID, final long timestamp) {
        try {
            UpdateableInstanceTimeContext timeContext = this.instanceTimeManager.getAndLockInstanceTimeContext(session, instanceID);
            try {
                timeContext.setInstanceStarted(timestamp);
                this.instanceTimeManager.updateInstanceTimeContext(session, timeContext);
            }
            finally {
                this.instanceTimeManager.unlockInstanceTimeContext(session, instanceID);
            }
        }
        catch (DataSourceException e) {
            this.logger.log(Level.SEVERE, "DataSourceException", e);
        }
        catch (LockException e) {
            this.logger.log(Level.SEVERE, "LockException", e);
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultInstanceStateUpdateManager.this.instanceStarting.instanceStarted(session, instanceID, timestamp);
                }
                catch (Throwable e) {
                    DefaultInstanceStateUpdateManager.this.logger.log(Level.SEVERE, "An exception occurred in instanceStarted.", e);
                }
            }
        });
    }

    @Override
    public void instanceFinished(final SessionToken session, final UUID instanceID, final long timestamp) {
        try {
            UpdateableInstanceTimeContext timeContext = this.instanceTimeManager.getAndLockInstanceTimeContext(session, instanceID);
            try {
                timeContext.setInstanceFinished(timestamp);
                this.instanceTimeManager.updateInstanceTimeContext(session, timeContext);
            }
            finally {
                this.instanceTimeManager.unlockInstanceTimeContext(session, instanceID);
            }
        }
        catch (DataSourceException e) {
            this.logger.log(Level.SEVERE, "DataSourceException", e);
        }
        catch (LockException e) {
            this.logger.log(Level.SEVERE, "LockException", e);
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultInstanceStateUpdateManager.this.instanceTermination.instanceFinished(session, instanceID, timestamp);
                }
                catch (Throwable e) {
                    DefaultInstanceStateUpdateManager.this.logger.log(Level.SEVERE, "An exception occurred in instanceFinished.", e);
                }
            }
        });
    }
}

