/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.timemanager.defaultimplementation.processexecution.defaultimplementation;

import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.AbstractSubService;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.DefaultInstanceTimeManager;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.DefaultTimeManager;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.processexecution.InstanceTermination;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.processexecution.defaultimplementation.TimeManagerTools;
import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.timemodel.InstanceTimeContext;
import de.aristaflow.adept2.model.timemodel.InstanceTimeModel;
import de.aristaflow.adept2.model.timemodel.Interval;
import de.aristaflow.adept2.util.DataSourceException;
import java.util.UUID;
import java.util.logging.Level;

public class DefaultInstanceTermination
extends AbstractSubService
implements InstanceTermination {
    private final DefaultInstanceTimeManager instanceTimeManager;

    public DefaultInstanceTermination(DefaultTimeManager timeManager, DefaultInstanceTimeManager instanceTimeManager) {
        super((AbstractADEPT2Service)timeManager);
        this.instanceTimeManager = instanceTimeManager;
    }

    @Override
    public void instanceFinished(SessionToken session, UUID instanceID, long timestamp) {
        InstanceTimeModel timeModel;
        InstanceTimeContext timeContext;
        System.out.println(String.format("Instance (%1$s) Finished @ %2$d-> Updating Time Model", instanceID, timestamp));
        this.logger.entering(this.logger.getName(), "instanceFinished(SessionToken,UUID,long)");
        try {
            timeContext = this.instanceTimeManager.getInstanceTimeContext(session, instanceID);
            timeModel = this.instanceTimeManager.getInstanceTimeModelReadonly(session, instanceID);
        }
        catch (DataSourceException e) {
            this.logger.log(Level.SEVERE, "DataSourceException", e);
            throw new RuntimeException(e);
        }
        if (timeModel != null) {
            long instanceStart = timeContext.getInstanceStarted();
            Interval<TimeDistance> durationRestriction = timeModel.getInstanceDuration();
            if (durationRestriction != null) {
                long instanceDuration = timestamp - instanceStart;
                if (TimeManagerTools.compare(durationRestriction.getMaxValue(), instanceDuration) > 0) {
                    this.logger.severe("Process missed Duration Restriction");
                }
            }
            long duration = (timestamp - instanceStart) / 1000L;
            this.logger.log(Level.FINE, String.format("Instance '%1$s' finished! Duration %2$d seconds", instanceID, duration));
        }
        this.logger.exiting(this.logger.getName(), "instanceFinished(SessionToken,UUID,long)");
    }
}

