/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.timemanager.defaultimplementation.processexecution.defaultimplementation;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.AbstractSubService;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.complexeventmanager.EventListener;
import de.aristaflow.adept2.core.complexeventmanager.EventManager;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.DefaultInstanceTimeManager;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.DefaultTimeEventNotification;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.DefaultTimeManager;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.processexecution.ActivityStarting;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.processexecution.ActivityTermination;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.processexecution.InstanceStarting;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.processexecution.InstanceTermination;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.processexecution.ProcessExecutionManager;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.processexecution.defaultimplementation.DefaultActivityStateUpdateManager;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.processexecution.defaultimplementation.DefaultInstanceStateUpdateManager;
import de.aristaflow.adept2.model.eventmodel.EventReference;
import de.aristaflow.adept2.model.globals.ExecutionEventConstants;
import java.util.UUID;
import java.util.logging.Level;

public class DefaultProcessExecutionManager
extends AbstractSubService
implements ProcessExecutionManager {
    private final DefaultInstanceStateUpdateManager processInstanceUpdateManager;
    private final DefaultActivityStateUpdateManager activityInstanceUpdateManager;
    private final EventManager eventManager;
    private DefaultTimeEventNotification eventNotification;
    private DefaultTimeManager timeManager;

    public DefaultProcessExecutionManager(DefaultTimeManager timeManager, DefaultInstanceTimeManager instanceTimeManager, EventManager eventManager, InstanceStarting instanceStarting, InstanceTermination instanceTermination, ActivityStarting activityStarting, ActivityTermination activityTermination) {
        super((AbstractADEPT2Service)timeManager);
        this.timeManager = timeManager;
        this.eventManager = eventManager;
        this.processInstanceUpdateManager = new DefaultInstanceStateUpdateManager(timeManager, instanceTimeManager, instanceStarting, instanceTermination);
        this.activityInstanceUpdateManager = new DefaultActivityStateUpdateManager(timeManager, instanceTimeManager, activityStarting, activityTermination);
    }

    public void init() throws AbortServiceException {
        this.processInstanceUpdateManager.init();
        this.activityInstanceUpdateManager.init();
        this.eventNotification = new DefaultTimeEventNotification(this, this.eventManager, "de.aristaflow.adept2.core.executionmanager.InstanceEvent.Process", "de.aristaflow.adept2.core.executionmanager.InstanceEvent.Activity");
    }

    public void emergencyShutdown() {
        this.eventManager.getEventSinkManager().deregisterEventListener((EventListener)this.eventNotification);
        this.processInstanceUpdateManager.emergencyShutdown();
        this.activityInstanceUpdateManager.emergencyShutdown();
        super.emergencyShutdown();
    }

    public void shutdown() {
        this.eventManager.getEventSinkManager().deregisterEventListener((EventListener)this.eventNotification);
        this.processInstanceUpdateManager.shutdown();
        this.activityInstanceUpdateManager.shutdown();
        super.shutdown();
    }

    public void start() throws AbortServiceException {
        super.start();
        this.processInstanceUpdateManager.start();
        this.activityInstanceUpdateManager.start();
        this.eventManager.getEventSinkManager().registerEventListener((EventListener)this.eventNotification);
    }

    @Override
    public void processEvent(EventReference event) {
        try {
            if (this.eventManager.getEventClassManager().isSubClassOf(event.getEventClassID(), "de.aristaflow.adept2.core.executionmanager.InstanceEvent.Activity")) {
                this.processActivityEvent(event);
            }
            if (this.eventManager.getEventClassManager().isSubClassOf(event.getEventClassID(), "de.aristaflow.adept2.core.executionmanager.InstanceEvent.Process")) {
                this.processProcessEvent(event);
            }
            if (this.eventManager.getEventClassManager().isSubClassOf(event.getEventClassID(), "de.aristaflow.adept2.core.executionmanager.InstanceEvent.Process.SubProcess")) {
                this.processSubProcessEvent(event);
            }
        }
        catch (Throwable t) {
            this.logger.log(Level.SEVERE, "Exception while processing event!", t);
        }
    }

    protected void processActivityEvent(EventReference event) {
        SessionToken session = this.createSessionToken();
        ExecutionEventConstants.ActivityEventType eventType = (ExecutionEventConstants.ActivityEventType)event.getAttribute("ActivityEventType");
        UUID instanceID = (UUID)event.getAttribute("InstanceID");
        int nodeID = (Integer)event.getAttribute("NodeID");
        int nodeIteration = (Integer)event.getAttribute("NodeIteration");
        switch (eventType) {
            case STARTED: {
                this.activityInstanceUpdateManager.activityStarted(this.childSession(session), instanceID, nodeID, nodeIteration, event.getTimeStamp());
                break;
            }
            case FINISHED: {
                this.activityInstanceUpdateManager.activityFinished(this.childSession(session), instanceID, nodeID, nodeIteration, event.getTimeStamp());
                break;
            }
            case ACTIVATED: 
            case SUSPENDED: 
            case RESUMED: 
            case FAILED: 
            case RESET: {
                this.logger.fine(String.format("Received Event of Type '%1$s'. Ignoring it!", eventType));
                break;
            }
            default: {
                this.logger.severe(String.format("Unkown Process Event Type: %1$s", eventType));
            }
        }
    }

    protected void processProcessEvent(EventReference event) {
        SessionToken session = this.createSessionToken();
        ExecutionEventConstants.ProcessEventType eventType = (ExecutionEventConstants.ProcessEventType)event.getAttribute("ProcessEventType");
        UUID instanceID = (UUID)event.getAttribute("InstanceID");
        UUID templateID = (UUID)event.getAttribute("TemplateID");
        switch (eventType) {
            case STARTED: {
                this.processInstanceUpdateManager.instanceCreated(this.childSession(session), templateID, instanceID, event.getTimeStamp() - 1000L);
                this.processInstanceUpdateManager.instanceStarted(this.childSession(session), instanceID, event.getTimeStamp());
                break;
            }
            case FINISHED: {
                this.processInstanceUpdateManager.instanceFinished(this.childSession(session), instanceID, event.getTimeStamp());
                break;
            }
            default: {
                this.logger.severe("Unkown Process Event Type: " + eventType);
            }
        }
    }

    private SessionToken childSession(SessionToken session) {
        return this.timeManager.subSession(session);
    }

    private SessionToken createSessionToken() {
        return this.timeManager.createSessionToken();
    }

    protected void processSubProcessEvent(EventReference event) {
    }
}

