/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.timemanager.defaultimplementation.processexecution.defaultimplementation;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.timemanager.defaultimplementation.timemodelcontrol.TemporalExceptionHandling;
import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.timemodel.ChangeableTimeModelStatus;
import de.aristaflow.adept2.model.timemodel.InconsistencyException;
import de.aristaflow.adept2.model.timemodel.TimeModelFactory;
import de.aristaflow.adept2.model.timemodel.TimeModelSolver;
import de.aristaflow.adept2.model.timemodel.TimeModelStatus;
import de.aristaflow.adept2.model.timemodel.UpdateableInstanceTimeModel;

public abstract class TimeManagerTools {
    public static int compare(TimeDistance timePoint, long value) {
        return 0;
    }

    protected static boolean updateStatus(ChangeableTimeModelStatus currentStatus, TimeModelStatus.TimeModelState status, TimeModelStatus.TimeModelUpdateStatus updateStatus, String msg) {
        boolean change = false;
        if (!currentStatus.getTimeModelUpdateStatus().equals((Object)updateStatus)) {
            currentStatus.setTimeModelUpdateStatus(updateStatus, msg);
            change = true;
        }
        if (!currentStatus.getTimeModelStatus().equals(status.ordinal())) {
            currentStatus.setTimeModelStatus(status);
            change = true;
        }
        if (status == TimeModelStatus.TimeModelState.INVALID) {
            change |= TimeManagerTools.downgradeUpdateStatus(currentStatus, TimeModelStatus.TimeModelUpdateStatus.NO_CALCULATION, msg);
        }
        return change;
    }

    protected static boolean downgradeUpdateStatus(ChangeableTimeModelStatus currentStatus, TimeModelStatus.TimeModelUpdateStatus updateStatus, String msg) {
        boolean change = false;
        if (currentStatus.getTimeModelUpdateStatus().ordinal() < updateStatus.ordinal()) {
            currentStatus.setTimeModelUpdateStatus(updateStatus, msg);
            change = true;
        }
        return change;
    }

    protected static boolean updateTimeModel(SessionToken session, TimeModelFactory timeModelFactory, UpdateableInstanceTimeModel timeModel, ChangeableTimeModelStatus status, TemporalExceptionHandling temporalExceptionHandling) {
        if (!status.getTimeModelUpdateStatus().equals((Object)TimeModelStatus.TimeModelUpdateStatus.ENABLED)) {
            return false;
        }
        if (status.getTimeModelStatus().equals((Object)TimeModelStatus.TimeModelState.INVALID)) {
            return false;
        }
        TimeModelSolver timeModelSolver = timeModelFactory.getTimeModelSolver(timeModel.getClass());
        try {
            timeModelSolver.solve(timeModel);
            System.out.println(String.format("Updating status of Instance (%1$s) to VALID", timeModel.getInstanceID()));
            return TimeManagerTools.updateStatus(status, TimeModelStatus.TimeModelState.VALID, status.getTimeModelUpdateStatus(), null);
        }
        catch (InconsistencyException e) {
            temporalExceptionHandling.handleInconsistency(e);
            System.out.println(String.format("Updating status of Instance (%1$s) to INVALID", timeModel.getInstanceID()));
            return TimeManagerTools.updateStatus(status, TimeModelStatus.TimeModelState.INVALID, TimeModelStatus.TimeModelUpdateStatus.DISABLED, e.getMessage());
        }
        catch (InterruptedException e) {
            System.out.println(String.format("Updating status of Instance (%1$s) to UNKOWN", timeModel.getInstanceID()));
            return TimeManagerTools.updateStatus(status, TimeModelStatus.TimeModelState.UNKOWN, status.getTimeModelUpdateStatus(), e.getMessage());
        }
    }
}

