/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.timemanager.defaultimplementation.schedules;

import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.core.timemanager.ScheduleEvaluation;
import de.aristaflow.adept2.core.timemanager.ScheduleManager;
import de.aristaflow.adept2.core.timemanager.ScheduleResolutionException;
import de.aristaflow.adept2.core.timemanager.storage.TimeManagerStorage;
import de.aristaflow.adept2.model.common.timedata.CalendarElement;
import de.aristaflow.adept2.model.common.timedata.defaultimplementation.DefaultCalendarElement;
import de.aristaflow.adept2.model.processmodel.timemodel.schedules.evaluation.ComplexIntervalSet;
import de.aristaflow.adept2.model.processmodel.timemodel.schedules.evaluation.ContinuousIntervalSet;
import de.aristaflow.adept2.model.processmodel.timemodel.schedules.evaluation.Evaluator;
import de.aristaflow.adept2.model.processmodel.timemodel.schedules.evaluation.Interval;
import de.aristaflow.adept2.model.processmodel.timemodel.schedules.evaluation.IntervalSet;
import de.aristaflow.adept2.model.processmodel.timemodel.schedules.evaluation.TimeFrame;
import de.aristaflow.adept2.model.processmodel.timemodel.schedules.lang.ScheduleParser;
import de.aristaflow.adept2.model.processmodel.timemodel.schedules.lang.expression.CalendarExpression;
import de.aristaflow.adept2.model.processmodel.timemodel.schedules.lang.expression.Ident;
import de.aristaflow.adept2.model.timemodel.Schedule;
import de.aristaflow.adept2.model.timemodel.ScheduleInterval;
import de.aristaflow.adept2.model.timemodel.ScheduleIntervalSet;
import de.aristaflow.adept2.model.timemodel.defaultimplementation.DefaultSchedule;
import de.aristaflow.adept2.model.timemodel.defaultimplementation.DefaultScheduleInterval;
import de.aristaflow.adept2.model.timemodel.defaultimplementation.DefaultScheduleIntervalSet;
import de.aristaflow.adept2.util.DataSourceException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultScheduleEvaluation
implements ScheduleEvaluation,
ScheduleManager {
    protected Evaluator evaluator;
    private TimeManagerStorage storage;
    private Logger logger;

    public DefaultScheduleEvaluation(TimeManagerStorage timeManagerStorage) {
        this.storage = timeManagerStorage;
        Map<String, Schedule> allCustomCalendars = null;
        try {
            allCustomCalendars = this.storage.getAllCustomCalendars();
        }
        catch (DataSourceException e) {
            this.logger.log(Level.SEVERE, "Could not load custom calendars", e);
            throw new InternalServiceException("Could not load custom calendars", (Throwable)e);
        }
        HashMap<String, CalendarExpression> customeCal = new HashMap<String, CalendarExpression>();
        for (Map.Entry<String, Schedule> cal : allCustomCalendars.entrySet()) {
            CalendarExpression calendarExpression = this.getCalendarExpression(cal.getValue());
            if (calendarExpression == null) continue;
            customeCal.put(cal.getKey(), calendarExpression);
        }
        this.evaluator = new Evaluator(customeCal);
    }

    @Override
    public Schedule parseSchedule(String schedule) throws ScheduleResolutionException {
        CalendarExpression calendarExpression = ScheduleParser.parse(schedule);
        return new DefaultSchedule(schedule, null, calendarExpression);
    }

    @Override
    public ScheduleIntervalSet evaluateSchedule(Schedule schedule, CalendarElement from, CalendarElement until) throws ScheduleResolutionException {
        TimeFrame timeFrame;
        DefaultSchedule s = (DefaultSchedule)schedule;
        CalendarExpression expression = s.getExpression();
        try {
            timeFrame = this.evaluator.evaluate(expression, this.toCalendar(from), this.toCalendar(until), true);
        }
        catch (Exception e) {
            throw new ScheduleResolutionException(e.getMessage(), e);
        }
        timeFrame = this.evaluator.flatten(timeFrame);
        return this.toScheduleIntervalSet(schedule, timeFrame);
    }

    private ScheduleIntervalSet toScheduleIntervalSet(Schedule schedule, TimeFrame timeFrame) {
        ArrayList<ScheduleInterval> list = new ArrayList<ScheduleInterval>();
        if (timeFrame instanceof Interval) {
            list.add(new DefaultScheduleInterval(this.toCalendarElement(timeFrame.getStart()), this.toCalendarElement(timeFrame.getEnd())));
        } else if (timeFrame instanceof ContinuousIntervalSet) {
            list.add(new DefaultScheduleInterval(this.toCalendarElement(timeFrame.getStart()), this.toCalendarElement(timeFrame.getEnd())));
        } else if (timeFrame instanceof ComplexIntervalSet) {
            IntervalSet intervalSet = (IntervalSet)timeFrame;
            for (TimeFrame tf : intervalSet.getTimeFrames()) {
                if (tf instanceof Interval || tf instanceof ContinuousIntervalSet) {
                    list.add(new DefaultScheduleInterval(this.toCalendarElement(tf.getStart()), this.toCalendarElement(tf.getEnd())));
                    continue;
                }
                throw new IllegalStateException();
            }
        } else {
            throw new IllegalStateException();
        }
        return new DefaultScheduleIntervalSet(schedule, list);
    }

    @Override
    public ScheduleIntervalSet evaluateSchedule(Schedule schedule, CalendarElement from, int intervalCount) {
        return null;
    }

    @Override
    public ScheduleInterval getNextInterval(Schedule schedule, CalendarElement from) {
        DefaultSchedule s = (DefaultSchedule)schedule;
        CalendarExpression expression = s.getExpression();
        TimeFrame timeFrame = this.evaluator.nextInterval(expression, this.toCalendar(from), true);
        if ((timeFrame = this.evaluator.flatten(timeFrame)) instanceof Interval) {
            return new DefaultScheduleInterval(this.toCalendarElement(timeFrame.getStart()), this.toCalendarElement(timeFrame.getEnd()));
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean hasNextInterval(Schedule schedule, CalendarElement from) {
        DefaultSchedule s = (DefaultSchedule)schedule;
        CalendarExpression expression = s.getExpression();
        TimeFrame timeFrame = this.evaluator.nextInterval(expression, this.toCalendar(from), true);
        return timeFrame != null;
    }

    @Override
    public boolean hasNextInterval(Schedule schedule, CalendarElement from, CalendarElement until) {
        DefaultSchedule s = (DefaultSchedule)schedule;
        CalendarExpression expression = s.getExpression();
        IntervalSet timeFrame = this.evaluator.evaluate(expression, this.toCalendar(from), this.toCalendar(until), true);
        if (timeFrame instanceof Interval) {
            return true;
        }
        if (timeFrame instanceof IntervalSet) {
            IntervalSet set = timeFrame;
            return set.size() > 0;
        }
        throw new IllegalStateException();
    }

    private CalendarElement toCalendarElement(Calendar start) {
        return new DefaultCalendarElement(start.getTimeInMillis());
    }

    private Calendar toCalendar(CalendarElement from) {
        Calendar fromC = Calendar.getInstance();
        fromC.setTimeInMillis(from.getTimeInMillis());
        return fromC;
    }

    @Override
    public Map<String, Schedule> getKnownCustomCalendars() throws DataSourceException {
        return this.storage.getAllCustomCalendars();
    }

    @Override
    public void addCustomCalendar(String id, Schedule calendar) throws DataSourceException {
        CalendarExpression calendarExpression = this.getCalendarExpression(calendar);
        if (calendarExpression != null) {
            this.storage.storeCustomCalendar(id, calendar);
            this.evaluator.registerIdent(new Ident(id), calendarExpression);
        }
    }

    protected CalendarExpression getCalendarExpression(Schedule calendar) {
        DefaultSchedule s;
        if (calendar instanceof DefaultSchedule) {
            s = (DefaultSchedule)calendar;
        } else {
            try {
                s = (DefaultSchedule)this.parseSchedule(calendar.getRule());
            }
            catch (ScheduleResolutionException e) {
                e.printStackTrace();
                return null;
            }
        }
        CalendarExpression calendarExpression = s.getExpression();
        return calendarExpression;
    }

    @Override
    public void removeCustomCalendar(String id) throws DataSourceException {
        this.storage.removeCustomCalendar(id);
        this.evaluator.unregisterIdent(new Ident(id));
    }
}

