/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.timemanager.storage.transientstorage;

import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.service.InvalidServiceStateException;
import de.aristaflow.adept2.base.sessionmanagement.SessionLock;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.timemanager.storage.InstanceTimeModelStorage;
import de.aristaflow.adept2.model.timemodel.ChangeableTimeModelStatus;
import de.aristaflow.adept2.model.timemodel.InstanceTimeContext;
import de.aristaflow.adept2.model.timemodel.InstanceTimeModel;
import de.aristaflow.adept2.model.timemodel.TimeModelStatus;
import de.aristaflow.adept2.model.timemodel.UpdateableInstanceTimeContext;
import de.aristaflow.adept2.model.timemodel.UpdateableInstanceTimeModel;
import de.aristaflow.adept2.model.timemodel.defaultimplementation.DefaultInstanceTimeContext;
import de.aristaflow.adept2.model.timemodel.defaultimplementation.DefaultTimeModelStatus;
import de.aristaflow.adept2.model.timemodel.tcn.cstnuImpl.CSTNUTimeModelFactory;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LockException;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.locking.AcquireLockException;
import de.aristaflow.adept2.util.locking.ObjectLockManager;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TransientInstanceTimeModelStorage
implements InstanceTimeModelStorage {
    protected final Logger logger = LoggerTools.getLogger((Object)this);
    protected final ReentrantReadWriteLock timeDataLock;
    protected final ObjectLockManager<UUID, SessionToken> lockManager;
    private Map<UUID, UpdateableInstanceTimeContext> timeData = new HashMap<UUID, UpdateableInstanceTimeContext>();
    private Map<UUID, InstanceTimeModel> timeModels = new HashMap<UUID, InstanceTimeModel>();
    private Map<UUID, ChangeableTimeModelStatus> timeModelStati = new HashMap<UUID, ChangeableTimeModelStatus>();
    private long timeOut = 0L;

    public TransientInstanceTimeModelStorage() {
        this.timeDataLock = new ReentrantReadWriteLock();
        try {
            this.lockManager = new ObjectLockManager(SessionLock.SubsessionLockCount.class, SessionLock.class, "time manager instance time storage");
        }
        catch (InvocationTargetException ite) {
            String msg = "Can not instantiate object lock manager for synchronising storage of worklists. There were problems instantiating the lock count manager and/or the session locks.";
            this.logger.log(Level.SEVERE, msg, ite);
            throw new InternalServiceException(msg, (Throwable)ite);
        }
    }

    @Override
    public void lockInstanceTimeContext(SessionToken session, UUID instanceID) {
        this.logger.fine(String.format("Session '%s' aquiring lock for time data '%s'", session, instanceID));
        try {
            this.lockManager.getLockForObject(true, (Object)session, (Object)instanceID, this.timeOut);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException te) {
            String msg = String.format("Got a timeout while waiting to lock the time data '%s' for session '%s'. This is possibly a deadlock.", instanceID, session);
            throw new InvalidServiceStateException(msg, (Throwable)te);
        }
    }

    protected UpdateableInstanceTimeContext createAndLockInstanceTimeContext(UUID instanceID) {
        this.timeDataLock.writeLock().lock();
        try {
            if (this.timeData.containsKey(instanceID)) {
                UpdateableInstanceTimeContext updateableInstanceTimeContext = this.timeData.get(instanceID);
                return updateableInstanceTimeContext;
            }
            DefaultInstanceTimeContext instanceTimeData = new DefaultInstanceTimeContext(instanceID);
            DefaultTimeModelStatus timeModelStatus = new DefaultTimeModelStatus(instanceID, TimeModelStatus.TimeModelState.UNKOWN, TimeModelStatus.TimeModelUpdateStatus.DISABLED);
            this.timeData.put(instanceID, instanceTimeData);
            this.timeModelStati.put(instanceID, timeModelStatus);
            DefaultInstanceTimeContext defaultInstanceTimeContext = instanceTimeData;
            return defaultInstanceTimeContext;
        }
        finally {
            this.timeDataLock.writeLock().unlock();
        }
    }

    @Override
    public UpdateableInstanceTimeContext createAndLockInstanceTimeContext(SessionToken session, UUID instanceID) throws DataSourceException {
        this.lockInstanceTimeContext(session, instanceID);
        return this.createAndLockInstanceTimeContext(instanceID);
    }

    @Override
    public InstanceTimeContext getInstanceTimeContextReadonly(UUID instanceID) throws DataSourceException {
        this.timeDataLock.readLock().lock();
        try {
            InstanceTimeContext instanceTimeData;
            InstanceTimeContext instanceTimeContext = instanceTimeData = (InstanceTimeContext)this.timeData.get(instanceID);
            return instanceTimeContext;
        }
        finally {
            this.timeDataLock.readLock().unlock();
        }
    }

    @Override
    public UpdateableInstanceTimeContext getAndLockInstanceTimeContext(SessionToken session, UUID instanceID) throws DataSourceException {
        this.lockInstanceTimeContext(session, instanceID);
        return (UpdateableInstanceTimeContext)this.getInstanceTimeContextReadonly(instanceID);
    }

    @Override
    public void updateInstanceTimeContext(SessionToken session, InstanceTimeContext instanceTimeData) throws DataSourceException, LockException {
        if (!this.lockManager.hasLock(true, (Object)session, (Object)instanceTimeData.getInstanceID())) {
            String message = String.format("Session '%s' is not holiding any lock on time data '%s'!", session, instanceTimeData.getInstanceID());
            this.logger.log(Level.SEVERE, message);
            throw new AcquireLockException((Object)instanceTimeData.getInstanceID(), (Object)session, "updateInstanceTimeContext");
        }
    }

    @Override
    public void unlockInstanceTimeContext(SessionToken session, UUID instanceID) throws LockException {
        this.logger.fine(String.format("Session '%s' releasing lock for time data '%s'", session, instanceID));
        this.lockManager.unlockObject(true, (Object)session, (Object)instanceID);
    }

    @Override
    public InstanceTimeModel getInstanceTimeModelReadonly(UUID instanceID) throws DataSourceException {
        this.timeDataLock.readLock().lock();
        try {
            InstanceTimeModel timeModel;
            InstanceTimeModel instanceTimeModel = timeModel = this.timeModels.get(instanceID);
            return instanceTimeModel;
        }
        finally {
            this.timeDataLock.readLock().unlock();
        }
    }

    @Override
    public UpdateableInstanceTimeModel getAndLockInstanceTimeModel(SessionToken session, UUID instanceID) throws DataSourceException {
        this.lockInstanceTimeModel(session, instanceID);
        CSTNUTimeModelFactory tmf = new CSTNUTimeModelFactory();
        tmf.setCreateChangeable(true);
        InstanceTimeModel ret = this.getInstanceTimeModelReadonly(instanceID);
        return (UpdateableInstanceTimeModel)ret;
    }

    @Override
    public void lockInstanceTimeModel(SessionToken session, UUID instanceID) {
        this.lockInstanceTimeContext(session, instanceID);
    }

    @Override
    public void updateInstanceTimeModel(SessionToken session, UUID instanceID, InstanceTimeModel timeModel) throws DataSourceException, LockException {
        block5: {
            if (!this.lockManager.hasLock(true, (Object)session, (Object)instanceID)) {
                String message = String.format("Session '%s' is not holiding any lock on time data '%s'!", session, instanceID);
                this.logger.log(Level.SEVERE, message);
                throw new AcquireLockException((Object)instanceID, (Object)session, "updateInstanceTimeModel");
            }
            this.timeDataLock.writeLock().lock();
            try {
                InstanceTimeContext data = this.timeData.get(instanceID);
                if (data != null) {
                    this.timeModels.put(instanceID, timeModel);
                    break block5;
                }
                throw new DataSourceException();
            }
            finally {
                this.timeDataLock.writeLock().unlock();
            }
        }
    }

    @Override
    public void unlockInstanceTimeModel(SessionToken session, UUID instanceID) throws LockException {
        this.unlockInstanceTimeContext(session, instanceID);
    }

    @Override
    public TimeModelStatus getTimeModelStatusReadonly(UUID instanceID) {
        this.timeDataLock.readLock().lock();
        try {
            ChangeableTimeModelStatus changeableTimeModelStatus = this.copyTimeModelStatus(this.timeModelStati.get(instanceID));
            return changeableTimeModelStatus;
        }
        finally {
            this.timeDataLock.readLock().unlock();
        }
    }

    @Override
    public ChangeableTimeModelStatus getAndLockTimeModelStatus(SessionToken session, UUID instanceID) {
        this.lockInstanceTimeContext(session, instanceID);
        return (ChangeableTimeModelStatus)this.getTimeModelStatusReadonly(instanceID);
    }

    @Override
    public void updateTimeModelStatus(SessionToken session, TimeModelStatus status) throws LockException {
        if (!this.lockManager.hasLock(true, (Object)session, (Object)status.getInstanceID())) {
            String message = String.format("Session '%s' is not holiding any lock on time data '%s'!", session, status.getInstanceID());
            this.logger.log(Level.SEVERE, message);
            throw new AcquireLockException((Object)status.getInstanceID(), (Object)session, "updateTimeModelStatus");
        }
        this.timeDataLock.writeLock().lock();
        try {
            this.timeModelStati.put(status.getInstanceID(), this.copyTimeModelStatus(status));
        }
        finally {
            this.timeDataLock.writeLock().unlock();
        }
    }

    @Override
    public void unlockTimeModelStatus(SessionToken session, UUID instanceID) throws LockException {
        this.unlockInstanceTimeContext(session, instanceID);
    }

    private ChangeableTimeModelStatus copyTimeModelStatus(TimeModelStatus status) {
        DefaultTimeModelStatus timeModelStatus = new DefaultTimeModelStatus(status.getInstanceID(), status.getTimeModelStatus(), status.getTimeModelUpdateStatus(), status.getTimeModelUpdateStatusComment());
        return timeModelStatus;
    }

    @Override
    public boolean hasTimeModelForInstance(UUID instanceID) throws DataSourceException {
        return this.getInstanceTimeModelReadonly(instanceID) != null;
    }

    protected class ActivityTimeData {
        private final int nodeID;
        private long startTime = -1L;
        private long finishTime = -1L;

        public ActivityTimeData(int nodeID) {
            this.nodeID = nodeID;
        }

        public void setStartTime(int iteration, long timestamp) {
            this.startTime = timestamp;
        }

        public void setFinishTime(int iteration, long timestamp) {
            this.finishTime = timestamp;
        }

        public long getStartTime(int iteration) {
            return this.startTime;
        }

        public long getFinishTime(int iteration) {
            return this.finishTime;
        }

        public int getNodeID() {
            return this.nodeID;
        }
    }
}

