/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.timemanager.storage.xmlstorage;

import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.core.timemanager.ScheduleResolutionException;
import de.aristaflow.adept2.core.timemanager.storage.TimeManagerStorage;
import de.aristaflow.adept2.model.processmodel.timemodel.schedules.lang.ScheduleParser;
import de.aristaflow.adept2.model.processmodel.timemodel.schedules.lang.expression.CalendarExpression;
import de.aristaflow.adept2.model.timemodel.Schedule;
import de.aristaflow.adept2.model.timemodel.TimeModelFactory;
import de.aristaflow.adept2.model.timemodel.defaultimplementation.DefaultSchedule;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import de.aristaflow.adept2.util.xml.XMLHelperTools;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration.Configuration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLTimeManagerStorage
implements TimeManagerStorage {
    public static final String CONFIGURATION_DATA_DIR = "StorageDataDir";
    public static final String CONFIGURATION_FILE = "customCalendars.config";
    private String dataDirName;
    private Logger logger = LoggerTools.getLogger((Object)this);
    private File dataDir;
    private TimeModelFactory factory;
    private Map<String, Schedule> customCalendars;

    public XMLTimeManagerStorage(Configuration configuration, TimeModelFactory factory) throws ConfigurationException {
        this.factory = factory;
        this.dataDirName = configuration.getString(CONFIGURATION_DATA_DIR);
        if (this.dataDirName == null) {
            String message = String.format("The required configuration value '%s' is not set.", CONFIGURATION_DATA_DIR);
            this.logger.severe(message);
            throw new ConfigurationException(message);
        }
        this.dataDir = new File(this.dataDirName);
        if (!this.dataDir.exists()) {
            this.logger.warning(String.format("Data dir '%s' does not exist. Creating it.", this.dataDir));
            boolean success = this.dataDir.mkdir();
            if (!success) {
                String msg = String.format("The directory %s could not be created!", this.dataDir.getAbsolutePath());
                this.logger.severe(msg);
            }
        }
    }

    @Override
    public Map<String, Schedule> getAllCustomCalendars() throws DataSourceException {
        if (this.customCalendars == null) {
            this.customCalendars = this.internalGetReadCustomCalendars();
        }
        return Collections.unmodifiableMap(this.customCalendars);
    }

    private Map<String, Schedule> internalGetReadCustomCalendars() throws DataSourceException {
        try {
            File customCalendarFile = this.getCustomCalendarFile();
            if (customCalendarFile.exists()) {
                return this.readCustomCalendarsFromFile(customCalendarFile);
            }
            return Collections.emptyMap();
        }
        catch (FileNotFoundException e) {
            String message = String.format("Exception while reading custom calendar file.", new Object[0]);
            this.logger.log(Level.SEVERE, message, e);
            throw new DataSourceException(message, (Throwable)e);
        }
        catch (XMLFormatException e) {
            String message = String.format("Exception while reading custom calendar file.", new Object[0]);
            this.logger.log(Level.SEVERE, message, e);
            throw new DataSourceException(message, (Throwable)e);
        }
        catch (IOException e) {
            String message = String.format("Exception while reading custom calendar file.", new Object[0]);
            this.logger.log(Level.SEVERE, message, e);
            throw new DataSourceException(message, (Throwable)e);
        }
    }

    private Map<String, Schedule> readCustomCalendarsFromFile(File file) throws FileNotFoundException, XMLFormatException, IOException {
        Document document = XMLHelperTools.getDocumentFromFile((File)file, null, null);
        return this.getCustomCalendarsFromFile(document);
    }

    private Map<String, Schedule> getCustomCalendarsFromFile(Document document) {
        Element root = document.getDocumentElement();
        return this.getCustomCalendarsFromFile(this.factory, root);
    }

    private Map<String, Schedule> getCustomCalendarsFromFile(TimeModelFactory factory, Element root) {
        NodeList nodeList = root.getElementsByTagName("CustomCalendar");
        HashMap<String, Schedule> result = new HashMap<String, Schedule>();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node item = nodeList.item(i);
            Element element = XMLHelperTools.getElement((Node)item);
            String id = element.getAttribute("id");
            Schedule schedule = this.getCustomCalendar(factory, element);
            result.put(id, schedule);
            ++i;
        }
        return result;
    }

    private Schedule getCustomCalendar(TimeModelFactory factory, Element element) {
        String schedule = element.getTextContent();
        try {
            CalendarExpression calendarExpression = ScheduleParser.parse(schedule);
            return new DefaultSchedule(schedule, null, calendarExpression);
        }
        catch (ScheduleResolutionException e) {
            this.logger.log(Level.SEVERE, "An error occurred", e);
            return null;
        }
    }

    @Override
    public void storeCustomCalendar(String id, Schedule calendar) throws DataSourceException {
        HashMap<String, Schedule> allCustomCalendars = new HashMap<String, Schedule>(this.getAllCustomCalendars());
        allCustomCalendars.put(id, calendar);
        this.updateCustomCalendars(allCustomCalendars);
    }

    private void updateCustomCalendars(Map<String, Schedule> allCustomCalendars) throws DataSourceException {
        try {
            File file = this.getCustomCalendarFile();
            if (!file.exists()) {
                file.createNewFile();
            }
            this.writeCustomCalendarsToFile(file, allCustomCalendars);
        }
        catch (IOException e) {
            String message = String.format("Exception while reading custom calendar file.", new Object[0]);
            this.logger.log(Level.SEVERE, message, e);
            throw new DataSourceException(message, (Throwable)e);
        }
        catch (XMLFormatException e) {
            String message = String.format("Exception while reading custom calendar file.", new Object[0]);
            this.logger.log(Level.SEVERE, message, e);
            throw new DataSourceException(message, (Throwable)e);
        }
        this.customCalendars = allCustomCalendars;
    }

    private void writeCustomCalendarsToFile(File file, Map<String, Schedule> allCustomCalendars) throws IOException, XMLFormatException {
        Document document = XMLHelperTools.createDocument();
        this.writeCustomCalendarsFromFile(document, allCustomCalendars);
        XMLHelperTools.writeDocumentToFile((Document)document, (File)file, null);
    }

    private void writeCustomCalendarsFromFile(Document document, Map<String, Schedule> allCustomCalendars) {
        Element root = document.createElement("CustomCalendars");
        this.writeCustomCalendarsFromFile(root, allCustomCalendars);
        document.appendChild(root);
    }

    private void writeCustomCalendarsFromFile(Element root, Map<String, Schedule> allCustomCalendars) {
        for (Map.Entry<String, Schedule> s : allCustomCalendars.entrySet()) {
            Element element = root.getOwnerDocument().createElement("CustomCalendar");
            element.setAttribute("id", s.getKey());
            this.writeCustomCalendar(element, s.getValue());
            root.appendChild(element);
        }
    }

    private void writeCustomCalendar(Element element, Schedule value) {
        element.setTextContent(value.getRule());
    }

    private File getCustomCalendarFile() {
        return new File(this.getDataDir(), CONFIGURATION_FILE);
    }

    private File getDataDir() {
        return this.dataDir;
    }

    @Override
    public void removeCustomCalendar(String id) throws DataSourceException {
        HashMap<String, Schedule> allCustomCalendars = new HashMap<String, Schedule>(this.getAllCustomCalendars());
        allCustomCalendars.remove(id);
        this.updateCustomCalendars(allCustomCalendars);
    }
}

