/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.worklistmanager.timeaware;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.timemanager.InstanceTimeManager;
import de.aristaflow.adept2.core.timemanager.TimeManager;
import de.aristaflow.adept2.core.timemanager.WorklistInteraction;
import de.aristaflow.adept2.core.worklistmanager.WorklistNotification2;
import de.aristaflow.adept2.core.worklistmanager.defaultimplementation.AbstractWorklistManager;
import de.aristaflow.adept2.core.worklistmanager.defaultimplementation.TransientWorklistManager;
import de.aristaflow.adept2.core.worklistmanager.timeaware.TimeAwareWorklistManager;
import de.aristaflow.adept2.core.worklistmanager.timeaware.TimeAwareWorklistNotification;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.configuration.Configuration;

public class TimeAwareTransientWorklistManager
extends TransientWorklistManager
implements TimeAwareWorklistManager {
    private String[] runtimeRequired;
    private TimeManager timeManager;

    public TimeAwareTransientWorklistManager(Configuration configuration, Registry registry) throws ConfigurationException {
        super(configuration, registry);
    }

    public void init(URI[] myURIs) throws AbortServiceException {
        super.init(myURIs);
        this.worklistNotification = new TimeAwareWorklistNotification(this.configuration, (AbstractWorklistManager)this);
    }

    public void start() throws AbortServiceException {
        super.start();
        SessionToken startSession = this.getSessionFactory().getSessionToken(this.getURIs());
        this.timeManager = this.getTimeManager();
        WorklistInteraction worklistInteraction = this.timeManager.getWorklistInteraction();
        worklistInteraction.addWorklistManager(startSession, (WorklistNotification2)this.worklistNotification);
    }

    public String[] getRuntimeRequiredServices() {
        if (this.runtimeRequired == null) {
            HashSet<String> ret = new HashSet<String>();
            ret.addAll(Arrays.asList(super.getRuntimeRequiredServices()));
            ret.addAll(Arrays.asList("TimeManager"));
            this.runtimeRequired = ret.toArray(new String[ret.size()]);
        }
        return this.runtimeRequired;
    }

    @Override
    public InstanceTimeManager getInstanceTimeManager() {
        return this.getTimeManager().getInstanceTimeManager();
    }

    @Override
    public TimeManager getTimeManager() {
        if (this.timeManager == null) {
            SessionToken sessionToken = this.sessionFactory.getSessionToken(this.getURIs());
            try {
                this.timeManager = (TimeManager)this.registry.getServiceOfType(sessionToken, "TimeManager", TimeManager.class);
            }
            catch (ServiceNotKnownException e) {
                throw new RuntimeException(e);
            }
        }
        return this.timeManager;
    }
}

