/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.worklistmanager.timeaware;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.timemanager.InstanceTimeManager;
import de.aristaflow.adept2.core.timemanager.TimeManager;
import de.aristaflow.adept2.core.worklistmanager.WorklistNotification2;
import de.aristaflow.adept2.core.worklistmanager.defaultimplementation.AbstractWorklistManager;
import de.aristaflow.adept2.core.worklistmanager.defaultimplementation.DefaultWorklistNotification;
import de.aristaflow.adept2.core.worklistmanager.timeaware.TimeAwareWorklistManager;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultPluginData;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultPluginDataContainer;
import de.aristaflow.adept2.model.common.timedata.CalendarElement;
import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.common.timedata.WorklistItemTimeContext;
import de.aristaflow.adept2.model.common.viewer.ModelViewer;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.timemodel.InstanceTimeModel;
import de.aristaflow.adept2.model.timemodel.Interval;
import de.aristaflow.adept2.model.timemodel.TimeModelOperations;
import de.aristaflow.adept2.model.timemodel.TimeModelStatus;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklistItem;
import de.aristaflow.adept2.util.DataSourceException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import org.apache.commons.configuration.Configuration;

public class TimeAwareWorklistNotification
extends DefaultWorklistNotification
implements WorklistNotification2 {
    Map<UUID, Set<InternalWorklistItem>> instanceItems = new HashMap<UUID, Set<InternalWorklistItem>>();

    public TimeAwareWorklistNotification(Configuration configuration, AbstractWorklistManager worklistManager) {
        super(configuration, worklistManager);
    }

    protected void postAssignAndUpdateActivityHook(SessionToken session, InternalWorklistItem worklistItem) throws DataSourceException {
        EBPInstanceReference ebpInstanceReference = (EBPInstanceReference)worklistItem.getActivityReference();
        this.injectWorklistItemTimeContext(session, ebpInstanceReference, worklistItem);
    }

    public void postUpdateActivityStateHook(SessionToken session, InternalWorklistItem worklistItem) throws DataSourceException {
        EBPInstanceReference ebpInstanceReference = (EBPInstanceReference)worklistItem.getActivityReference();
        this.injectWorklistItemTimeContext(session, ebpInstanceReference, worklistItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postAddActivityHook(SessionToken session, InternalWorklistItem item) throws DataSourceException {
        EBPInstanceReference ebpInstanceReference = (EBPInstanceReference)item.getActivityReference();
        this.injectWorklistItemTimeContext(session, ebpInstanceReference, item);
        Map<UUID, Set<InternalWorklistItem>> map = this.instanceItems;
        synchronized (map) {
            Set<InternalWorklistItem> list = this.instanceItems.get(ebpInstanceReference.getInstanceID());
            if (list == null) {
                list = new HashSet<InternalWorklistItem>();
                this.instanceItems.put(ebpInstanceReference.getInstanceID(), list);
            }
            list.add(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postRemoveWorklistItemHook(SessionToken session, InternalWorklistItem worklistItem) {
        EBPInstanceReference ebpInstanceReference = (EBPInstanceReference)worklistItem.getActivityReference();
        Map<UUID, Set<InternalWorklistItem>> map = this.instanceItems;
        synchronized (map) {
            Set<InternalWorklistItem> list = this.instanceItems.get(ebpInstanceReference.getInstanceID());
            if (list != null) {
                list.remove(worklistItem);
                if (list.isEmpty()) {
                    this.instanceItems.remove(ebpInstanceReference.getInstanceID());
                }
            }
        }
    }

    private SessionToken getSessionToken() {
        return this.worklistManager.getSessionFactory().getSessionToken(this.worklistManager.getURIs());
    }

    protected void injectWorklistItemTimeContext(SessionToken sessionToken, EBPInstanceReference ebpInstanceReference, InternalWorklistItem item) throws DataSourceException {
        if (!(item instanceof DefaultPluginDataContainer)) {
            this.logger.severe(String.format("EBPInstance '%s' does not implement DefaultPluginDataContainer! Unable to inject temporal information!", item));
        } else {
            DefaultPluginDataContainer pluginDataContainer = (DefaultPluginDataContainer)item;
            HashMap attributes = new HashMap();
            WorklistItemTimeContext context = (WorklistItemTimeContext)ModelViewer.createView(attributes, WorklistItemTimeContext.class);
            InstanceTimeManager instanceTimeManager = this.getInstanceTimeManager();
            TimeManager timeManager = this.getWorklistManager().getTimeManager();
            TimeModelOperations operations = timeManager.getTimeModellingService().getTimeModelFactory().getTimeModelOperations();
            instanceTimeManager.getInstanceTimeContext(sessionToken, ebpInstanceReference.getInstanceID());
            InstanceTimeModel timeModel = instanceTimeManager.getInstanceTimeModelReadonly(sessionToken, ebpInstanceReference.getInstanceID());
            TimeModelStatus timeModelStatus = instanceTimeManager.getTimeModelStatusReadonly(ebpInstanceReference.getInstanceID());
            if (timeModelStatus.getTimeModelStatus() == TimeModelStatus.TimeModelState.VALID) {
                Interval<CalendarElement> startTimeframe = timeModel.getActivityInstanceStartTimeframe(ebpInstanceReference.getNodeID(), ebpInstanceReference.getNodeIteration());
                Interval<TimeDistance> duration = timeModel.getActivityInstanceDuration(ebpInstanceReference.getNodeID(), ebpInstanceReference.getNodeIteration());
                Interval<CalendarElement> completionTimeframe = timeModel.getActivityInstanceCompletionTimeframe(ebpInstanceReference.getNodeID(), ebpInstanceReference.getNodeIteration());
                context.setEarliestStartTime(startTimeframe.getMinValue());
                context.setLatestStartTime(startTimeframe.getMaxValue());
                context.setEarliestCompletionTime(completionTimeframe.getMinValue());
                context.setLatestCompletionTime(completionTimeframe.getMaxValue());
                context.setMinimumDurationRestriction(operations.convertToTimePoint(duration.getMinValue()));
                context.setMaximumDurationRestriction(operations.convertToTimePoint(duration.getMaxValue()));
                context.setTimeModelStatus(TimeModelStatus.TimeModelState.VALID);
                System.out.println("Injecting temporal data... (" + startTimeframe.getMinValue() + "; " + startTimeframe.getMaxValue() + ")");
            } else {
                context.setTimeModelStatus(timeModelStatus.getTimeModelStatus());
                System.out.println("No temporal data available to be injected... (" + (Object)((Object)timeModelStatus.getTimeModelStatus()) + ")");
            }
            DefaultPluginData pluginData = new DefaultPluginData("TimeContext", attributes);
            pluginDataContainer.addSupportedPlugin("TimeContext", "TimeContext", (PluginData)pluginData);
        }
    }

    public InstanceTimeManager getInstanceTimeManager() {
        return this.getWorklistManager().getInstanceTimeManager();
    }

    private TimeAwareWorklistManager getWorklistManager() {
        return (TimeAwareWorklistManager)this.worklistManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateInstance(UUID instance) {
        List<Object> items;
        System.out.println("Asynchronously updating Items for (" + instance + ") to ");
        Map<UUID, Set<InternalWorklistItem>> map = this.instanceItems;
        synchronized (map) {
            Set<InternalWorklistItem> set = this.instanceItems.get(instance);
            items = set != null ? new ArrayList<InternalWorklistItem>(set) : Collections.emptyList();
        }
        SessionToken sessionToken = this.getSessionToken();
        for (InternalWorklistItem item : items) {
            EBPInstanceReference ebpInstanceReference = (EBPInstanceReference)item.getActivityReference();
            try {
                this.injectWorklistItemTimeContext(sessionToken, ebpInstanceReference, item);
                this.worklistManager.notifyWorklistsAboutUpdate(item);
            }
            catch (DataSourceException e) {
                this.logger.log(Level.SEVERE, "DataSourceException occurred!", e);
            }
        }
    }
}

