/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.common.timedata.defaultimplementation;

import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.common.timedata.TimePoint;
import java.util.Map;
import org.apache.commons.collections.map.LRUMap;

public class AdvancedTimeDistance
implements TimeDistance,
TimePoint,
Comparable<TimeDistance> {
    private long miliseconds;
    private long seconds;
    private long minutes;
    private long hours;
    private long days;
    private long months;
    private AdvancedTimeDistance negative = null;
    private int cachedHashCode = 0;
    public static final TimeDistance NEGATIVE_INFINITE_TIME_DISTANCE = new AdvancedTimeDistance(-9223372036854775807L, -9223372036854775807L, -9223372036854775807L, -9223372036854775807L, -9223372036854775807L);
    public static final TimeDistance POSITIVE_INFINITE_TIME_DISTANCE = new AdvancedTimeDistance(Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE);
    public static final TimeDistance ONE_TIME_DISTANCE = new AdvancedTimeDistance(1L, 0L, 0L, 0L, 0L);
    public static final TimeDistance ZERO_TIME_DISTANCE = new AdvancedTimeDistance(0L, 0L, 0L, 0L, 0L);
    public static final TimeDistance EPSILON_TIME_DISTANCE = new AdvancedTimeDistance(1L, 0L, 0L, 0L, 0L, 0L);
    private static final Map<IdentityTuple<TimeDistance, TimeDistance>, TimeDistance> cacheAddTimeDistance = new LRUMap(100000);

    public AdvancedTimeDistance(long seconds, long minutes, long hours, long days, long months) {
        this(0L, seconds, minutes, hours, days, months);
    }

    public AdvancedTimeDistance(long miliseconds, long seconds, long minutes, long hours, long days, long months) {
        assert (miliseconds != Long.MAX_VALUE || seconds != Long.MAX_VALUE || minutes != Long.MAX_VALUE || hours != Long.MAX_VALUE || days != Long.MAX_VALUE || months != Long.MAX_VALUE || seconds == minutes && seconds == hours && seconds == days && seconds == months);
        assert (miliseconds != -9223372036854775807L || seconds != -9223372036854775807L || minutes != -9223372036854775807L || hours != -9223372036854775807L || days != -9223372036854775807L || months != -9223372036854775807L || seconds == minutes && seconds == hours && seconds == days && seconds == months);
        assert (miliseconds != Long.MIN_VALUE || seconds != Long.MIN_VALUE || minutes != Long.MIN_VALUE || hours != Long.MIN_VALUE || days != Long.MIN_VALUE || months != Long.MIN_VALUE);
        this.miliseconds = miliseconds;
        this.seconds = seconds;
        this.minutes = minutes;
        this.hours = hours;
        this.days = days;
        this.months = months;
    }

    public AdvancedTimeDistance(TimePoint timePoint) {
        this(timePoint.getSeconds(), timePoint.getMinutes(), timePoint.getHours(), timePoint.getDays(), timePoint.getMonths());
    }

    @Override
    public long getSeconds() {
        return this.seconds;
    }

    @Override
    public long getMilliseconds() {
        return this.miliseconds;
    }

    @Override
    public void setSeconds(long seconds) {
        this.seconds = seconds;
        this.resetCache();
    }

    private void resetCache() {
        if (this.negative != null) {
            this.negative.negative = null;
            this.negative = null;
        }
        this.cachedHashCode = 0;
    }

    @Override
    public long getMinutes() {
        return this.minutes;
    }

    @Override
    public void setMinutes(long minutes) {
        this.minutes = minutes;
        this.resetCache();
    }

    @Override
    public long getHours() {
        return this.hours;
    }

    @Override
    public void setHours(long hours) {
        this.hours = hours;
        this.resetCache();
    }

    @Override
    public long getDays() {
        return this.days;
    }

    @Override
    public void setDays(long days) {
        this.days = days;
        this.resetCache();
    }

    @Override
    public long getMonths() {
        return this.months;
    }

    @Override
    public void setMonths(long months) {
        this.months = months;
        this.resetCache();
    }

    public String toString() {
        if (this.getMonths() == Long.MAX_VALUE) {
            return "infty";
        }
        if (this.getMonths() == -9223372036854775807L) {
            return "-infty";
        }
        StringBuilder s = new StringBuilder();
        boolean notZero = false;
        if (this.getMonths() != Long.MIN_VALUE && this.getMonths() != 0L) {
            s.append(this.getMonths());
            s.append("M");
            notZero = true;
        }
        if (this.getDays() != Long.MIN_VALUE && (this.getDays() != 0L || notZero)) {
            s.append(this.getDays());
            s.append("d");
            notZero = true;
        }
        if (this.getHours() != Long.MIN_VALUE && (this.getHours() != 0L || notZero)) {
            s.append(this.getHours());
            s.append("h");
            notZero = true;
        }
        if (this.getMinutes() != Long.MIN_VALUE && (this.getMinutes() != 0L || notZero)) {
            s.append(this.getMinutes());
            s.append("m");
            notZero = true;
        }
        if (this.getSeconds() != Long.MIN_VALUE) {
            s.append(this.getSeconds());
            s.append("s");
            notZero = true;
        }
        if (this.getMilliseconds() != Long.MIN_VALUE && this.getMilliseconds() != 0L) {
            s.append(this.getMilliseconds());
            s.append("ms");
            notZero = true;
        }
        if (!notZero) {
            s.append("0s");
        }
        return s.toString();
    }

    @Override
    public TimeDistance neg() {
        if (this.negative == null) {
            this.negative = new AdvancedTimeDistance(this.miliseconds != Long.MIN_VALUE ? -this.miliseconds : Long.MIN_VALUE, this.seconds != Long.MIN_VALUE ? -this.seconds : Long.MIN_VALUE, this.minutes != Long.MIN_VALUE ? -this.minutes : Long.MIN_VALUE, this.hours != Long.MIN_VALUE ? -this.hours : Long.MIN_VALUE, this.days != Long.MIN_VALUE ? -this.days : Long.MIN_VALUE, this.months != Long.MIN_VALUE ? -this.months : Long.MIN_VALUE);
            this.negative.negative = this;
        }
        return this.negative;
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            this.cachedHashCode = 1;
            this.cachedHashCode = 31 * this.cachedHashCode + (this.days != Long.MIN_VALUE ? (int)(this.days ^ this.days >>> 32) : 0);
            this.cachedHashCode = 31 * this.cachedHashCode + (this.hours != Long.MIN_VALUE ? (int)(this.hours ^ this.hours >>> 32) : 0);
            this.cachedHashCode = 31 * this.cachedHashCode + (this.minutes != Long.MIN_VALUE ? (int)(this.minutes ^ this.minutes >>> 32) : 0);
            this.cachedHashCode = 31 * this.cachedHashCode + (this.months != Long.MIN_VALUE ? (int)(this.months ^ this.months >>> 32) : 0);
            this.cachedHashCode = 31 * this.cachedHashCode + (this.seconds != Long.MIN_VALUE ? (int)(this.seconds ^ this.seconds >>> 32) : 0);
            this.cachedHashCode = 31 * this.cachedHashCode + (this.miliseconds != Long.MIN_VALUE ? (int)(this.miliseconds ^ this.miliseconds >>> 32) : 0);
        }
        return this.cachedHashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof TimeDistance) {
            TimeDistance other = (TimeDistance)obj;
            return this.compareTo(other) == 0;
        }
        return super.equals(obj);
    }

    private boolean compareValue(long v1, long v2) {
        if (v1 == v2) {
            return true;
        }
        return v1 == 0L && v2 == Long.MIN_VALUE || v1 == Long.MIN_VALUE && v2 == 0L;
    }

    @Override
    public int compareTo(TimeDistance o) {
        TimeDistance v2 = o;
        if (this.isInfinity()) {
            int s1 = this.sign();
            if (v2.isInfinity() && s1 == v2.sign()) {
                return 0;
            }
            return s1 > 0 ? 1 : -1;
        }
        if (v2.isInfinity()) {
            return v2.sign() > 0 ? -1 : 1;
        }
        long diff = this.toMilliseconds() - v2.toMilliseconds();
        int sgn = diff > 0L ? 1 : (diff < 0L ? -1 : 0);
        return sgn;
    }

    @Override
    public boolean isInfinity() {
        if (this.getMonths() == Long.MAX_VALUE) {
            return true;
        }
        return this.getMonths() == -9223372036854775807L;
    }

    @Override
    public int sign() {
        if (this.isInfinity()) {
            return this.getMonths() > 0L ? 1 : -1;
        }
        long milis = this.toMilliseconds();
        return milis > 0L ? 1 : (milis < 0L ? -1 : 0);
    }

    @Override
    public long toMilliseconds() {
        long milis = this.toSeconds();
        milis *= 1000L;
        if (this.miliseconds != Long.MIN_VALUE) {
            milis += this.miliseconds;
        }
        return milis;
    }

    @Override
    public long toSeconds() {
        if (this.isInfinity()) {
            return this.getMonths() > 0L ? Long.MAX_VALUE : -9223372036854775807L;
        }
        long seconds = 0L;
        if (this.getMonths() != Long.MIN_VALUE) {
            seconds += this.getMonths();
        }
        seconds *= 30L;
        if (this.getDays() != Long.MIN_VALUE) {
            seconds += this.getDays();
        }
        seconds *= 24L;
        if (this.getHours() != Long.MIN_VALUE) {
            seconds += this.getHours();
        }
        seconds *= 60L;
        if (this.getMinutes() != Long.MIN_VALUE) {
            seconds += this.getMinutes();
        }
        seconds *= 60L;
        if (this.getSeconds() != Long.MIN_VALUE) {
            seconds += this.getSeconds();
        }
        return seconds;
    }

    @Override
    public TimeDistance add(TimeDistance timeDistance) {
        IdentityTuple<AdvancedTimeDistance, TimeDistance> cacheKey = new IdentityTuple<AdvancedTimeDistance, TimeDistance>(this, timeDistance);
        TimeDistance sum = cacheAddTimeDistance.get(cacheKey);
        if (sum != null) {
            return sum;
        }
        sum = this.internalAdd(timeDistance);
        cacheAddTimeDistance.put(cacheKey, sum);
        return sum;
    }

    protected TimeDistance internalAdd(TimeDistance summand) {
        long seconds;
        long minutes;
        long hours;
        long days;
        long months;
        if (this.isInfinity() && summand.isInfinity() && this.sign() != summand.sign()) {
            throw new IllegalArgumentException("infinity + (- infinity)");
        }
        if (this.isInfinity()) {
            return this;
        }
        if (summand.isInfinity()) {
            return summand;
        }
        long l = this.getMonths() == Long.MIN_VALUE ? summand.getMonths() : (months = summand.getMonths() == Long.MIN_VALUE ? this.getMonths() : this.getMonths() + summand.getMonths());
        long l2 = this.getDays() == Long.MIN_VALUE ? summand.getDays() : (days = summand.getDays() == Long.MIN_VALUE ? this.getDays() : this.getDays() + summand.getDays());
        long l3 = this.getHours() == Long.MIN_VALUE ? summand.getHours() : (hours = summand.getHours() == Long.MIN_VALUE ? this.getHours() : this.getHours() + summand.getHours());
        long l4 = this.getMinutes() == Long.MIN_VALUE ? summand.getMinutes() : (minutes = summand.getMinutes() == Long.MIN_VALUE ? this.getMinutes() : this.getMinutes() + summand.getMinutes());
        long l5 = this.getSeconds() == Long.MIN_VALUE ? summand.getSeconds() : (seconds = summand.getSeconds() == Long.MIN_VALUE ? this.getSeconds() : this.getSeconds() + summand.getSeconds());
        if (this.getMilliseconds() == Long.MIN_VALUE) {
            summand.getMilliseconds();
        } else if (summand.getMilliseconds() == Long.MIN_VALUE) {
            this.getMilliseconds();
        } else {
            this.getMilliseconds();
            summand.getMilliseconds();
        }
        if (seconds != Long.MIN_VALUE && Math.abs(seconds) >= 60L) {
            minutes = minutes == Long.MIN_VALUE ? seconds / 60L : (minutes += seconds / 60L);
            seconds %= 60L;
        }
        if (minutes != Long.MIN_VALUE) {
            if (this.sign(seconds) != 0 && this.sign(minutes) != 0 && this.sign(seconds) != this.sign(minutes)) {
                if (minutes > 0L) {
                    --minutes;
                    seconds += 60L;
                } else {
                    ++minutes;
                    seconds -= 60L;
                }
            }
            if (Math.abs(minutes) >= 60L) {
                hours = hours == Long.MIN_VALUE ? minutes / 60L : (hours += minutes / 60L);
                minutes %= 60L;
            }
        }
        if (hours != Long.MIN_VALUE) {
            if (this.sign(minutes) != 0 && this.sign(hours) != 0 && this.sign(minutes) != this.sign(hours)) {
                if (hours > 0L) {
                    --hours;
                    minutes += 60L;
                } else {
                    ++hours;
                    minutes -= 60L;
                }
                if (this.sign(seconds) != 0 && this.sign(minutes) != 0 && this.sign(seconds) != this.sign(minutes)) {
                    if (minutes > 0L) {
                        --minutes;
                        seconds += 60L;
                    } else {
                        ++minutes;
                        seconds -= 60L;
                    }
                }
            }
            if (Math.abs(hours) >= 24L) {
                days = days == Long.MIN_VALUE ? hours / 24L : (days += hours / 24L);
                hours %= 24L;
            }
        }
        if (this.sign(days) != 0 && this.sign(hours) != 0 && this.sign(hours) != this.sign(days)) {
            if (days > 0L) {
                --days;
                hours += 24L;
            } else {
                ++days;
                hours -= 24L;
            }
            if (this.sign(minutes) != 0 && this.sign(hours) != 0 && this.sign(minutes) != this.sign(hours)) {
                if (hours > 0L) {
                    --hours;
                    minutes += 60L;
                } else {
                    ++hours;
                    minutes -= 60L;
                }
                if (this.sign(seconds) != 0 && this.sign(minutes) != 0 && this.sign(seconds) != this.sign(minutes)) {
                    if (minutes > 0L) {
                        --minutes;
                        seconds += 60L;
                    } else {
                        ++minutes;
                        seconds -= 60L;
                    }
                }
            }
        }
        return new AdvancedTimeDistance(seconds, minutes, hours, days, months);
    }

    @Override
    public TimeDistance sub(TimeDistance timeDistance) {
        return this.add(timeDistance.neg());
    }

    private int sign(long value) {
        if (value == Long.MIN_VALUE) {
            return 0;
        }
        return value == 0L ? 0 : (value > 0L ? 1 : -1);
    }

    private class IdentityTuple<T1, T2> {
        private final T1 t1;
        private final T2 t2;
        private final int hashCode;

        public IdentityTuple(T1 t1, T2 t2) {
            this.t1 = t1;
            this.t2 = t2;
            this.hashCode = 31 * t1.hashCode() * t2.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o.hashCode() != this.hashCode()) {
                return false;
            }
            if (o instanceof IdentityTuple) {
                IdentityTuple other = (IdentityTuple)o;
                return this.t1.equals(other.t1) && this.t2.equals(other.t2) || this.t1.equals(other.t2) && this.t2.equals(other.t1);
            }
            return false;
        }

        public String toString() {
            return "<" + this.t1 + ", " + this.t2 + ">";
        }
    }
}

