/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.common.timedata.defaultimplementation;

import de.aristaflow.adept2.model.common.timedata.CalendarElement;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class DefaultCalendarElement
implements CalendarElement {
    private long timeInMillis;

    public DefaultCalendarElement(long timeInMillis) {
        if (timeInMillis < 0L) {
            throw new IllegalArgumentException("timeInMillis cannot be negativ!");
        }
        this.timeInMillis = timeInMillis;
    }

    @Override
    public long getTimeInMillis() {
        return this.timeInMillis;
    }

    @Override
    public void setTimeInMillis(long timeInMillis) {
        this.timeInMillis = timeInMillis;
    }

    public String toString() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.timeInMillis);
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
        return df.format(calendar.getTime());
    }

    public int hashCode() {
        return (int)this.timeInMillis;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultCalendarElement) {
            DefaultCalendarElement other = (DefaultCalendarElement)obj;
            return this.timeInMillis == other.timeInMillis;
        }
        return super.equals(obj);
    }
}

