/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.common.timedata.defaultimplementation;

import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.common.timedata.TimePoint;

public class DefaultTimeDistance
implements TimeDistance,
Comparable<TimeDistance> {
    private long miliseconds;
    private DefaultTimeDistance negative = null;
    private int cachedHashCode = 0;
    public static final TimeDistance NEGATIVE_INFINITE_TIME_DISTANCE = new DefaultTimeDistance(-9223372036854775807L, -9223372036854775807L, -9223372036854775807L, -9223372036854775807L, -9223372036854775807L);
    public static final TimeDistance POSITIVE_INFINITE_TIME_DISTANCE = new DefaultTimeDistance(Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE);
    public static final TimeDistance ONE_TIME_DISTANCE = new DefaultTimeDistance(1L, 0L, 0L, 0L, 0L);
    public static final TimeDistance ZERO_TIME_DISTANCE = new DefaultTimeDistance(0L, 0L, 0L, 0L, 0L);
    public static TimeDistance EPSILON_TIME_DISTANCE = new DefaultTimeDistance(1L, 0L, 0L, 0L, 0L, 0L);

    public DefaultTimeDistance(long seconds, long minutes, long hours, long days, long months) {
        this(0L, seconds, minutes, hours, days, months);
    }

    public DefaultTimeDistance(long miliseconds, long seconds, long minutes, long hours, long days, long months) {
        long value;
        assert (miliseconds != Long.MIN_VALUE || seconds != Long.MIN_VALUE || minutes != Long.MIN_VALUE || hours != Long.MIN_VALUE || days != Long.MIN_VALUE || months != Long.MIN_VALUE);
        if (miliseconds == Long.MAX_VALUE || seconds == Long.MAX_VALUE || minutes == Long.MAX_VALUE || hours == Long.MAX_VALUE || days == Long.MAX_VALUE || months == Long.MAX_VALUE) {
            value = Long.MAX_VALUE;
        } else if (miliseconds == -9223372036854775807L || seconds == -9223372036854775807L || minutes == -9223372036854775807L || hours == -9223372036854775807L || days == -9223372036854775807L || months == -9223372036854775807L) {
            value = -9223372036854775807L;
        } else {
            value = months != Long.MIN_VALUE ? months : 0L;
            value *= 30L;
            value += days != Long.MIN_VALUE ? days : 0L;
            value *= 24L;
            value += hours != Long.MIN_VALUE ? hours : 0L;
            value *= 60L;
            value += minutes != Long.MIN_VALUE ? minutes : 0L;
            value *= 60L;
            value += seconds != Long.MIN_VALUE ? seconds : 0L;
            value *= 1000L;
            value += miliseconds;
        }
        this.miliseconds = value;
    }

    private DefaultTimeDistance(long miliseconds) {
        this.miliseconds = miliseconds;
    }

    public DefaultTimeDistance(TimePoint timePoint) {
        this(timePoint.getSeconds(), timePoint.getMinutes(), timePoint.getHours(), timePoint.getDays(), timePoint.getMonths());
    }

    @Override
    public long getSeconds() {
        if (this.isInfinity()) {
            return this.miliseconds;
        }
        return this.miliseconds / 1000L % 60L;
    }

    @Override
    public long getMilliseconds() {
        if (this.isInfinity()) {
            return this.miliseconds;
        }
        return this.miliseconds % 1000L;
    }

    @Override
    public long getMinutes() {
        if (this.isInfinity()) {
            return this.miliseconds;
        }
        return this.miliseconds / 1000L / 60L % 60L;
    }

    @Override
    public long getHours() {
        if (this.isInfinity()) {
            return this.miliseconds;
        }
        return this.miliseconds / 1000L / 60L / 60L % 24L;
    }

    @Override
    public long getDays() {
        if (this.isInfinity()) {
            return this.miliseconds;
        }
        return this.miliseconds / 1000L / 60L / 60L / 24L;
    }

    @Override
    public long getMonths() {
        if (this.isInfinity()) {
            return this.miliseconds;
        }
        return 0L;
    }

    public String toString() {
        if (this.miliseconds == Long.MAX_VALUE) {
            return "infty";
        }
        if (this.miliseconds == -9223372036854775807L) {
            return "-infty";
        }
        StringBuilder s = new StringBuilder();
        boolean notZero = false;
        if (this.getMonths() != 0L) {
            s.append(this.getMonths());
            s.append("M");
            notZero = true;
        }
        if (this.getDays() != 0L || notZero) {
            s.append(this.getDays());
            s.append("d");
            notZero = true;
        }
        if (this.getHours() != 0L || notZero) {
            s.append(this.getHours());
            s.append("h");
            notZero = true;
        }
        if (this.getMinutes() != 0L || notZero) {
            s.append(this.getMinutes());
            s.append("m");
            notZero = true;
        }
        if (this.getSeconds() != 0L || notZero) {
            s.append(this.getSeconds());
            s.append("s");
            notZero = true;
        }
        if (this.getMilliseconds() != 0L) {
            s.append(this.getMilliseconds());
            s.append("ms");
            notZero = true;
        }
        if (!notZero) {
            s.append("0s");
        }
        return s.toString();
    }

    @Override
    public TimeDistance neg() {
        if (this.negative == null) {
            this.negative = new DefaultTimeDistance(-this.miliseconds);
            this.negative.negative = this;
        }
        return this.negative;
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            this.cachedHashCode = 1;
            this.cachedHashCode = 31 * this.cachedHashCode + (int)(this.miliseconds ^ this.miliseconds >>> 32);
        }
        return this.cachedHashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof TimeDistance) {
            TimeDistance other = (TimeDistance)obj;
            return this.compareTo(other) == 0;
        }
        return super.equals(obj);
    }

    @Override
    public int compareTo(TimeDistance o) {
        TimeDistance v2 = o;
        if (this.isInfinity()) {
            int s1 = this.sign();
            if (v2.isInfinity() && s1 == v2.sign()) {
                return 0;
            }
            return s1 > 0 ? 1 : -1;
        }
        if (v2.isInfinity()) {
            return v2.sign() > 0 ? -1 : 1;
        }
        long diff = this.toMilliseconds() - v2.toMilliseconds();
        int sgn = diff > 0L ? 1 : (diff < 0L ? -1 : 0);
        return sgn;
    }

    @Override
    public boolean isInfinity() {
        if (this.miliseconds == Long.MAX_VALUE) {
            return true;
        }
        return this.miliseconds == -9223372036854775807L;
    }

    @Override
    public int sign() {
        if (this.isInfinity()) {
            return this.miliseconds > 0L ? 1 : -1;
        }
        long milis = this.toMilliseconds();
        return milis > 0L ? 1 : (milis < 0L ? -1 : 0);
    }

    @Override
    public long toMilliseconds() {
        if (this.isInfinity()) {
            return this.miliseconds > 0L ? Long.MAX_VALUE : -9223372036854775807L;
        }
        return this.miliseconds;
    }

    @Override
    public long toSeconds() {
        if (this.isInfinity()) {
            return this.miliseconds > 0L ? Long.MAX_VALUE : -9223372036854775807L;
        }
        return this.miliseconds / 1000L;
    }

    @Override
    public TimeDistance add(TimeDistance timeDistance) {
        TimeDistance sum = this.internalAdd(timeDistance);
        return sum;
    }

    protected TimeDistance internalAdd(TimeDistance summand) {
        if (this.isInfinity() && summand.isInfinity() && this.sign() != summand.sign()) {
            throw new IllegalArgumentException("infinity + (- infinity)");
        }
        if (this.isInfinity()) {
            return this;
        }
        if (summand.isInfinity()) {
            return summand;
        }
        long milliseconds = this.miliseconds + summand.toMilliseconds();
        return new DefaultTimeDistance(milliseconds);
    }

    @Override
    public TimeDistance sub(TimeDistance timeDistance) {
        return this.add(timeDistance.neg());
    }
}

