/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.common.timedata.defaultimplementation;

import de.aristaflow.adept2.model.common.timedata.TimePoint;

public class DefaultTimePoint
implements TimePoint {
    private long seconds;
    private long minutes;
    private long hours;
    private long days;
    private long months;

    public DefaultTimePoint(long seconds) {
        this(seconds, Long.MIN_VALUE, Long.MIN_VALUE, Long.MIN_VALUE, Long.MIN_VALUE);
    }

    public DefaultTimePoint(long seconds, long minutes, long hours, long days, long months) {
        assert (seconds != Long.MAX_VALUE || minutes != Long.MAX_VALUE || hours != Long.MAX_VALUE || days != Long.MAX_VALUE || months != Long.MAX_VALUE || seconds == minutes && seconds == hours && seconds == days && seconds == months);
        assert (seconds != -9223372036854775807L || minutes != -9223372036854775807L || hours != -9223372036854775807L || days != -9223372036854775807L || months != -9223372036854775807L || seconds == minutes && seconds == hours && seconds == days && seconds == months);
        assert (seconds != Long.MIN_VALUE || minutes != Long.MIN_VALUE || hours != Long.MIN_VALUE || days != Long.MIN_VALUE || months != Long.MIN_VALUE);
        this.seconds = seconds;
        this.minutes = minutes;
        this.hours = hours;
        this.days = days;
        this.months = months;
    }

    @Override
    public long getSeconds() {
        return this.seconds;
    }

    @Override
    public void setSeconds(long seconds) {
        this.seconds = seconds;
    }

    @Override
    public long getMinutes() {
        return this.minutes;
    }

    @Override
    public void setMinutes(long minutes) {
        this.minutes = minutes;
    }

    @Override
    public long getHours() {
        return this.hours;
    }

    @Override
    public void setHours(long hours) {
        this.hours = hours;
    }

    @Override
    public long getDays() {
        return this.days;
    }

    @Override
    public void setDays(long days) {
        this.days = days;
    }

    @Override
    public long getMonths() {
        return this.months;
    }

    @Override
    public void setMonths(long months) {
        this.months = months;
    }

    public String toString() {
        if (this.getMonths() == Long.MAX_VALUE) {
            return "infty";
        }
        if (this.getMonths() == -9223372036854775807L) {
            return "-infty";
        }
        StringBuilder s = new StringBuilder();
        boolean notZero = false;
        if (this.getMonths() != Long.MIN_VALUE && this.getMonths() != 0L) {
            s.append(this.getMonths());
            s.append("M");
            notZero = true;
        }
        if (this.getDays() != Long.MIN_VALUE && (this.getDays() != 0L || notZero)) {
            s.append(this.getDays());
            s.append("d");
            notZero = true;
        }
        if (this.getHours() != Long.MIN_VALUE && (this.getHours() != 0L || notZero)) {
            s.append(this.getHours());
            s.append("h");
            notZero = true;
        }
        if (this.getMinutes() != Long.MIN_VALUE && (this.getMinutes() != 0L || notZero)) {
            s.append(this.getMinutes());
            s.append("m");
            notZero = true;
        }
        if (this.getSeconds() != Long.MIN_VALUE) {
            s.append(this.getSeconds());
            s.append("s");
            notZero = true;
        }
        if (!notZero) {
            s.append("0s");
        }
        return s.toString();
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.days != Long.MIN_VALUE ? (int)(this.days ^ this.days >>> 32) : 0);
        hashCode = 31 * hashCode + (this.hours != Long.MIN_VALUE ? (int)(this.hours ^ this.hours >>> 32) : 0);
        hashCode = 31 * hashCode + (this.minutes != Long.MIN_VALUE ? (int)(this.minutes ^ this.minutes >>> 32) : 0);
        hashCode = 31 * hashCode + (this.months != Long.MIN_VALUE ? (int)(this.months ^ this.months >>> 32) : 0);
        hashCode = 31 * hashCode + (this.seconds != Long.MIN_VALUE ? (int)(this.seconds ^ this.seconds >>> 32) : 0);
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof TimePoint) {
            TimePoint cfr_ignored_0 = (TimePoint)obj;
        }
        return super.equals(obj);
    }
}

