/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.processmodel.algorithms;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.ExtractSubprocess;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemporalTemplate;
import de.aristaflow.adept2.model.processmodel.algorithms.sesedecomposition.NestedSESE;
import de.aristaflow.adept2.model.processmodel.algorithms.sesedecomposition.SESERegion;
import de.aristaflow.adept2.model.timemodel.tcn.cstnuImpl.CSTNUTimeModelFactory;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.logging.Logger;

public class TemplateHierarchization {
    private ProcessModelFactory pmf;
    private Logger logger = LoggerTools.getLogger((Object)this);

    public TemplateHierarchization(ProcessModelFactory pmf) {
        this.pmf = pmf;
    }

    public void hierachize(SessionToken session, ChangeableTemplate template, UpdateManager updateManager) {
        CSTNUTimeModelFactory timeModelFactory = new CSTNUTimeModelFactory();
        TemporalTemplate temporalTemplate = timeModelFactory.createTemporalTemplate((Template)template);
        NestedSESE seseDecomposition = new NestedSESE();
        SESERegion seseTree = seseDecomposition.transform(temporalTemplate);
        for (SESERegion childBlock : seseTree.getChildren()) {
            this.hierachize(session, template, childBlock, updateManager);
        }
    }

    private void hierachize(SessionToken session, ChangeableTemplate template, SESERegion block, UpdateManager updateManager) {
        for (SESERegion childBlock : block.getChildren()) {
            this.hierachize(session, template, childBlock, updateManager);
        }
        if (ExtractSubprocess.isPossible((ChangeableTemplate)template, (Node)block.getEntryNode(), (Node)block.getExitNode())) {
            ExtractSubprocess.performOperation((SessionToken)session, (ChangeableTemplate)template, (Node)block.getEntryNode(), (Node)block.getExitNode(), (UpdateManager)updateManager);
        } else {
            this.logger.severe(String.format("Could not extract SESE-Block '%s'", block));
        }
    }
}

