/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.processmodel.algorithms.sesedecomposition;

import de.aristaflow.adept2.model.processmodel.algorithms.sesedecomposition.CQClass;
import de.aristaflow.adept2.model.processmodel.algorithms.sesedecomposition.EdgeStruct;
import de.aristaflow.adept2.model.processmodel.algorithms.sesedecomposition.NodeStruct;
import de.aristaflow.adept2.model.timemodel.tools.AbstractGraphVisitor;
import de.aristaflow.adept2.model.timemodel.tools.DepthFirstSearch;
import de.aristaflow.adept2.model.timemodel.tools.GraphVisitor;
import de.aristaflow.adept2.model.timemodel.tools.UndirectedGraph;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;

public class CycleEquivalence {
    public Map<CQClass, List<EdgeStruct>> transform(UndirectedGraph<NodeStruct, EdgeStruct> graph, NodeStruct sourceNode) {
        Queue<NodeStruct> reverseDepthFirst = this.constructDepthFirstSpanningTree(graph, sourceNode);
        for (NodeStruct n : reverseDepthFirst) {
            this.computeCycleEquivalency(graph, n);
        }
        Map<CQClass, List<EdgeStruct>> equivalencyClasses = this.createEquivalencyClasses(graph, sourceNode);
        return equivalencyClasses;
    }

    private Map<CQClass, List<EdgeStruct>> createEquivalencyClasses(UndirectedGraph<NodeStruct, EdgeStruct> graph, NodeStruct sourceNode) {
        final HashMap<CQClass, List<EdgeStruct>> equiv = new HashMap<CQClass, List<EdgeStruct>>();
        DepthFirstSearch<NodeStruct, EdgeStruct> depthFirst = new DepthFirstSearch<NodeStruct, EdgeStruct>(graph);
        depthFirst.performDepthFirstSearch((GraphVisitor<NodeStruct, EdgeStruct>)new AbstractGraphVisitor<NodeStruct, EdgeStruct>(){

            @Override
            public void discoverEdge(NodeStruct startVertex, NodeStruct endVertex, EdgeStruct edge) {
                CQClass cq = edge.CQclass;
                LinkedList<EdgeStruct> l = (LinkedList<EdgeStruct>)equiv.get(cq);
                if (l == null) {
                    l = new LinkedList<EdgeStruct>();
                    equiv.put(cq, l);
                }
                if (!l.contains(edge)) {
                    l.add(edge);
                }
            }
        }, sourceNode);
        return equiv;
    }

    private void computeCycleEquivalency(UndirectedGraph<NodeStruct, EdgeStruct> graph, NodeStruct n) {
        NodeStruct t;
        EdgeStruct e3;
        NodeStruct hi0 = null;
        for (EdgeStruct e2 : n.backedges) {
            NodeStruct t2 = this.otherEnd(e2, n);
            if (hi0 != null && t2.number >= hi0.number) continue;
            hi0 = t2;
        }
        NodeStruct hi1 = null;
        NodeStruct hi2 = null;
        for (EdgeStruct e3 : n.children) {
            t = this.otherEnd(e3, n);
            if (hi1 == null || t.hi.number < hi1.number) {
                if (hi2 == null || hi1 != null && hi1.number < hi2.number) {
                    hi2 = hi1;
                }
                hi1 = t.hi;
                continue;
            }
            if (hi2 != null && t.hi.number >= hi2.number) continue;
            hi2 = t.hi;
        }
        n.hi = hi0 == null ? hi1 : (hi1 == null ? hi0 : (hi0.number < hi1.number ? hi0 : hi1));
        n.blist = new LinkedList();
        for (EdgeStruct e3 : n.children) {
            t = this.otherEnd(e3, n);
            LinkedList<EdgeStruct> blist = t.blist;
            if (blist == null) continue;
            n.blist.addAll(blist);
        }
        for (EdgeStruct e3 : n.capping) {
            n.blist.remove(e3);
        }
        for (EdgeStruct e3 : n.backedges) {
            if (this.otherEnd((EdgeStruct)e3, (NodeStruct)n).number <= n.number) continue;
            n.blist.remove(e3);
            if (e3.CQclass != null) continue;
            e3.CQclass = new CQClass(e3, n.number);
        }
        for (EdgeStruct e3 : n.backedges) {
            if (this.otherEnd((EdgeStruct)e3, (NodeStruct)n).number > n.number) continue;
            n.blist.push(e3);
            e3.recentSize = -1;
        }
        if (hi2 != null && (hi0 == null || hi0.number > hi2.number)) {
            assert (n.children.size() > 1);
            EdgeStruct d = new EdgeStruct(n, hi2);
            hi2.capping.add(d);
            n.blist.push(d);
        } else assert (n.children.size() <= 1) : String.valueOf(hi0.number) + ">" + hi2.number;
        e3 = n.parent;
        if (e3 != null) {
            EdgeStruct b = n.blist.get(0);
            if (b.recentSize != n.blist.size()) {
                b.recentSize = n.blist.size();
                b.recentClass = new CQClass(b, n.blist.size());
            }
            e3.CQclass = b.recentClass;
            if (b.recentSize == 1) {
                b.CQclass = e3.CQclass;
            }
        }
    }

    private NodeStruct otherEnd(EdgeStruct e, NodeStruct n) {
        return e.n1 == n ? e.n2 : e.n1;
    }

    private Queue<NodeStruct> constructDepthFirstSpanningTree(UndirectedGraph<NodeStruct, EdgeStruct> graph, NodeStruct sourceNode) {
        DepthFirstSearch<NodeStruct, EdgeStruct> depthFirst = new DepthFirstSearch<NodeStruct, EdgeStruct>(graph);
        final LinkedList<NodeStruct> reverseDepthFirst = new LinkedList<NodeStruct>();
        depthFirst.performDepthFirstSearch((GraphVisitor<NodeStruct, EdgeStruct>)new AbstractGraphVisitor<NodeStruct, EdgeStruct>(){
            int dfsnum = 0;

            @Override
            public void discoverVertex(NodeStruct vertex) {
                vertex.number = this.dfsnum++;
            }

            @Override
            public void finishVertex(NodeStruct vertex) {
                reverseDepthFirst.offer(vertex);
            }

            @Override
            public void discoverEdge(NodeStruct startVertex, NodeStruct endVertex, EdgeStruct edge) {
                if (endVertex.number < 0) {
                    startVertex.children.add(edge);
                    endVertex.parent = edge;
                } else if (edge != startVertex.parent) {
                    startVertex.backedges.add(edge);
                }
            }
        }, sourceNode);
        return reverseDepthFirst;
    }
}

