/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.processmodel.algorithms.sesedecomposition;

import de.aristaflow.adept2.model.processmodel.TemporalTemplate;
import de.aristaflow.adept2.model.processmodel.algorithms.sesedecomposition.CQClass;
import de.aristaflow.adept2.model.processmodel.algorithms.sesedecomposition.CycleEquivalence;
import de.aristaflow.adept2.model.processmodel.algorithms.sesedecomposition.EdgeStruct;
import de.aristaflow.adept2.model.processmodel.algorithms.sesedecomposition.NodeStruct;
import de.aristaflow.adept2.model.processmodel.algorithms.sesedecomposition.RegionStruct;
import de.aristaflow.adept2.model.processmodel.algorithms.sesedecomposition.SESERegion;
import de.aristaflow.adept2.model.processmodel.algorithms.sesedecomposition.UndirectedGraphTransformation;
import de.aristaflow.adept2.model.timemodel.tools.DefaultUndirectedGraph;
import de.aristaflow.adept2.model.timemodel.tools.UndirectedGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class NestedSESE {
    public SESERegion transform(TemporalTemplate template) {
        UndirectedGraphTransformation<NodeStruct, EdgeStruct> graphTrafo = new UndirectedGraphTransformation<NodeStruct, EdgeStruct>(new UndirectedGraphTransformation.UndirectedGraphFactory<NodeStruct, EdgeStruct>(){

            @Override
            public NodeStruct createVertex(Object vertex, boolean representative) {
                return new NodeStruct(vertex, representative);
            }

            @Override
            public EdgeStruct createEdge(NodeStruct v1, NodeStruct v2, Object edge) {
                return new EdgeStruct(v1, v2);
            }

            @Override
            public UndirectedGraph<NodeStruct, EdgeStruct> createGraph(List<NodeStruct> vertices) {
                return new DefaultUndirectedGraph<NodeStruct, EdgeStruct>(vertices);
            }
        });
        UndirectedGraph<NodeStruct, EdgeStruct> graph = graphTrafo.transform(template);
        NodeStruct sourceNode = (NodeStruct)graphTrafo.sourceNode;
        NodeStruct sinkNode = (NodeStruct)graphTrafo.sinkNode;
        NestedSESE sese = new NestedSESE();
        RegionStruct rootRegion = sese.transform(graph, sourceNode, sinkNode);
        rootRegion = sese.canonicalize(rootRegion);
        SESERegion regions = graphTrafo.transform(rootRegion);
        return regions;
    }

    public RegionStruct transform(UndirectedGraph<NodeStruct, EdgeStruct> graph, NodeStruct sourceNode, NodeStruct sinkNode) {
        CycleEquivalence ceq = new CycleEquivalence();
        Map<CQClass, List<EdgeStruct>> cdClasses = ceq.transform(graph, sourceNode);
        HashMap<EdgeStruct, RegionStruct> entryRegion = new HashMap<EdgeStruct, RegionStruct>();
        HashMap<EdgeStruct, RegionStruct> exitRegion = new HashMap<EdgeStruct, RegionStruct>();
        System.out.println(cdClasses);
        for (List<EdgeStruct> l : cdClasses.values()) {
            EdgeStruct prev = null;
            for (EdgeStruct o : l) {
                if (prev != null) {
                    RegionStruct r = new RegionStruct(prev, o);
                    if (entryRegion.put(prev, r) != null) assert (false);
                    if (exitRegion.put(o, r) != null) assert (false);
                }
                prev = o;
            }
        }
        HashSet<Object> visited = new HashSet<Object>();
        visited.add(sourceNode);
        LinkedList<Object> nodeS = new LinkedList<Object>();
        nodeS.push(sourceNode);
        RegionStruct topLevel = new RegionStruct(null, null);
        LinkedList<RegionStruct> regionS = new LinkedList<RegionStruct>();
        regionS.push(topLevel);
        HashMap<NodeStruct, RegionStruct> smallestSESE = new HashMap<NodeStruct, RegionStruct>();
        while (!nodeS.isEmpty()) {
            NodeStruct node;
            assert (nodeS.size() == regionS.size());
            Object o = nodeS.pop();
            RegionStruct cR = (RegionStruct)regionS.pop();
            if (o instanceof NodeStruct) {
                smallestSESE.put((NodeStruct)o, cR);
                cR.nodes.add((NodeStruct)o);
            } else {
                RegionStruct r1 = (RegionStruct)entryRegion.get(o);
                RegionStruct r2 = (RegionStruct)exitRegion.get(o);
                if (cR.equals(r1)) {
                    cR = cR.parent;
                    r1 = null;
                }
                if (cR.equals(r2)) {
                    cR = cR.parent;
                    r2 = null;
                }
                if (r1 != null) {
                    if (!this.isParentOf(r1, cR)) {
                        RegionStruct.link(cR, r1);
                    }
                    cR = r1;
                } else if (r2 != null) {
                    if (!this.isParentOf(r2, cR)) {
                        RegionStruct.link(cR, r2);
                    }
                    cR = r2;
                } else {
                    System.out.println("empty region: " + o);
                }
            }
            if (o instanceof NodeStruct) {
                List<EdgeStruct> succ = this.getOutgoingEdges(graph, (NodeStruct)o);
                for (EdgeStruct edge : succ) {
                    if (visited.contains(edge)) continue;
                    nodeS.push(edge);
                    regionS.push(cR);
                    visited.add(edge);
                }
                continue;
            }
            if (!(o instanceof EdgeStruct) || visited.contains(node = ((EdgeStruct)o).n2)) continue;
            nodeS.push(node);
            regionS.push(cR);
            visited.add(node);
        }
        assert (nodeS.isEmpty() && regionS.isEmpty());
        return topLevel;
    }

    private boolean isParentOf(RegionStruct potentialParent, RegionStruct region) {
        RegionStruct p = region;
        while (p.parent != null) {
            if (p.parent == potentialParent) {
                return true;
            }
            p = p.parent;
        }
        return false;
    }

    private List<EdgeStruct> getOutgoingEdges(UndirectedGraph<NodeStruct, EdgeStruct> graph, NodeStruct node) {
        Collection<NodeStruct> vertices = graph.getVertices();
        ArrayList<EdgeStruct> edges = new ArrayList<EdgeStruct>(vertices.size());
        for (NodeStruct v : vertices) {
            EdgeStruct edge = graph.getEdge(node, v);
            if (edge == null) continue;
            edges.add(edge);
        }
        return edges;
    }

    public Map<NodeStruct, RegionStruct> canonicalize(Map<NodeStruct, RegionStruct> smallestSESE) {
        HashMap<NodeStruct, RegionStruct> seseBlocks = new HashMap<NodeStruct, RegionStruct>(smallestSESE);
        for (Map.Entry entry : seseBlocks.entrySet()) {
            RegionStruct region = (RegionStruct)entry.getValue();
            if (region.parent == null) continue;
            boolean change = true;
            while (change) {
                change = false;
                for (RegionStruct region2 : region.parent.children) {
                    if (region.exit == region2.entry) {
                        region = RegionStruct.merge(region, region2);
                        entry.setValue(region);
                        change = true;
                        continue;
                    }
                    if (region2.exit != region.entry) continue;
                    region = RegionStruct.merge(region2, region);
                    entry.setValue(region);
                    change = true;
                }
            }
        }
        return seseBlocks;
    }

    public RegionStruct canonicalize(RegionStruct topLevel) {
        boolean change = true;
        while (change) {
            change = false;
            Iterator<RegionStruct> iterator = topLevel.children.iterator();
            block1: while (iterator.hasNext()) {
                RegionStruct region1 = iterator.next();
                for (RegionStruct region2 : topLevel.children) {
                    if (region1 == region2) continue;
                    if (region1.exit == region2.entry) {
                        System.out.print("Merging " + region1 + " and " + region2 + " to ");
                        iterator.remove();
                        region2.children.addAll(region1.children);
                        region2.nodes.addAll(region1.nodes);
                        region2.entry = region1.entry;
                        System.out.println(region2);
                        change = true;
                        continue block1;
                    }
                    if (region2.exit != region1.entry) continue;
                    iterator.remove();
                    region2.children.addAll(region1.children);
                    region2.nodes.addAll(region1.nodes);
                    region2.exit = region1.exit;
                    change = true;
                    continue block1;
                }
            }
        }
        return topLevel;
    }
}

