/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.processmodel.algorithms.sesedecomposition;

import de.aristaflow.adept2.model.processmodel.algorithms.sesedecomposition.EdgeStruct;
import de.aristaflow.adept2.model.processmodel.algorithms.sesedecomposition.NodeStruct;
import java.util.ArrayList;
import java.util.List;

class RegionStruct {
    public EdgeStruct entry;
    public EdgeStruct exit;
    public RegionStruct parent;
    public List<NodeStruct> nodes = new ArrayList<NodeStruct>();
    public int level;
    public List<RegionStruct> children = new ArrayList<RegionStruct>();

    public RegionStruct(EdgeStruct e1, EdgeStruct e2) {
        this.entry = e1;
        this.exit = e2;
    }

    public static void link(RegionStruct parent, RegionStruct child) {
        child.level = 1 + parent.level;
        child.parent = parent;
        parent.children.add(child);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n[");
        stringBuilder.append(this.entry);
        stringBuilder.append("--");
        stringBuilder.append(this.exit);
        stringBuilder.append("]");
        stringBuilder.append("{");
        String sep = "";
        for (NodeStruct n : this.nodes) {
            stringBuilder.append(sep);
            stringBuilder.append(n);
            sep = ", ";
        }
        stringBuilder.append("}");
        stringBuilder.append("{");
        sep = "";
        for (RegionStruct child : this.children) {
            stringBuilder.append(sep);
            stringBuilder.append(child);
            sep = ", ";
        }
        if (sep != "") {
            stringBuilder.append('\n');
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public static RegionStruct merge(RegionStruct region1, RegionStruct region2) {
        if (region1.exit != region2.entry || region1.parent != region2.parent) {
            throw new IllegalArgumentException();
        }
        RegionStruct merge = new RegionStruct(region1.entry, region2.exit);
        merge.level = region1.level;
        merge.parent = region1.parent;
        merge.children.addAll(region1.children);
        merge.children.addAll(region2.children);
        merge.nodes.addAll(region1.nodes);
        merge.nodes.addAll(region2.nodes);
        return merge;
    }
}

