/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.processmodel.algorithms.sesedecomposition;

import de.aristaflow.adept2.model.processmodel.Node;
import java.util.ArrayList;
import java.util.List;

public class SESERegion {
    private final Node entryNode;
    private final Node exitNode;
    private final List<Node> nodes = new ArrayList<Node>();
    private final List<SESERegion> children = new ArrayList<SESERegion>();
    private SESERegion parent;

    public SESERegion(Node entryNode, Node exitNode) {
        this.entryNode = entryNode;
        this.exitNode = exitNode;
        this.nodes.add(entryNode);
        this.nodes.add(exitNode);
    }

    public Node getEntryNode() {
        return this.entryNode;
    }

    public Node getExitNode() {
        return this.exitNode;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n[");
        stringBuilder.append(this.entryNode);
        stringBuilder.append("--");
        stringBuilder.append(this.exitNode);
        stringBuilder.append("]");
        stringBuilder.append("{");
        String sep = "";
        for (Node n : this.nodes) {
            stringBuilder.append(sep);
            stringBuilder.append(n);
            sep = ", ";
        }
        stringBuilder.append("}");
        stringBuilder.append("{\n");
        sep = "";
        for (SESERegion child : this.getChildren()) {
            stringBuilder.append(sep);
            stringBuilder.append(child);
            sep = ", ";
        }
        stringBuilder.append("\n}\n");
        return stringBuilder.toString();
    }

    void addNode(Node node) {
        this.nodes.add(node);
    }

    void addChildRegion(SESERegion region) {
        this.getChildren().add(region);
        region.parent = this;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public List<SESERegion> getChildren() {
        return this.children;
    }

    public SESERegion getParent() {
        return this.parent;
    }
}

