/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.processmodel.algorithms.sesedecomposition;

import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.StructuredConstraintEdge;
import de.aristaflow.adept2.model.processmodel.StructuredEdge;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemporalTemplate;
import de.aristaflow.adept2.model.processmodel.algorithms.sesedecomposition.EdgeStruct;
import de.aristaflow.adept2.model.processmodel.algorithms.sesedecomposition.NodeStruct;
import de.aristaflow.adept2.model.processmodel.algorithms.sesedecomposition.RegionStruct;
import de.aristaflow.adept2.model.processmodel.algorithms.sesedecomposition.SESERegion;
import de.aristaflow.adept2.model.timemodel.tools.DefaultUndirectedGraph;
import de.aristaflow.adept2.model.timemodel.tools.DepthFirstSearch;
import de.aristaflow.adept2.model.timemodel.tools.DirectedGraph;
import de.aristaflow.adept2.model.timemodel.tools.Graph;
import de.aristaflow.adept2.model.timemodel.tools.GraphVisitor;
import de.aristaflow.adept2.model.timemodel.tools.UndirectedGraph;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UndirectedGraphTransformation<V, E> {
    private UndirectedGraphFactory<V, E> factory;
    public V sourceNode;
    public V sinkNode;

    public UndirectedGraphTransformation(UndirectedGraphFactory<V, E> factory) {
        this.factory = factory;
    }

    public <N, C> UndirectedGraph<V, E> transform(DirectedGraph<N, C> directedGraph, N startNode) {
        DepthFirstSearch<N, C> depthFirstSearch = new DepthFirstSearch<N, C>(directedGraph);
        final ArrayList vertices = new ArrayList();
        final HashMap representatives = new HashMap();
        final Object[] turnaroundpoint = new Object[1];
        depthFirstSearch.performDepthFirstSearch(new GraphVisitor<N, C>(){

            @Override
            public void discoverGraph(Graph<N, C> graph) {
            }

            @Override
            public void finishGraph(Graph<N, C> graph) {
            }

            @Override
            public void discoverVertex(N vertex) {
                Object ni = UndirectedGraphTransformation.this.factory.createVertex(vertex, false);
                Object v = UndirectedGraphTransformation.this.factory.createVertex(vertex, true);
                Object no = UndirectedGraphTransformation.this.factory.createVertex(vertex, false);
                vertices.add(ni);
                vertices.add(v);
                vertices.add(no);
                representatives.put(vertex, new Object[]{ni, v, no});
            }

            @Override
            public void finishVertex(N vertex) {
                if (turnaroundpoint[0] == null) {
                    turnaroundpoint[0] = ((Object[])representatives.get(vertex))[2];
                }
            }

            @Override
            public void discoverEdge(N startVertex, N endVertex, C edge) {
            }

            @Override
            public void finishEdge(N startVertex, N endVertex, C edge) {
            }
        }, startNode);
        DefaultUndirectedGraph<E, E> undirectedGraph = new DefaultUndirectedGraph<E, E>(vertices);
        for (Object[] rep : representatives.values()) {
            Object ni = rep[0];
            Object v = rep[1];
            Object no = rep[2];
            undirectedGraph.addEdge(ni, v, this.factory.createEdge(ni, v, null));
            undirectedGraph.addEdge(v, no, this.factory.createEdge(v, no, null));
        }
        for (Object sourceNode : directedGraph.getVertices()) {
            for (N destNode : directedGraph.getVertices()) {
                C edge = directedGraph.getEdge(sourceNode, destNode);
                if (edge == null) continue;
                Object[] sourceRep = (Object[])representatives.get(sourceNode);
                Object[] destRep = (Object[])representatives.get(destNode);
                Object source = sourceRep[2];
                Object dest = destRep[0];
                undirectedGraph.addEdge(source, dest, this.factory.createEdge(source, dest, edge));
            }
        }
        vertices.get(0);
        Object cfr_ignored_0 = turnaroundpoint[0];
        Object[] source = (Object[])representatives.get(startNode);
        this.sourceNode = source[0];
        this.sinkNode = turnaroundpoint[0];
        return undirectedGraph;
    }

    public UndirectedGraph<V, E> transform(TemporalTemplate template) {
        Set nodes = template.getNodes();
        final ArrayList vertices = new ArrayList(nodes.size() * 3);
        final HashMap representatives = new HashMap(nodes.size() * 2);
        this.traverseTopological(template, new TopoVisitor(){

            @Override
            public void visit(Node node) {
                Object ni = UndirectedGraphTransformation.this.factory.createVertex(node, false);
                Object v = UndirectedGraphTransformation.this.factory.createVertex(node, true);
                Object no = UndirectedGraphTransformation.this.factory.createVertex(node, false);
                vertices.add(ni);
                vertices.add(v);
                vertices.add(no);
                representatives.put(node.getID(), new Object[]{ni, v, no});
            }
        });
        DefaultUndirectedGraph<E, E> graph = new DefaultUndirectedGraph<E, E>(vertices);
        for (Object[] rep : representatives.values()) {
            Iterator ni = rep[0];
            Object v = rep[1];
            Object no = rep[2];
            graph.addEdge(ni, v, this.factory.createEdge(ni, v, null));
            graph.addEdge(v, no, this.factory.createEdge(v, no, null));
        }
        Set edgeStructure = template.getEdgeStructure(new ProcessConstants.EdgeType[]{ProcessConstants.EdgeType.ET_CONTROL, ProcessConstants.EdgeType.ET_LOOP, ProcessConstants.EdgeType.ET_SYNC});
        for (StructuredEdge edge : edgeStructure) {
            int sourceNodeID = edge.getSourceNodeID();
            int destinationNodeID = edge.getDestinationNodeID();
            Object[] sourceRep = (Object[])representatives.get(sourceNodeID);
            Object[] destRep = (Object[])representatives.get(destinationNodeID);
            Object source = sourceRep[2];
            Object dest = destRep[0];
            graph.addEdge(source, dest, this.factory.createEdge(source, dest, null));
        }
        Set constraints = template.getConstraintEdgeStructure();
        for (StructuredConstraintEdge edge : constraints) {
            int sourceNodeID = edge.getSourceNodeID();
            int destinationNodeID = edge.getDestinationNodeID();
            Object[] sourceRep = (Object[])representatives.get(sourceNodeID);
            Object[] destRep = (Object[])representatives.get(destinationNodeID);
            Object source = sourceRep[2];
            Object dest = destRep[0];
            graph.addEdge(source, dest, this.factory.createEdge(source, dest, edge));
        }
        int startNodeID = template.getStartNode().getID();
        int endNodeID = template.getEndNode().getID();
        Object[] sourceRep = (Object[])representatives.get(startNodeID);
        Object[] destRep = (Object[])representatives.get(endNodeID);
        Object source = sourceRep[2];
        Object dest = destRep[0];
        graph.addEdge(source, dest, this.factory.createEdge(source, dest, null));
        source = sourceRep[0];
        dest = destRep[2];
        graph.addEdge(source, dest, this.factory.createEdge(source, dest, null));
        Object[] source2 = (Object[])representatives.get(template.getStartNode().getID());
        this.sourceNode = source2[0];
        Object[] end = (Object[])representatives.get(template.getEndNode().getID());
        this.sinkNode = end[2];
        return graph;
    }

    public void traverseTopological(Template template, TopoVisitor visitor) {
        LinkedList<Integer> queue = new LinkedList<Integer>();
        queue.offer(template.getStartNode().getID());
        HashSet<Integer> processed = new HashSet<Integer>();
        while (!queue.isEmpty()) {
            int node = (Integer)queue.poll();
            int[] pred = template.getPredByEdgeType(node, new ProcessConstants.EdgeType[]{ProcessConstants.EdgeType.ET_CONTROL, ProcessConstants.EdgeType.ET_SYNC});
            boolean complete = true;
            int[] nArray = pred;
            int n = pred.length;
            int n2 = 0;
            while (n2 < n) {
                int p = nArray[n2];
                if (!processed.contains(p)) {
                    complete = false;
                    break;
                }
                ++n2;
            }
            if (complete) {
                int[] succs;
                visitor.visit(template.getNode(node));
                processed.add(node);
                int[] nArray2 = succs = template.getSuccByEdgeType(node, new ProcessConstants.EdgeType[]{ProcessConstants.EdgeType.ET_CONTROL, ProcessConstants.EdgeType.ET_SYNC});
                int n3 = succs.length;
                n = 0;
                while (n < n3) {
                    int s = nArray2[n];
                    if (!queue.contains(s)) {
                        queue.offer(s);
                    }
                    ++n;
                }
                continue;
            }
            queue.offer(node);
        }
    }

    public Map<Node, SESERegion> transform(Map<NodeStruct, RegionStruct> regionMapping) {
        HashMap<Node, SESERegion> result = new HashMap<Node, SESERegion>();
        for (Map.Entry<NodeStruct, RegionStruct> entry : regionMapping.entrySet()) {
            if (!entry.getKey().representative) continue;
            RegionStruct regionStruct = entry.getValue();
            EdgeStruct entryEdge = regionStruct.entry;
            EdgeStruct exitEdge = regionStruct.exit;
            Node startNode = (Node)entryEdge.n2.node;
            Node endNode = (Node)exitEdge.n1.node;
            SESERegion region = new SESERegion(startNode, endNode);
            result.put((Node)entry.getKey().node, region);
        }
        return result;
    }

    public SESERegion transform(RegionStruct regionStruct) {
        EdgeStruct entryEdge = regionStruct.entry;
        EdgeStruct exitEdge = regionStruct.exit;
        Node startNode = null;
        Node endNode = null;
        if (entryEdge != null) {
            startNode = (Node)entryEdge.n2.node;
        }
        if (exitEdge != null) {
            endNode = (Node)exitEdge.n1.node;
        }
        SESERegion region = new SESERegion(startNode, endNode);
        boolean hasNodes = false;
        for (NodeStruct node : regionStruct.nodes) {
            if (!node.representative) continue;
            region.addNode((Node)node.node);
            hasNodes = true;
        }
        for (RegionStruct child : regionStruct.children) {
            SESERegion subRegion = this.transform(child);
            if (subRegion == null) continue;
            region.addChildRegion(subRegion);
            hasNodes = true;
        }
        if (!hasNodes) {
            return null;
        }
        return region;
    }

    public static interface TopoVisitor {
        public void visit(Node var1);
    }

    public static interface UndirectedGraphFactory<V, E> {
        public V createVertex(Object var1, boolean var2);

        public E createEdge(V var1, V var2, Object var3);

        public UndirectedGraph<V, E> createGraph(List<V> var1);
    }
}

