/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.processmodel.defaultimplementation;

import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.globals.TimeModelConstants;
import de.aristaflow.adept2.model.processmodel.AbstractWrappingTemplate;
import de.aristaflow.adept2.model.processmodel.ConstraintEdge;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemporalNode;
import de.aristaflow.adept2.model.processmodel.TemporalTemplate;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultTemporalNode;
import de.aristaflow.adept2.model.processmodel.timemodel.FixedDate;
import de.aristaflow.adept2.model.processmodel.timemodel.ProcessDuration;
import de.aristaflow.adept2.model.processmodel.timemodel.ScheduleRestrictedElement;
import de.aristaflow.adept2.model.processmodel.timemodel.TimeLag;
import de.aristaflow.adept2.model.processmodel.timemodel.TimeModelTools;
import de.aristaflow.adept2.model.processmodel.timemodel.ValidityPeriod;
import de.aristaflow.adept2.util.NullArgumentException;
import java.util.HashSet;
import java.util.Set;

public class DefaultTemporalTemplate
extends AbstractWrappingTemplate
implements TemporalTemplate {
    private static final long serialVersionUID = -3495014167149036655L;

    public DefaultTemporalTemplate(Template template) {
        super(template);
        if (template == null) {
            throw new NullArgumentException();
        }
    }

    public Template getBaseTemplate() {
        return this.template;
    }

    @Override
    public ProcessDuration getProcessDuration() {
        return TimeModelTools.getProcessDuration(this.getBaseTemplate());
    }

    @Override
    public ValidityPeriod getStartValidityPeriod() {
        return TimeModelTools.getStartValidityPeriod(this.getBaseTemplate());
    }

    @Override
    public ValidityPeriod getCompletionValidityPeriod() {
        return TimeModelTools.getCompletionValidityPeriod(this.getBaseTemplate());
    }

    @Override
    public FixedDate getStartFixedDate() {
        return TimeModelTools.getStartFixedDate(this.getBaseTemplate());
    }

    @Override
    public FixedDate getCompletionFixedDate() {
        return TimeModelTools.getCompletionFixedDate(this.getBaseTemplate());
    }

    @Override
    public ScheduleRestrictedElement getStartScheduleRestrictedElement() {
        return TimeModelTools.getStartSchedule(this.getBaseTemplate());
    }

    @Override
    public ScheduleRestrictedElement getCompletionScheduleRestrictedElement() {
        return TimeModelTools.getCompletionSchedule(this.getBaseTemplate());
    }

    @Override
    public TimeLag getTimeLagConstraint(int srcNodeID, int destNodeID, TimeModelConstants.RelationType relationType) {
        ConstraintEdge constraintEdge = this.getConstraintEdge(srcNodeID, destNodeID);
        if (constraintEdge != null) {
            return TimeModelTools.getTimeLag(constraintEdge, relationType);
        }
        if (TimeModelConstants.RelationType.END_START.equals((Object)relationType) && (this.getEdge(srcNodeID, destNodeID, ProcessConstants.EdgeType.ET_CONTROL) != null || this.getEdge(srcNodeID, destNodeID, ProcessConstants.EdgeType.ET_SYNC) != null)) {
            return null;
        }
        return null;
    }

    @Override
    public TimeLag[] getTimeLagsConstraint(int srcNodeID, int destNodeID) {
        ConstraintEdge constraintEdge = this.getConstraintEdge(srcNodeID, destNodeID);
        return TimeModelTools.getTimeLags(constraintEdge);
    }

    @Override
    public TemporalNode getNode(int nodeID) {
        Node node = super.getNode(nodeID);
        if (node != null) {
            return new DefaultTemporalNode(node);
        }
        return null;
    }

    public String toString() {
        return this.getBaseTemplate().getName();
    }

    @Override
    public Set<TemporalNode> getTemporalNodes() {
        Set nodes = super.getNodes();
        HashSet<TemporalNode> temporalNodes = new HashSet<TemporalNode>();
        for (Node node : nodes) {
            temporalNodes.add(new DefaultTemporalNode(node));
        }
        return temporalNodes;
    }
}

