/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.processmodel.timemodel;

import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.timedata.TimePoint;
import de.aristaflow.adept2.model.common.viewer.ModelViewer;
import de.aristaflow.adept2.model.globals.TimeModelConstants;
import de.aristaflow.adept2.model.processmodel.ConstraintEdge;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.timemodel.ActivityDuration;
import de.aristaflow.adept2.model.processmodel.timemodel.ConstraintEdgeTemporalInformation;
import de.aristaflow.adept2.model.processmodel.timemodel.FixedDate;
import de.aristaflow.adept2.model.processmodel.timemodel.NodeTemporalInformation;
import de.aristaflow.adept2.model.processmodel.timemodel.ProcessDuration;
import de.aristaflow.adept2.model.processmodel.timemodel.ScheduleRestrictedElement;
import de.aristaflow.adept2.model.processmodel.timemodel.TemplateTemporalInformation;
import de.aristaflow.adept2.model.processmodel.timemodel.TimeLag;
import de.aristaflow.adept2.model.processmodel.timemodel.ValidityPeriod;
import java.util.HashMap;
import java.util.Map;

public class TimeModelTools {
    protected static TemplateTemporalInformation getTemplateTemporalInformation(Template template) {
        PluginData pluginData = template.getPluginData("TimeData.TemplateTemporalInformation");
        TemplateTemporalInformation info = null;
        if (pluginData != null) {
            HashMap map = new HashMap(pluginData.getPluginData());
            info = (TemplateTemporalInformation)ModelViewer.createView(map, TemplateTemporalInformation.class);
        }
        return info;
    }

    public static ProcessDuration getProcessDuration(Template template) {
        TemplateTemporalInformation info = TimeModelTools.getTemplateTemporalInformation(template);
        ProcessDuration processDuration = null;
        if (info != null) {
            processDuration = info.getProcessDuration();
        } else {
            PluginData pluginData = template.getPluginData("TimeData.ProcessDuration");
            if (pluginData != null) {
                processDuration = (ProcessDuration)ModelViewer.createView((Map)pluginData.getPluginData(), ProcessDuration.class);
            }
        }
        return processDuration;
    }

    public static ActivityDuration getActivityDuration(Node node) {
        ActivityDuration activityDuration = null;
        NodeTemporalInformation nodeTemporalInformation = TimeModelTools.getNodeTemporalInformation(node);
        if (nodeTemporalInformation != null) {
            activityDuration = nodeTemporalInformation.getActivityDuration();
        } else {
            PluginData pluginData = node.getPluginData("TimeData.ActivityDuration");
            if (pluginData != null) {
                activityDuration = (ActivityDuration)ModelViewer.createView(new HashMap(pluginData.getPluginData()), ActivityDuration.class);
            }
        }
        return activityDuration;
    }

    protected static ConstraintEdgeTemporalInformation getEdgeTemporalInformation(ConstraintEdge constraintEdge) {
        PluginData pluginData = constraintEdge.getPluginData("TimeData.ConstraintEdgeTemporalInformation");
        ConstraintEdgeTemporalInformation info = null;
        if (pluginData != null) {
            HashMap map = new HashMap(pluginData.getPluginData());
            info = (ConstraintEdgeTemporalInformation)ModelViewer.createView(map, ConstraintEdgeTemporalInformation.class);
        }
        return info;
    }

    public static TimeLag[] getTimeLags(ConstraintEdge constraintEdge) {
        ConstraintEdgeTemporalInformation temporalInformation = TimeModelTools.getEdgeTemporalInformation(constraintEdge);
        TimeLag[] timeLags = new TimeLag[]{};
        if (temporalInformation != null) {
            timeLags = temporalInformation.getTimeLags();
        } else {
            PluginData pluginData = constraintEdge.getPluginData("TimeData.TimeLag");
            if (pluginData != null) {
                timeLags = new TimeLag[]{(TimeLag)ModelViewer.createView(new HashMap(pluginData.getPluginData()), TimeLag.class)};
            }
        }
        return timeLags;
    }

    public static TimeLag getTimeLag(ConstraintEdge constraintEdge, TimeModelConstants.RelationType relationType) {
        ConstraintEdgeTemporalInformation temporalInformation = TimeModelTools.getEdgeTemporalInformation(constraintEdge);
        TimeLag timeLag = null;
        if (temporalInformation != null) {
            TimeLag[] timeLags = temporalInformation.getTimeLags();
            if (timeLags != null) {
                TimeLag[] timeLagArray = timeLags;
                int n = timeLags.length;
                int n2 = 0;
                while (n2 < n) {
                    TimeLag t = timeLagArray[n2];
                    if (relationType.equals((Object)t.getRelationType())) {
                        timeLag = t;
                        break;
                    }
                    ++n2;
                }
            }
        } else {
            PluginData pluginData = constraintEdge.getPluginData("TimeData.TimeLag");
            if (pluginData != null && !(timeLag = (TimeLag)ModelViewer.createView((Map)pluginData.getPluginData(), TimeLag.class)).getRelationType().equals((Object)relationType)) {
                timeLag = null;
            }
        }
        return timeLag;
    }

    public static FixedDate getStartFixedDate(Node node) {
        FixedDate fixedDate = null;
        NodeTemporalInformation nodeTemporalInformation = TimeModelTools.getNodeTemporalInformation(node);
        if (nodeTemporalInformation != null) {
            fixedDate = nodeTemporalInformation.getStartFixedDate();
        } else {
            PluginData pluginData = node.getPluginData("TimeData.FixedDate");
            if (pluginData != null && (fixedDate = (FixedDate)ModelViewer.createView((Map)pluginData.getPluginData(), FixedDate.class)).getReferencePoint() != TimeModelConstants.ReferencePoint.START) {
                fixedDate = null;
            }
        }
        return fixedDate;
    }

    public static FixedDate getCompletionFixedDate(Node node) {
        FixedDate fixedDate = null;
        NodeTemporalInformation nodeTemporalInformation = TimeModelTools.getNodeTemporalInformation(node);
        if (nodeTemporalInformation != null) {
            fixedDate = nodeTemporalInformation.getCompletionFixedDate();
        } else {
            PluginData pluginData = node.getPluginData("TimeData.FixedDate");
            if (pluginData != null && (fixedDate = (FixedDate)ModelViewer.createView((Map)pluginData.getPluginData(), FixedDate.class)).getReferencePoint() != TimeModelConstants.ReferencePoint.COMPLETION) {
                fixedDate = null;
            }
        }
        return fixedDate;
    }

    public static ScheduleRestrictedElement getStartSchedule(Node node) {
        ScheduleRestrictedElement scheduleRestrictedElement = null;
        NodeTemporalInformation nodeTemporalInformation = TimeModelTools.getNodeTemporalInformation(node);
        if (nodeTemporalInformation != null) {
            scheduleRestrictedElement = nodeTemporalInformation.getStartSchedule();
        } else {
            PluginData pluginData = node.getPluginData("TimeData.ScheduleRestrictedElement");
            if (pluginData != null && (scheduleRestrictedElement = (ScheduleRestrictedElement)ModelViewer.createView((Map)pluginData.getPluginData(), ScheduleRestrictedElement.class)).getReferencePoint() != TimeModelConstants.ReferencePoint.START) {
                scheduleRestrictedElement = null;
            }
        }
        return scheduleRestrictedElement;
    }

    public static ScheduleRestrictedElement getCompletionSchedule(Node node) {
        ScheduleRestrictedElement scheduleRestrictedElement = null;
        NodeTemporalInformation nodeTemporalInformation = TimeModelTools.getNodeTemporalInformation(node);
        if (nodeTemporalInformation != null) {
            scheduleRestrictedElement = nodeTemporalInformation.getCompletionSchedule();
        } else {
            PluginData pluginData = node.getPluginData("TimeData.ScheduleRestrictedElement");
            if (pluginData != null && (scheduleRestrictedElement = (ScheduleRestrictedElement)ModelViewer.createView((Map)pluginData.getPluginData(), ScheduleRestrictedElement.class)).getReferencePoint() != TimeModelConstants.ReferencePoint.COMPLETION) {
                scheduleRestrictedElement = null;
            }
        }
        return scheduleRestrictedElement;
    }

    public static ValidityPeriod getStartValidityPeriod(Node node) {
        ValidityPeriod validityPeriod = null;
        NodeTemporalInformation nodeTemporalInformation = TimeModelTools.getNodeTemporalInformation(node);
        if (nodeTemporalInformation != null) {
            validityPeriod = nodeTemporalInformation.getStartValidityPeriod();
        } else {
            PluginData pluginData = node.getPluginData("TimeData.ValidityPeriod");
            if (pluginData != null && (validityPeriod = (ValidityPeriod)ModelViewer.createView((Map)pluginData.getPluginData(), ValidityPeriod.class)).getReferencePoint() != TimeModelConstants.ReferencePoint.START) {
                validityPeriod = null;
            }
        }
        return validityPeriod;
    }

    public static ValidityPeriod getCompletionValidityPeriod(Node node) {
        ValidityPeriod validityPeriod = null;
        NodeTemporalInformation nodeTemporalInformation = TimeModelTools.getNodeTemporalInformation(node);
        if (nodeTemporalInformation != null) {
            validityPeriod = nodeTemporalInformation.getCompletionValidityPeriod();
        } else {
            PluginData pluginData = node.getPluginData("TimeData.ValidityPeriod");
            if (pluginData != null && (validityPeriod = (ValidityPeriod)ModelViewer.createView((Map)pluginData.getPluginData(), ValidityPeriod.class)).getReferencePoint() != TimeModelConstants.ReferencePoint.COMPLETION) {
                validityPeriod = null;
            }
        }
        return validityPeriod;
    }

    protected static NodeTemporalInformation getNodeTemporalInformation(Node node) {
        PluginData pluginData = node.getPluginData("TimeData.NodeTemporalInformation");
        NodeTemporalInformation nodeTemporalInformation = null;
        if (pluginData != null) {
            HashMap map = new HashMap(pluginData.getPluginData());
            nodeTemporalInformation = (NodeTemporalInformation)ModelViewer.createView(map, NodeTemporalInformation.class);
        }
        return nodeTemporalInformation;
    }

    public static ValidityPeriod getStartValidityPeriod(Template template) {
        ValidityPeriod validityPeriod = null;
        TemplateTemporalInformation temporalInformation = TimeModelTools.getTemplateTemporalInformation(template);
        if (temporalInformation != null) {
            validityPeriod = temporalInformation.getStartValidityPeriod();
        } else {
            PluginData pluginData = template.getPluginData("TimeData.ValidityPeriod");
            if (pluginData != null && (validityPeriod = (ValidityPeriod)ModelViewer.createView((Map)pluginData.getPluginData(), ValidityPeriod.class)).getReferencePoint() != TimeModelConstants.ReferencePoint.START) {
                validityPeriod = null;
            }
        }
        return validityPeriod;
    }

    public static ValidityPeriod getCompletionValidityPeriod(Template template) {
        ValidityPeriod validityPeriod = null;
        TemplateTemporalInformation temporalInformation = TimeModelTools.getTemplateTemporalInformation(template);
        if (temporalInformation != null) {
            validityPeriod = temporalInformation.getCompletionValidityPeriod();
        } else {
            PluginData pluginData = template.getPluginData("TimeData.ValidityPeriod");
            if (pluginData != null && (validityPeriod = (ValidityPeriod)ModelViewer.createView((Map)pluginData.getPluginData(), ValidityPeriod.class)).getReferencePoint() != TimeModelConstants.ReferencePoint.COMPLETION) {
                validityPeriod = null;
            }
        }
        return validityPeriod;
    }

    public static FixedDate getStartFixedDate(Template template) {
        FixedDate fixedDate = null;
        TemplateTemporalInformation temporalInformation = TimeModelTools.getTemplateTemporalInformation(template);
        if (temporalInformation != null) {
            fixedDate = temporalInformation.getStartFixedDate();
        } else {
            PluginData pluginData = template.getPluginData("TimeData.FixedDate");
            if (pluginData != null && (fixedDate = (FixedDate)ModelViewer.createView((Map)pluginData.getPluginData(), FixedDate.class)).getReferencePoint() != TimeModelConstants.ReferencePoint.START) {
                fixedDate = null;
            }
        }
        return fixedDate;
    }

    public static FixedDate getCompletionFixedDate(Template template) {
        FixedDate fixedDate = null;
        TemplateTemporalInformation temporalInformation = TimeModelTools.getTemplateTemporalInformation(template);
        if (temporalInformation != null) {
            fixedDate = temporalInformation.getCompletionFixedDate();
        } else {
            PluginData pluginData = template.getPluginData("TimeData.FixedDate");
            if (pluginData != null && (fixedDate = (FixedDate)ModelViewer.createView((Map)pluginData.getPluginData(), FixedDate.class)).getReferencePoint() != TimeModelConstants.ReferencePoint.COMPLETION) {
                fixedDate = null;
            }
        }
        return fixedDate;
    }

    public static ScheduleRestrictedElement getStartSchedule(Template template) {
        ScheduleRestrictedElement scheduleRestrictedElement = null;
        TemplateTemporalInformation temporalInformation = TimeModelTools.getTemplateTemporalInformation(template);
        if (temporalInformation != null) {
            scheduleRestrictedElement = temporalInformation.getStartScheduleRestrictedElement();
        } else {
            PluginData pluginData = template.getPluginData("TimeData.ScheduleRestrictedElement");
            if (pluginData != null && (scheduleRestrictedElement = (ScheduleRestrictedElement)ModelViewer.createView((Map)pluginData.getPluginData(), ScheduleRestrictedElement.class)).getReferencePoint() != TimeModelConstants.ReferencePoint.START) {
                scheduleRestrictedElement = null;
            }
        }
        return scheduleRestrictedElement;
    }

    public static ScheduleRestrictedElement getCompletionSchedule(Template template) {
        ScheduleRestrictedElement scheduleRestrictedElement = null;
        TemplateTemporalInformation temporalInformation = TimeModelTools.getTemplateTemporalInformation(template);
        if (temporalInformation != null) {
            scheduleRestrictedElement = temporalInformation.getCompletionScheduleRestrictedElement();
        } else {
            PluginData pluginData = template.getPluginData("TimeData.ScheduleRestrictedElement");
            if (pluginData != null && (scheduleRestrictedElement = (ScheduleRestrictedElement)ModelViewer.createView((Map)pluginData.getPluginData(), ScheduleRestrictedElement.class)).getReferencePoint() != TimeModelConstants.ReferencePoint.COMPLETION) {
                scheduleRestrictedElement = null;
            }
        }
        return scheduleRestrictedElement;
    }

    public static String toString(ActivityDuration activityDuration) {
        String flexibleMin = null;
        String guardMin = null;
        String guardMax = null;
        String flexibleMax = null;
        TimePoint duration = activityDuration.getMinimumDuration();
        flexibleMin = duration != null ? TimeModelTools.convertToString(duration) : "1s";
        duration = activityDuration.getGuardMinimumDuration();
        if (duration != null) {
            guardMin = TimeModelTools.convertToString(duration);
        }
        if ((duration = activityDuration.getGuardMaximumDuration()) != null) {
            guardMax = TimeModelTools.convertToString(duration);
        }
        if ((duration = activityDuration.getMaximumDuration()) != null) {
            flexibleMax = TimeModelTools.convertToString(duration);
        }
        StringBuilder s = new StringBuilder();
        s.append("[[");
        s.append(flexibleMin);
        s.append(", ");
        if (guardMin != null) {
            s.append(guardMin);
        } else {
            s.append(flexibleMax);
        }
        s.append("] [");
        if (guardMax != null) {
            s.append(guardMax);
        } else {
            s.append(flexibleMin);
        }
        s.append(", ");
        s.append(flexibleMax);
        s.append("]");
        return s.toString();
    }

    public static String toString(TimeLag timeLag) {
        String lowerMin = null;
        String upperMin = null;
        String lowerMax = null;
        String upperMax = null;
        TimePoint timeDist = timeLag.getLowerMinimumTimeLag();
        if (timeDist != null) {
            lowerMin = TimeModelTools.convertToString(timeDist);
        }
        if ((timeDist = timeLag.getUpperMinimumTimeLag()) != null) {
            upperMin = TimeModelTools.convertToString(timeDist);
        }
        if ((timeDist = timeLag.getLowerMaximumTimeLag()) != null) {
            lowerMax = TimeModelTools.convertToString(timeDist);
        }
        if ((timeDist = timeLag.getUpperMaximumTimeLag()) != null) {
            upperMax = TimeModelTools.convertToString(timeDist);
        }
        StringBuilder s = new StringBuilder();
        s.append("[");
        if (lowerMin != null) {
            s.append(lowerMin);
        } else if (upperMax != null) {
            s.append("-Inf");
        }
        if (upperMin != null || lowerMax != null) {
            s.append(" [");
            if (upperMin != null) {
                s.append(upperMin);
            }
            if (upperMin != null || lowerMax != null) {
                s.append(", ");
            }
            if (lowerMax != null) {
                s.append(lowerMax);
            }
            s.append("] ");
        } else {
            s.append(", ");
        }
        if (upperMax != null) {
            s.append(upperMax);
        } else if (lowerMin != null) {
            s.append("Inf");
        }
        s.append("]");
        return s.toString();
    }

    public static String convertToString(TimePoint timeLag) {
        StringBuilder s = new StringBuilder();
        if (timeLag.getMonths() != Long.MIN_VALUE) {
            s.append(timeLag.getMonths());
            s.append("M");
        }
        if (timeLag.getDays() != Long.MIN_VALUE) {
            s.append(timeLag.getDays());
            s.append("d");
        }
        if (timeLag.getHours() != Long.MIN_VALUE) {
            s.append(timeLag.getHours());
            s.append("h");
        }
        if (timeLag.getMinutes() != Long.MIN_VALUE) {
            s.append(timeLag.getMinutes());
            s.append("m");
        }
        if (timeLag.getSeconds() != Long.MIN_VALUE) {
            s.append(timeLag.getSeconds());
            s.append("s");
        }
        return s.toString();
    }

    public static String toString(FixedDate fixedDate) {
        String description = fixedDate.getFixedDateUpdateProcedure().getDescription();
        if (description != null) {
            return description;
        }
        return "Fixed Date";
    }

    public static String toString(ScheduleRestrictedElement schedule) {
        return schedule.getSchedule();
    }
}

