/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.processmodel.timemodel.defaultimplementation;

import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.datamanager.DataManager;
import de.aristaflow.adept2.core.datamanager.ProcessAwareAccess;
import de.aristaflow.adept2.core.executionmanager.ExecutionManager;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.ParameterRefResolver;
import de.aristaflow.adept2.model.common.plugindata.LongDateSystemDataFormatter;
import de.aristaflow.adept2.model.common.timedata.CalendarElement;
import de.aristaflow.adept2.model.datamanagement.InputDataContainer;
import de.aristaflow.adept2.model.eventmodel.EventDescription;
import de.aristaflow.adept2.model.globals.TimeModelConstants;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.timemodel.FixedDate;
import de.aristaflow.adept2.model.processmodel.timemodel.FixedDateUpdateMeasures;
import de.aristaflow.adept2.model.timemodel.Interval;
import de.aristaflow.adept2.model.timemodel.UpdateableInstanceTimeModel;
import java.net.URI;

public class DefaultFixedDateUpdateMeasures
implements FixedDateUpdateMeasures {
    private Registry registry;
    private Instance instance;
    private ExecutionManager executionManager;
    private UpdateableInstanceTimeModel timeModel;
    private FixedDate fixedDate;
    private TimeModelConstants.ReferencePoint referencePoint;
    private int targetNodeID;
    private int nodeIteration;

    public DefaultFixedDateUpdateMeasures(Registry registry, ExecutionManager executionManager, Instance instance, UpdateableInstanceTimeModel timeModel, int targetNodeID, int nodeIteration, FixedDate fixedDate, TimeModelConstants.ReferencePoint referencePoint) {
        this.registry = registry;
        this.executionManager = executionManager;
        this.instance = instance;
        this.timeModel = timeModel;
        this.targetNodeID = targetNodeID;
        this.nodeIteration = nodeIteration;
        this.fixedDate = fixedDate;
        this.referencePoint = referencePoint;
    }

    @Override
    public boolean updateEarliestDate(SessionToken session, int nodeID, int iteration, CalendarElement date, boolean ignoreInconsistency) {
        switch (this.referencePoint) {
            case START: {
                Interval<CalendarElement> startTimeframe = this.timeModel.getActivityInstanceStartTimeframe(nodeID, iteration);
                if (this.compare(startTimeframe.getMaxValue(), date) > 0 || ignoreInconsistency) {
                    this.timeModel.setEarliestStartDate(session, nodeID, iteration, date);
                    return true;
                }
                return false;
            }
            case COMPLETION: {
                Interval<CalendarElement> completionTimeframe = this.timeModel.getActivityInstanceCompletionTimeframe(nodeID, iteration);
                if (this.compare(completionTimeframe.getMaxValue(), date) > 0 || ignoreInconsistency) {
                    this.timeModel.setEarliestCompletionDate(session, nodeID, iteration, date);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean updateLatestDate(SessionToken session, int nodeID, int iteration, CalendarElement date, boolean ignoreInconsistency) {
        switch (this.referencePoint) {
            case START: {
                Interval<CalendarElement> startTimeframe = this.timeModel.getActivityInstanceStartTimeframe(nodeID, iteration);
                if (this.compare(startTimeframe.getMinValue(), date) < 0 || ignoreInconsistency) {
                    this.timeModel.setLatestStartDate(session, nodeID, iteration, date);
                    return true;
                }
                return false;
            }
            case COMPLETION: {
                Interval<CalendarElement> completionTimeframe = this.timeModel.getActivityInstanceCompletionTimeframe(nodeID, iteration);
                if (this.compare(completionTimeframe.getMinValue(), date) < 0 || ignoreInconsistency) {
                    this.timeModel.setLatestCompletionDate(session, nodeID, iteration, date);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private int compare(CalendarElement minValue, CalendarElement date) {
        long diff = date.getTimeInMillis() - minValue.getTimeInMillis();
        return diff == 0L ? 0 : (diff > 0L ? 1 : -1);
    }

    @Override
    public void addUpdateTrigger(SessionToken session, EventDescription activity, EventDescription trigger) {
    }

    @Override
    public void removeUpdateTrigger(SessionToken session, EventDescription activity, EventDescription trigger) {
    }

    @Override
    public void clearUpdateTriggerList(SessionToken session, EventDescription activity) {
    }

    @Override
    public String resolveParameterString(SessionToken session, int nodeID, String param) {
        try {
            URI[] dataManagerURI = this.executionManager.getDataManager(session, this.instance.getID());
            DataManager dataManager = (DataManager)this.registry.getService(session, dataManagerURI, DataManager.class);
            ProcessAwareAccess paa = dataManager.getProcessAwareAccess();
            InputDataContainer nodeDataContainer = paa.getNodeDataContainer(session, this.instance, nodeID);
            String string = ParameterRefResolver.getFormattedReplacedString((SessionToken)session, (InputDataContainer)nodeDataContainer, LongDateSystemDataFormatter.class, (String)param);
            return string;
        }
        catch (ServiceNotKnownException e) {
            e.printStackTrace();
            return null;
        }
    }
}

