/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.processmodel.timemodel.schedules.evaluation;

import de.aristaflow.adept2.model.processmodel.timemodel.schedules.evaluation.IntervalSet;
import de.aristaflow.adept2.model.processmodel.timemodel.schedules.evaluation.TimeFrame;
import de.aristaflow.adept2.model.processmodel.timemodel.schedules.lang.expression.BasicCalendar;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ComplexIntervalSet
implements IntervalSet {
    private final List<TimeFrame> timeFrames = new ArrayList<TimeFrame>();
    private final BasicCalendar granule;
    private final int offset;

    public ComplexIntervalSet(BasicCalendar granule) {
        this.granule = granule;
        this.offset = 0;
    }

    public void add(TimeFrame interval) {
        this.timeFrames.add(interval);
    }

    @Override
    public int size() {
        return this.timeFrames.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void removeLast() {
        this.timeFrames.remove(this.timeFrames.size() - 1);
    }

    @Override
    public Iterable<TimeFrame> getTimeFrames() {
        return new Iterable<TimeFrame>(){

            @Override
            public Iterator<TimeFrame> iterator() {
                return Collections.unmodifiableList(ComplexIntervalSet.this.timeFrames).iterator();
            }
        };
    }

    @Override
    public Calendar getStart() {
        return this.timeFrames.get(0).getStart();
    }

    @Override
    public Calendar getEnd() {
        return this.timeFrames.get(this.timeFrames.size() - 1).getEnd();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("[");
        String sep = "";
        for (TimeFrame timeFrame : this.timeFrames) {
            s.append(sep);
            sep = ", ";
            s.append(timeFrame);
        }
        s.append("]@" + this.offset);
        return s.toString();
    }

    @Override
    public TimeFrame get(int index) {
        return this.timeFrames.get(index);
    }

    public TimeFrame getAbsolute(int index) {
        return this.timeFrames.get(index - this.offset);
    }

    @Override
    public BasicCalendar getGranule() {
        return this.granule;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public IntervalSet range(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (toIndex > this.timeFrames.size()) {
            throw new IndexOutOfBoundsException();
        }
        ComplexIntervalSet intervalSet = new ComplexIntervalSet(this.granule);
        int i = 0;
        while (i <= toIndex) {
            intervalSet.add(this.timeFrames.get(i));
            ++i;
        }
        return intervalSet;
    }

    @Override
    public IntervalSet range(Calendar start, Calendar end) {
        ComplexIntervalSet set = new ComplexIntervalSet(this.granule);
        for (TimeFrame tf1 : this.getTimeFrames()) {
            if (tf1.getStart().compareTo(start) < 0 || tf1.getEnd().compareTo(end) > 0) continue;
            set.add(tf1);
        }
        return set;
    }
}

