/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.processmodel.timemodel.schedules.evaluation;

import de.aristaflow.adept2.model.processmodel.timemodel.schedules.evaluation.Interval;
import de.aristaflow.adept2.model.processmodel.timemodel.schedules.evaluation.IntervalSet;
import de.aristaflow.adept2.model.processmodel.timemodel.schedules.evaluation.TimeFrame;
import de.aristaflow.adept2.model.processmodel.timemodel.schedules.lang.expression.BasicCalendar;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Iterator;

public class ContinuousIntervalSet
implements IntervalSet {
    private static final SimpleDateFormat format = new SimpleDateFormat("dd.MM.yy HH:mm:ss.S");
    private BasicCalendar baseCalender;
    private Calendar start;
    private Calendar end;
    private int size = -1;

    public ContinuousIntervalSet(BasicCalendar baseCalender, Calendar start, Calendar end) {
        this.baseCalender = baseCalender;
        this.start = start;
        this.end = end;
    }

    public ContinuousIntervalSet() {
    }

    @Override
    public Calendar getStart() {
        return this.start;
    }

    @Override
    public Calendar getEnd() {
        return this.end;
    }

    @Override
    public BasicCalendar getGranule() {
        return this.baseCalender;
    }

    @Override
    public Interval get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        Calendar from = (Calendar)this.start.clone();
        from.add(this.baseCalender.getCalendarConstant(), index);
        Calendar to = (Calendar)from.clone();
        to.add(this.baseCalender.getCalendarConstant(), 1);
        to.add(14, -1);
        if (to.after(this.end)) {
            throw new IndexOutOfBoundsException();
        }
        return new Interval(this.baseCalender, from, to);
    }

    @Override
    public ContinuousIntervalSet range(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (toIndex < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException();
        }
        Calendar from = (Calendar)this.start.clone();
        from.add(this.baseCalender.getCalendarConstant(), fromIndex);
        Calendar to = (Calendar)this.start.clone();
        to.add(this.baseCalender.getCalendarConstant(), toIndex + 1);
        to.add(14, -1);
        if (to.after(this.end)) {
            throw new IndexOutOfBoundsException();
        }
        return new ContinuousIntervalSet(this.baseCalender, from, to);
    }

    @Override
    public Iterable<TimeFrame> getTimeFrames() {
        return new Iterable<TimeFrame>(){

            @Override
            public Iterator<TimeFrame> iterator() {
                return new ContinuousIntervalSetIterator(ContinuousIntervalSet.this.start);
            }
        };
    }

    @Override
    public int size() {
        if (this.size < 0) {
            ContinuousIntervalSetIterator iter = new ContinuousIntervalSetIterator(this.start);
            int i = 0;
            while (iter.hasNext()) {
                ++i;
                iter.next();
            }
            this.size = i;
        }
        return this.size;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("[");
        s.append(format.format(this.start.getTime()));
        s.append("-");
        s.append((Object)this.baseCalender);
        s.append("-");
        s.append(format.format(this.end.getTime()));
        s.append("]");
        return s.toString();
    }

    @Override
    public IntervalSet range(Calendar from, Calendar to) {
        Calendar start = (Calendar)this.start.clone();
        while (start.compareTo(from) < 0) {
            start.add(this.baseCalender.getCalendarConstant(), 1);
        }
        Calendar end = (Calendar)start.clone();
        while (end.compareTo(to) < 0) {
            end.add(this.baseCalender.getCalendarConstant(), 1);
        }
        end.add(14, -1);
        if (end.compareTo(to) > 0) {
            end.add(this.baseCalender.getCalendarConstant(), -1);
        }
        return new ContinuousIntervalSet(this.baseCalender, start, end);
    }

    private final class ContinuousIntervalSetIterator
    implements Iterator<TimeFrame> {
        private Calendar current;

        public ContinuousIntervalSetIterator(Calendar start) {
            this.current = (Calendar)start.clone();
        }

        @Override
        public boolean hasNext() {
            return this.current.before(ContinuousIntervalSet.this.end);
        }

        @Override
        public TimeFrame next() {
            Calendar start = (Calendar)this.current.clone();
            this.current.add(ContinuousIntervalSet.this.baseCalender.getCalendarConstant(), 1);
            Calendar end = (Calendar)this.current.clone();
            end.add(14, -1);
            return new Interval(ContinuousIntervalSet.this.baseCalender, start, end);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

