/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.processmodel.timemodel.schedules.evaluation;

import de.aristaflow.adept2.model.processmodel.timemodel.schedules.evaluation.CalendarCache;
import de.aristaflow.adept2.model.processmodel.timemodel.schedules.evaluation.ComplexIntervalSet;
import de.aristaflow.adept2.model.processmodel.timemodel.schedules.evaluation.ContinuousIntervalSet;
import de.aristaflow.adept2.model.processmodel.timemodel.schedules.evaluation.Interval;
import de.aristaflow.adept2.model.processmodel.timemodel.schedules.evaluation.IntervalSet;
import de.aristaflow.adept2.model.processmodel.timemodel.schedules.evaluation.TimeFrame;
import de.aristaflow.adept2.model.processmodel.timemodel.schedules.lang.expression.BasicCalendar;
import de.aristaflow.adept2.model.processmodel.timemodel.schedules.lang.expression.BasicCalendarExpression;
import de.aristaflow.adept2.model.processmodel.timemodel.schedules.lang.expression.CalendarExpression;
import de.aristaflow.adept2.model.processmodel.timemodel.schedules.lang.expression.Dicing;
import de.aristaflow.adept2.model.processmodel.timemodel.schedules.lang.expression.Ident;
import de.aristaflow.adept2.model.processmodel.timemodel.schedules.lang.expression.IntervalSelection;
import de.aristaflow.adept2.model.processmodel.timemodel.schedules.lang.expression.MultiSelection;
import de.aristaflow.adept2.model.processmodel.timemodel.schedules.lang.expression.SetSelection;
import de.aristaflow.adept2.model.processmodel.timemodel.schedules.lang.expression.SingleSelection;
import de.aristaflow.adept2.model.processmodel.timemodel.schedules.lang.expression.Slicing;
import de.aristaflow.adept2.model.processmodel.timemodel.schedules.lang.expression.Union;
import de.aristaflow.adept2.model.processmodel.timemodel.schedules.lang.script.AssignementStmt;
import de.aristaflow.adept2.model.processmodel.timemodel.schedules.lang.script.CalendarScript;
import de.aristaflow.adept2.model.processmodel.timemodel.schedules.lang.script.CalendarStatement;
import de.aristaflow.adept2.model.processmodel.timemodel.schedules.lang.script.ReturnExpression;
import de.aristaflow.adept2.model.processmodel.timemodel.schedules.lang.script.ReturnStmt;
import de.aristaflow.adept2.model.processmodel.timemodel.schedules.lang.script.ReturnString;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Evaluator {
    public static final SimpleDateFormat format = new SimpleDateFormat("dd.MM.yy hh:mm:ss.S");
    private Map<Ident, CalendarCache> variabes = new HashMap<Ident, CalendarCache>();

    public Evaluator(Map<String, CalendarExpression> knownCalendars) {
        if (knownCalendars != null) {
            for (Map.Entry<String, CalendarExpression> cal : knownCalendars.entrySet()) {
                this.registerIdent(new Ident(cal.getKey()), cal.getValue());
            }
        }
    }

    public IntervalSet evaluate(CalendarScript script, Calendar from, Calendar until, boolean inclusive) {
        for (CalendarStatement stmt : script.getStmtList()) {
            if (stmt instanceof ReturnStmt) {
                return this.evaluateReturnStmt((ReturnStmt)stmt, from, until, inclusive);
            }
            IntervalSet set = this.evaluate(stmt, from, until, inclusive);
            if (set == null) continue;
            return set;
        }
        return null;
    }

    public void registerIdent(Ident ident, CalendarExpression expression) {
        this.variabes.put(ident, new CalendarCache(expression));
    }

    public void unregisterIdent(Ident ident) {
        this.variabes.remove(ident);
    }

    protected IntervalSet evaluate(CalendarStatement stmt, Calendar from, Calendar until, boolean inclusive) {
        if (stmt instanceof AssignementStmt) {
            this.evaluateAssignment((AssignementStmt)stmt, from, until, inclusive);
            return null;
        }
        if (stmt instanceof ReturnStmt) {
            return this.evaluateReturnStmt((ReturnStmt)stmt, from, until, inclusive);
        }
        throw new IllegalArgumentException(String.valueOf(stmt.getClass().getSimpleName()) + " not supported!");
    }

    protected IntervalSet evaluateReturnStmt(ReturnStmt stmt, Calendar from, Calendar until, boolean inclusive) {
        if (stmt instanceof ReturnString) {
            System.out.println(((ReturnString)stmt).getIdentString());
            return new ContinuousIntervalSet();
        }
        if (stmt instanceof ReturnExpression) {
            ReturnExpression expression = (ReturnExpression)stmt;
            CalendarExpression exp = expression.getCalendarExpression();
            return this.evaluate(exp, from, until, inclusive);
        }
        throw new IllegalArgumentException(String.valueOf(stmt.getClass().getSimpleName()) + "not supported!");
    }

    protected void evaluateAssignment(AssignementStmt stmt, Calendar from, Calendar until, boolean inclusive) {
        CalendarExpression expression = stmt.getCalendarExpression();
        Ident ident = stmt.getIdent();
        this.registerIdent(ident, expression);
    }

    public TimeFrame nextInterval(CalendarExpression expression, Calendar from, boolean inclusive) {
        Calendar start = from;
        while (true) {
            IntervalSet intervalSet = this.evaluate(expression, start, start, true);
            for (TimeFrame tf : intervalSet.getTimeFrames()) {
                if (!(inclusive ? tf.getEnd().compareTo(from) >= 0 : tf.getStart().compareTo(from) >= 0 && tf.getEnd().compareTo(from) >= 0)) continue;
                return tf;
            }
            start = (Calendar)intervalSet.getEnd().clone();
            start.add(intervalSet.getGranule().getCalendarConstant(), 1);
        }
    }

    public IntervalSet evaluate(CalendarExpression expression, Calendar from, Calendar until, boolean inclusive) {
        Ident ident = new Ident(expression.toString());
        CalendarCache cache = this.variabes.get(ident);
        if (cache == null) {
            cache = new CalendarCache(expression);
            this.variabes.put(ident, cache);
        }
        return cache.evaluate(this, from, until, inclusive);
    }

    public TimeFrame flatten(TimeFrame intervalSet) {
        if (intervalSet instanceof Interval) {
            return intervalSet;
        }
        if (intervalSet instanceof ContinuousIntervalSet) {
            return intervalSet;
        }
        if (intervalSet instanceof ComplexIntervalSet) {
            IntervalSet set = (IntervalSet)intervalSet;
            ComplexIntervalSet result = new ComplexIntervalSet(set.getGranule());
            TimeFrame last = null;
            for (TimeFrame tf : set.getTimeFrames()) {
                TimeFrame flatten = this.flatten(tf);
                if (flatten instanceof ComplexIntervalSet) {
                    if (last != null) {
                        this.add(result, last);
                        last = null;
                    }
                    this.add(result, flatten);
                    continue;
                }
                if (last == null) {
                    last = flatten;
                    continue;
                }
                Calendar clone = (Calendar)last.getEnd().clone();
                clone.add(14, 1);
                if (clone.compareTo(flatten.getStart()) == 0) {
                    last = new ContinuousIntervalSet(last.getGranule(), last.getStart(), flatten.getEnd());
                    continue;
                }
                this.add(result, last);
                last = flatten;
            }
            if (last != null) {
                this.add(result, last);
            }
            return result;
        }
        return intervalSet;
    }

    protected IntervalSet evaluteNoCache(CalendarExpression expression, Calendar from, Calendar until, boolean inclusive) {
        if (expression instanceof Dicing) {
            return this.evaluateDicing((Dicing)expression, from, until, inclusive);
        }
        if (expression instanceof BasicCalendarExpression) {
            return this.evaluateBasicCalendar((BasicCalendarExpression)expression, from, until, inclusive);
        }
        if (expression instanceof Ident) {
            return this.evaluateIdent((Ident)expression, from, until, inclusive);
        }
        if (expression instanceof Slicing) {
            return this.evaluateSlicing((Slicing)expression, from, until, inclusive);
        }
        if (expression instanceof Union) {
            return this.evaluateUnion(expression, from, until, inclusive);
        }
        throw new IllegalArgumentException("Unkown expression type " + expression);
    }

    private IntervalSet evaluateUnion(CalendarExpression expression, Calendar from, Calendar until, boolean inclusive) {
        Union union = (Union)expression;
        IntervalSet part1 = this.evaluate(union.getFirst(), from, until, inclusive);
        IntervalSet part2 = this.evaluate(union.getSecond(), from, until, inclusive);
        if (part1.getGranule() != part2.getGranule()) {
            throw new IllegalArgumentException((Object)((Object)part1.getGranule()) + "!=" + (Object)((Object)part2.getGranule()));
        }
        ComplexIntervalSet result = new ComplexIntervalSet(part1.getGranule());
        int i = 0;
        int j = 0;
        while (i < part1.size() && j < part2.size()) {
            TimeFrame t1 = part1.get(i);
            TimeFrame t2 = part2.get(j);
            if (t1.getEnd().before(t2.getStart())) {
                this.add(result, t1);
                ++i;
                continue;
            }
            if (t2.getEnd().before(t1.getStart())) {
                this.add(result, t2);
                ++j;
                continue;
            }
            if (!(t1 instanceof Interval) && !(t1 instanceof ContinuousIntervalSet) || !(t2 instanceof Interval) && !(t2 instanceof ContinuousIntervalSet)) {
                if (t1 instanceof ComplexIntervalSet) {
                    throw new UnsupportedOperationException("Not yet implemented");
                }
                if (t2 instanceof ComplexIntervalSet) {
                    throw new UnsupportedOperationException("Not yet implemented");
                }
                throw new IllegalStateException("Illegal combination of intervals detected.");
            }
            Calendar start = t1.getStart().compareTo(t2.getStart()) <= 0 ? t1.getStart() : t2.getStart();
            Calendar end = t1.getEnd().compareTo(t2.getEnd()) >= 0 ? t1.getEnd() : t2.getEnd();
            result.add(new ContinuousIntervalSet(t1.getGranule(), start, end));
            ++i;
            ++j;
        }
        while (i < part1.size()) {
            this.add(result, part1.get(i));
            ++i;
        }
        while (j < part2.size()) {
            this.add(result, part2.get(j));
            ++j;
        }
        return result;
    }

    private void add(ComplexIntervalSet s, TimeFrame t1) {
        if (t1 instanceof ComplexIntervalSet) {
            this.addAll(s, (IntervalSet)t1);
        } else {
            s.add(t1);
        }
    }

    protected IntervalSet evaluateSlicing(Slicing expression, Calendar from, Calendar until, boolean inclusive) {
        IntervalSet result = this.evaluate(expression.getCalendarExpression(), from, until, inclusive);
        result = this.performSlicing(expression, result);
        return result;
    }

    protected IntervalSet evaluateIdent(Ident ident, Calendar from, Calendar until, boolean inclusive) {
        CalendarCache calendarCache = this.variabes.get(ident);
        if (calendarCache == null) {
            throw new IllegalArgumentException("Unkown variable '" + ident.getId() + "'");
        }
        return calendarCache.evaluate(this, from, until, inclusive);
    }

    protected IntervalSet evaluateDicing(Dicing expression, Calendar from, Calendar until, boolean inclusive) {
        IntervalSet secondSet = this.evaluate(expression.getSecondOperand(), from, until, inclusive);
        IntervalSet result = null;
        switch (expression.getSetOperator()) {
            case contains: {
                throw new UnsupportedOperationException("Operation " + (Object)((Object)expression.getSetOperator()) + " not supported");
            }
            case during: {
                IntervalSet firstSet = this.evaluate(expression.getFirstOperand(), secondSet.getStart(), secondSet.getEnd(), true);
                result = this.evaluateDuring(firstSet, secondSet);
                break;
            }
            case lessThan: {
                throw new UnsupportedOperationException("Operation " + (Object)((Object)expression.getSetOperator()) + " not supported");
            }
            case lessThanEqual: {
                throw new UnsupportedOperationException("Operation " + (Object)((Object)expression.getSetOperator()) + " not supported");
            }
            case meets: {
                throw new UnsupportedOperationException("Operation " + (Object)((Object)expression.getSetOperator()) + " not supported");
            }
            case moreThan: {
                throw new UnsupportedOperationException("Operation " + (Object)((Object)expression.getSetOperator()) + " not supported");
            }
            case moreThanEqual: {
                throw new UnsupportedOperationException("Operation " + (Object)((Object)expression.getSetOperator()) + " not supported");
            }
            case overlaps: {
                IntervalSet firstSet = this.evaluate(expression.getFirstOperand(), secondSet.getStart(), secondSet.getEnd(), true);
                result = this.evaluateOverlaps(firstSet, secondSet, expression.isStrict());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Operation " + (Object)((Object)expression.getSetOperator()) + " not supported");
            }
        }
        return result;
    }

    protected IntervalSet performSlicing(Slicing slicing, IntervalSet result) {
        if (slicing instanceof SingleSelection) {
            return this.performSingleSlicing((SingleSelection)slicing, result);
        }
        if (slicing instanceof IntervalSelection) {
            return this.performIntervalSelection((IntervalSelection)slicing, result);
        }
        if (slicing instanceof SetSelection) {
            return this.performSetSlicing((SetSelection)slicing, result);
        }
        if (slicing instanceof MultiSelection) {
            return this.performMultiSelection((MultiSelection)slicing, result);
        }
        throw new IllegalArgumentException(String.valueOf(slicing.getClass().getSimpleName()) + " not supported!");
    }

    protected IntervalSet performIntervalSelection(IntervalSelection slicing, IntervalSet set) {
        int startIndex = slicing.getStartIndext();
        int endIndex = slicing.getEndIndex();
        ComplexIntervalSet result = new ComplexIntervalSet(set.getGranule());
        for (TimeFrame frame : set.getTimeFrames()) {
            if (frame instanceof IntervalSet) {
                IntervalSet range = ((IntervalSet)frame).range(startIndex - 1, endIndex - 1);
                result.add(range);
                continue;
            }
            throw new IllegalArgumentException("Cannot apply interval selection to " + frame.getClass().getSimpleName());
        }
        return result;
    }

    protected IntervalSet performMultiSelection(MultiSelection slicing, IntervalSet result) {
        throw new UnsupportedOperationException("Unsupported Operation!");
    }

    protected IntervalSet performSetSlicing(SetSelection slicing, IntervalSet set) {
        List<Integer> selections = slicing.getSetSelection();
        ComplexIntervalSet result = new ComplexIntervalSet(set.getGranule());
        block0: for (Integer s : selections) {
            int index = s;
            for (TimeFrame frame : set.getTimeFrames()) {
                if (frame instanceof IntervalSet) {
                    TimeFrame timeFrame = index > 0 ? ((IntervalSet)frame).get(index - 1) : ((IntervalSet)frame).get(((IntervalSet)frame).size() + index);
                    result.add(timeFrame);
                    continue;
                }
                if (result.size() > 0) {
                    throw new IllegalArgumentException("Set slicing to possible for " + frame.getClass().getSimpleName() + " with size > 0");
                }
                result.add(set.get(index));
                continue block0;
            }
        }
        return result;
    }

    protected ComplexIntervalSet merge(IntervalSet set1, IntervalSet set2) {
        if (set1.size() != set2.size()) {
            throw new IllegalArgumentException("Merge not possible: set1.size() != set2.size()");
        }
        if (set1.getGranule() != set2.getGranule()) {
            throw new IllegalArgumentException((Object)((Object)set1.getGranule()) + "!=" + (Object)((Object)set2.getGranule()));
        }
        ComplexIntervalSet result = new ComplexIntervalSet(set1.getGranule());
        int i = 0;
        while (i < set1.size()) {
            ComplexIntervalSet s = new ComplexIntervalSet(set1.getGranule());
            TimeFrame t1 = set1.get(i);
            if (t1 instanceof IntervalSet) {
                this.addAll(s, (IntervalSet)t1);
            } else {
                s.add(t1);
            }
            TimeFrame t2 = set2.get(i);
            if (t2 instanceof IntervalSet) {
                this.addAll(s, (IntervalSet)t2);
            } else {
                s.add(t2);
            }
            result.add(s);
            ++i;
        }
        return result;
    }

    protected void addAll(ComplexIntervalSet s, IntervalSet intervalSet) {
        for (TimeFrame t : intervalSet.getTimeFrames()) {
            s.add(t);
        }
    }

    protected IntervalSet performSingleSlicing(SingleSelection slicing, IntervalSet set) {
        switch (slicing.getSelectionFunction()) {
            case any: {
                ComplexIntervalSet result = null;
                for (TimeFrame frame : set.getTimeFrames()) {
                    if (result == null) {
                        result = new ComplexIntervalSet(frame.getGranule());
                    }
                    if (frame instanceof IntervalSet) {
                        for (TimeFrame fr : ((IntervalSet)frame).getTimeFrames()) {
                            result.add(fr);
                        }
                        continue;
                    }
                    throw new IllegalArgumentException("Any selection not supported for " + frame.getClass().getSimpleName());
                }
                return result;
            }
            case n: {
                int index = slicing.getIntSelectionFunction();
                ComplexIntervalSet result = null;
                for (TimeFrame frame : set.getTimeFrames()) {
                    if (result == null) {
                        result = new ComplexIntervalSet(frame.getGranule());
                    }
                    if (frame instanceof IntervalSet) {
                        TimeFrame timeFrame = index > 0 ? ((IntervalSet)frame).get(index - 1) : ((IntervalSet)frame).get(((IntervalSet)frame).size() + index);
                        result.add(timeFrame);
                        continue;
                    }
                    if (result.size() > 0) {
                        throw new IllegalArgumentException("n-th selection not supported for " + frame.getClass().getSimpleName() + " with size > 0");
                    }
                    result.add(set.get(index - 1));
                    break;
                }
                return result;
            }
            case the: {
                if (set.size() == 1) {
                    TimeFrame frame = set.get(0);
                    if (frame instanceof IntervalSet) {
                        return (IntervalSet)frame;
                    }
                    ContinuousIntervalSet result = new ContinuousIntervalSet(frame.getGranule(), frame.getStart(), frame.getEnd());
                    return result;
                }
                throw new IllegalArgumentException("the selection not supported for size != 1");
            }
        }
        throw new IllegalArgumentException((Object)((Object)slicing.getSelectionFunction()) + " not supported");
    }

    protected IntervalSet evaluateDuring(IntervalSet firstSet, IntervalSet secondSet) {
        ComplexIntervalSet result = new ComplexIntervalSet(secondSet.getGranule());
        for (TimeFrame tf2 : secondSet.getTimeFrames()) {
            if (tf2 instanceof Interval) {
                Interval if2 = (Interval)tf2;
                IntervalSet set = firstSet.range(if2.getStart(), if2.getEnd());
                result.add(set);
                continue;
            }
            IntervalSet set = this.evaluateDuring(firstSet, (IntervalSet)tf2);
            this.addAll(result, set);
        }
        return result;
    }

    protected IntervalSet evaluateOverlaps(IntervalSet firstSet, IntervalSet secondSet, boolean strict) {
        ComplexIntervalSet result = new ComplexIntervalSet(secondSet.getGranule());
        for (TimeFrame tf2 : secondSet.getTimeFrames()) {
            ComplexIntervalSet set = new ComplexIntervalSet(firstSet.getGranule());
            for (TimeFrame tf1 : firstSet.getTimeFrames()) {
                if (strict && tf1.getStart().compareTo(tf2.getStart()) >= 0 && tf1.getEnd().compareTo(tf2.getEnd()) <= 0) {
                    set.add(tf1);
                    continue;
                }
                if (strict || tf1.getStart().compareTo(tf2.getEnd()) > 0 || tf1.getEnd().compareTo(tf2.getStart()) < 0) continue;
                set.add(tf1);
            }
            result.add(set);
        }
        return result;
    }

    protected IntervalSet evaluateBasicCalendar(BasicCalendarExpression expression, Calendar from, Calendar until, boolean inclusive) {
        Calendar start = (Calendar)from.clone();
        Calendar end = (Calendar)until.clone();
        start.getTimeInMillis();
        int increment = 0;
        BasicCalendar basicCalendar = expression.getBasicCalendar();
        switch (basicCalendar) {
            case YEARS: {
                start.set(6, 1);
                start.set(11, 0);
                start.set(12, 0);
                start.set(13, 0);
                start.set(14, 0);
                end.set(6, 1);
                end.set(11, 0);
                end.set(12, 0);
                end.set(13, 0);
                end.set(14, 0);
                increment = 1;
                break;
            }
            case MONTHS: {
                start.set(5, 1);
                start.set(11, 0);
                start.set(12, 0);
                start.set(13, 0);
                start.set(14, 0);
                end.set(5, 1);
                end.set(11, 0);
                end.set(12, 0);
                end.set(13, 0);
                end.set(14, 0);
                increment = 2;
                break;
            }
            case WEEKS: {
                start.set(7, start.getFirstDayOfWeek());
                start.set(11, 0);
                start.set(12, 0);
                start.set(13, 0);
                start.set(14, 0);
                end.set(7, start.getFirstDayOfWeek());
                end.set(11, 0);
                end.set(12, 0);
                end.set(13, 0);
                end.set(14, 0);
                increment = 3;
                break;
            }
            case DAYS: {
                start.set(11, 0);
                start.set(12, 0);
                start.set(13, 0);
                start.set(14, 0);
                end.set(11, 0);
                end.set(12, 0);
                end.set(13, 0);
                end.set(14, 0);
                increment = 6;
                break;
            }
            case HOURS: {
                start.set(12, 0);
                start.set(13, 0);
                start.set(14, 0);
                end.set(12, 0);
                end.set(13, 0);
                end.set(14, 0);
                increment = 11;
                break;
            }
            case MINUTES: {
                start.set(13, 0);
                start.set(14, 0);
                end.set(13, 0);
                end.set(14, 0);
                increment = 12;
                break;
            }
            case SECONDS: {
                start.set(14, 0);
                end.set(14, 0);
                increment = 13;
                break;
            }
        }
        if (!inclusive && start.compareTo(from) < 0) {
            start.add(increment, 1);
        }
        if (inclusive && end.compareTo(until) < 0) {
            end.add(increment, 1);
        }
        end.add(14, -1);
        return new ContinuousIntervalSet(basicCalendar, start, end);
    }
}

