/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.processmodel.timemodel.schedules.lang.expression;

import de.aristaflow.adept2.model.processmodel.timemodel.schedules.lang.expression.BasicCalendar;
import de.aristaflow.adept2.model.processmodel.timemodel.schedules.lang.expression.CalendarExpression;
import de.aristaflow.adept2.model.processmodel.timemodel.schedules.lang.expression.Setops;

public class Dicing
implements CalendarExpression {
    private Setops setop;
    private boolean strict;
    private CalendarExpression firstOperand;
    private CalendarExpression secondOperand;

    public Setops getSetOperator() {
        return this.setop;
    }

    public void setSetop(Setops setop) {
        this.setop = setop;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public CalendarExpression getFirstOperand() {
        return this.firstOperand;
    }

    public void setFirstOperand(CalendarExpression ident) {
        this.firstOperand = ident;
        this.validateInput();
    }

    private void validateInput() {
        if (this.firstOperand != null && this.secondOperand != null) {
            BasicCalendar granule1 = this.firstOperand.getGranule();
            BasicCalendar granule2 = this.secondOperand.getGranule();
            if (granule1 != null && granule2 != null && granule1.ordinal() >= granule2.ordinal()) {
                throw new IllegalArgumentException("Incomplatible dicing: " + this.toString());
            }
        }
    }

    public CalendarExpression getSecondOperand() {
        return this.secondOperand;
    }

    public void setSecondOperand(CalendarExpression calendarExpression) {
        this.secondOperand = calendarExpression;
        this.validateInput();
    }

    @Override
    public BasicCalendar getGranule() {
        return this.firstOperand != null ? this.firstOperand.getGranule() : null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.firstOperand);
        if (this.strict) {
            stringBuilder.append(":" + (Object)((Object)this.setop) + ":");
        } else {
            stringBuilder.append("." + (Object)((Object)this.setop) + ".");
        }
        stringBuilder.append(this.secondOperand);
        return stringBuilder.toString();
    }
}

