/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.processmodel.timemodel.updatehandlers;

import de.aristaflow.adept2.model.processmodel.timemodel.FixedDateUpdateHandler;
import de.aristaflow.adept2.model.processmodel.timemodel.TimeLagUpdateHandler;
import de.aristaflow.adept2.model.processmodel.timemodel.updatehandlers.DataElementFixedDateUpdateHandler;
import de.aristaflow.adept2.model.processmodel.timemodel.updatehandlers.DataElementTimeLagUpdateHandler;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UpdateHandlerRegistry {
    private static Logger logger = LoggerTools.getLogger(UpdateHandlerRegistry.class);
    private static Map<String, UpdateHandlerReference> fixedDateHandlers = new HashMap<String, UpdateHandlerReference>();
    private static Map<String, UpdateHandlerReference> timeLagHandlers;

    static {
        fixedDateHandlers.put("de.aristaflow.adept2.model.processmodel.timemodel.updatehandlers.DataElementFixedDateUpdateHandler", new UpdateHandlerReference("de.aristaflow.adept2.model.processmodel.timemodel.updatehandlers.DataElementFixedDateUpdateHandler", "Read from Data Element", "Reads the value of the Fixed Date from a Data Element of the Process.", DataElementFixedDateUpdateHandler.class));
        timeLagHandlers = new HashMap<String, UpdateHandlerReference>();
        timeLagHandlers.put("de.aristaflow.adept2.model.processmodel.timemodel.updatehandlers.DataElementTimeLagUpdateHandler", new UpdateHandlerReference("de.aristaflow.adept2.model.processmodel.timemodel.updatehandlers.DataElementTimeLagUpdateHandler", "Read form Data Element", "Reads the value of the Time Lag from a Data Element of the Process.", DataElementTimeLagUpdateHandler.class));
    }

    public static Collection<UpdateHandlerReference> getFixedDateUpdateHandlers() {
        return Collections.unmodifiableCollection(fixedDateHandlers.values());
    }

    public static Collection<UpdateHandlerReference> getTimeLagUpdateHandlers() {
        return Collections.unmodifiableCollection(timeLagHandlers.values());
    }

    public static FixedDateUpdateHandler getFixedDateUpdateHandler(String id) {
        UpdateHandlerReference reference = fixedDateHandlers.get(id);
        FixedDateUpdateHandler updateHandler = null;
        try {
            updateHandler = (FixedDateUpdateHandler)reference.getClazz().newInstance();
        }
        catch (InstantiationException e) {
            logger.log(Level.SEVERE, "InstantiationException occcurred", e);
        }
        catch (IllegalAccessException e) {
            logger.log(Level.SEVERE, "IllegalAccessException occcurred", e);
        }
        return updateHandler;
    }

    public TimeLagUpdateHandler getTimeLagUpdateHandler(String id) {
        UpdateHandlerReference reference = timeLagHandlers.get(id);
        TimeLagUpdateHandler updateHandler = null;
        try {
            updateHandler = (TimeLagUpdateHandler)reference.getClazz().newInstance();
        }
        catch (InstantiationException e) {
            logger.log(Level.SEVERE, "InstantiationException occcurred", e);
        }
        catch (IllegalAccessException e) {
            logger.log(Level.SEVERE, "IllegalAccessException occcurred", e);
        }
        return updateHandler;
    }

    public static class UpdateHandlerReference {
        private final String id;
        private final String name;
        private final String description;
        private final Class<?> clazz;

        public UpdateHandlerReference(String id, String name, String description, Class<?> clazz) {
            this.id = id;
            this.name = name;
            this.description = description;
            this.clazz = clazz;
        }

        public String getHandlerID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

