/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.defaultimplementation;

import de.aristaflow.adept2.model.eventmodel.EventDescription;
import de.aristaflow.adept2.model.eventmodel.EventReference;
import de.aristaflow.adept2.model.timemodel.InstanceTimeContext;
import de.aristaflow.adept2.model.timemodel.UpdateableInstanceTimeContext;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class DefaultInstanceTimeContext
implements InstanceTimeContext,
UpdateableInstanceTimeContext {
    private final UUID instanceID;
    private long instanceStarted;
    private long instanceFinished;
    private long instanceCreated;
    protected Map<Integer, ActivityInformation> activityInfo = new HashMap<Integer, ActivityInformation>();

    public DefaultInstanceTimeContext(UUID instanceID) {
        this.instanceID = instanceID;
    }

    @Override
    public UUID getInstanceID() {
        return this.instanceID;
    }

    @Override
    public long getActivityFinished(int nodeID, int iteration) {
        ActivityInstanceInformation activityInstanceInformation;
        ActivityInformation activityInfo = this.getActivityInfo(nodeID);
        if (activityInfo != null && (activityInstanceInformation = activityInfo.getActivityInstanceInformation(iteration)) != null) {
            return activityInstanceInformation.activityFinished;
        }
        return Long.MIN_VALUE;
    }

    @Override
    public long getActivityStarted(int nodeID, int iteration) {
        ActivityInstanceInformation activityInstanceInformation;
        ActivityInformation activityInfo = this.getActivityInfo(nodeID);
        if (activityInfo != null && (activityInstanceInformation = activityInfo.getActivityInstanceInformation(iteration)) != null) {
            return activityInstanceInformation.activityStarted;
        }
        return Long.MIN_VALUE;
    }

    @Override
    public long getEventOccurrence(EventDescription event) {
        return -1L;
    }

    @Override
    public EventReference[] getEventOccurrences() {
        return null;
    }

    @Override
    public void addEventOccurrence(EventReference event) {
    }

    @Override
    public long getInstanceCreated() {
        return this.instanceCreated;
    }

    @Override
    public long getInstanceFinished() {
        return this.instanceFinished;
    }

    @Override
    public long getInstanceStarted() {
        return this.instanceStarted;
    }

    @Override
    public void setActivityFinished(int nodeID, int iteration, long timestamp) {
        this.createActivityInfo((int)nodeID).createActivityInstance((int)iteration).activityFinished = timestamp;
    }

    @Override
    public void setActivityStarted(int nodeID, int iteration, long timestamp) {
        this.createActivityInfo((int)nodeID).createActivityInstance((int)iteration).activityStarted = timestamp;
    }

    protected ActivityInformation createActivityInfo(int nodeID) {
        ActivityInformation info;
        Integer nodeInteger = nodeID;
        if (this.activityInfo.containsKey(nodeInteger)) {
            info = this.activityInfo.get(nodeInteger);
        } else {
            info = new ActivityInformation();
            this.activityInfo.put(nodeInteger, info);
        }
        return info;
    }

    private ActivityInformation getActivityInfo(int nodeID) {
        ActivityInformation info = null;
        Integer nodeInteger = nodeID;
        if (this.activityInfo.containsKey(nodeInteger)) {
            info = this.activityInfo.get(nodeInteger);
        }
        return info;
    }

    @Override
    public void setInstanceCreated(long timestamp) {
        this.instanceCreated = timestamp;
    }

    @Override
    public void setInstanceFinished(long timestamp) {
        this.instanceFinished = timestamp;
    }

    @Override
    public void setInstanceStarted(long timestamp) {
        this.instanceStarted = timestamp;
    }

    public static class ActivityInformation
    implements Serializable {
        private static final long serialVersionUID = -3968100593483352153L;
        protected Map<Integer, ActivityInstanceInformation> activityInfo = new HashMap<Integer, ActivityInstanceInformation>();

        public ActivityInstanceInformation createActivityInstance(int iteration) {
            ActivityInstanceInformation info;
            Integer nodeInteger = iteration;
            if (this.activityInfo.containsKey(nodeInteger)) {
                info = this.activityInfo.get(nodeInteger);
            } else {
                info = new ActivityInstanceInformation();
                info.iteration = iteration;
                this.activityInfo.put(nodeInteger, info);
            }
            return info;
        }

        public ActivityInstanceInformation getActivityInstanceInformation(int iteration) {
            ActivityInstanceInformation info = null;
            Integer nodeInteger = iteration;
            if (this.activityInfo.containsKey(nodeInteger)) {
                info = this.activityInfo.get(nodeInteger);
            }
            return info;
        }
    }

    public static class ActivityInstanceInformation
    implements Serializable {
        private static final long serialVersionUID = -8691130061127491365L;
        public long activityStarted;
        public long activityFinished;
        public int iteration;
    }
}

