/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.defaultimplementation;

import de.aristaflow.adept2.model.common.timedata.CalendarElement;
import de.aristaflow.adept2.model.globals.TimeModelConstants;
import de.aristaflow.adept2.model.timemodel.Schedule;
import de.aristaflow.adept2.model.timemodel.ScheduleInterval;
import de.aristaflow.adept2.model.timemodel.ScheduleIntervalSet;
import java.util.List;

public class DefaultScheduleIntervalSet
implements ScheduleIntervalSet {
    private final Schedule schedule;
    private final List<ScheduleInterval> intervals;

    public DefaultScheduleIntervalSet(Schedule schedule, List<ScheduleInterval> intervals) {
        this.schedule = schedule;
        this.intervals = intervals;
    }

    @Override
    public Schedule getSchedule() {
        return this.schedule;
    }

    @Override
    public TimeModelConstants.BaseGranularity getBaseGranularity() {
        return null;
    }

    @Override
    public CalendarElement getFrom() {
        return this.intervals.get(0).getFrom();
    }

    @Override
    public CalendarElement getTo() {
        return this.intervals.get(this.intervals.size() - 1).getTo();
    }

    @Override
    public int getSize() {
        return this.intervals.size();
    }

    @Override
    public ScheduleInterval getInterval(int index) {
        return this.intervals.get(index);
    }

    @Override
    public ScheduleIntervalSet getSubSet(CalendarElement from, CalendarElement to) {
        return null;
    }

    @Override
    public boolean hasNextInterval(CalendarElement from) {
        ScheduleInterval lastInterval = this.intervals.get(this.intervals.size() - 1);
        return lastInterval.getTo().getTimeInMillis() > from.getTimeInMillis();
    }

    @Override
    public ScheduleInterval getNextInterval(CalendarElement from) {
        for (ScheduleInterval i : this.intervals) {
            if (i.getTo().getTimeInMillis() <= from.getTimeInMillis()) continue;
            return i;
        }
        return null;
    }

    @Override
    public boolean isFinest() {
        return false;
    }
}

