/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.defaultimplementation;

import de.aristaflow.adept2.model.common.timedata.CalendarElement;
import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.common.timedata.TimePoint;
import de.aristaflow.adept2.model.common.timedata.defaultimplementation.DefaultCalendarElement;
import de.aristaflow.adept2.model.common.timedata.defaultimplementation.DefaultTimeDistance;
import de.aristaflow.adept2.model.common.timedata.defaultimplementation.DefaultTimePoint;
import de.aristaflow.adept2.model.timemodel.GuardedInterval;
import de.aristaflow.adept2.model.timemodel.TimeModel;
import de.aristaflow.adept2.model.timemodel.TimeModelOperations;
import de.aristaflow.adept2.model.timemodel.tcn.TCNInstanceTimeModel;
import de.aristaflow.adept2.model.timemodel.tcn.cstnuImpl.CSTNUInstanceTimeModel;
import de.aristaflow.adept2.model.timemodel.tcn.cstnuImpl.CSTNUTemplateTimeModel;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.TCNAlgorithms;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.Calendar;

public class DefaultTimeModelOperations
implements TimeModelOperations {
    @Override
    public int compare(CalendarElement date, long timestamp) {
        return date.getTimeInMillis() < timestamp ? -1 : (date.getTimeInMillis() == timestamp ? 0 : 1);
    }

    @Override
    public int compare(TimePoint timePoint1, TimePoint timePoint2) {
        long t2;
        long t1 = this.convertToSeconds(timePoint1);
        return t1 < (t2 = this.convertToSeconds(timePoint2)) ? -1 : (t1 == t2 ? 0 : 1);
    }

    @Override
    public CalendarElement add(long timeStamp, TimePoint duration) {
        long seconds = this.convertToSeconds(duration);
        long timeInMillis = timeStamp + seconds * 1000L;
        return new DefaultCalendarElement(timeInMillis);
    }

    @Override
    public int compare(CalendarElement date1, CalendarElement date2) {
        return date1.getTimeInMillis() < date2.getTimeInMillis() ? -1 : (date1.getTimeInMillis() == date2.getTimeInMillis() ? 0 : 1);
    }

    @Override
    public long convertToSeconds(TimePoint timePoint) {
        long seconds = 0L;
        if (timePoint.getMonths() != Long.MIN_VALUE) {
            seconds += timePoint.getMonths();
        }
        seconds *= 30L;
        if (timePoint.getDays() != Long.MIN_VALUE) {
            seconds += timePoint.getDays();
        }
        seconds *= 24L;
        if (timePoint.getHours() != Long.MIN_VALUE) {
            seconds += timePoint.getHours();
        }
        seconds *= 60L;
        if (timePoint.getMinutes() != Long.MIN_VALUE) {
            seconds += timePoint.getMinutes();
        }
        seconds *= 60L;
        if (timePoint.getSeconds() != Long.MIN_VALUE) {
            seconds += timePoint.getSeconds();
        }
        return seconds;
    }

    @Override
    public TimePoint convertToTimePoint(TimeDistance value) {
        ArgChecks.checkForNull((Object)value, (String)"value");
        if (value.isInfinity()) {
            return null;
        }
        long months = Long.MIN_VALUE;
        long days = Long.MIN_VALUE;
        long hours = Long.MIN_VALUE;
        long minutes = Long.MIN_VALUE;
        long seconds = 0L;
        boolean hasNotZero = false;
        if (value.getMonths() != 0L) {
            months = value.getMonths();
            hasNotZero = true;
        }
        if (value.getDays() != 0L || hasNotZero) {
            days = value.getDays();
            hasNotZero = true;
        }
        if (value.getHours() != 0L || hasNotZero) {
            hours = value.getHours();
            hasNotZero = true;
        }
        if (value.getMinutes() != 0L || hasNotZero) {
            minutes = value.getMinutes();
            hasNotZero = true;
        }
        if (value.getSeconds() != 0L) {
            seconds = value.getSeconds();
        }
        return new DefaultTimePoint(seconds, minutes, hours, days, months);
    }

    @Override
    public CalendarElement convertToCalendarElement(TimeDistance value) {
        if (value.isInfinity()) {
            return null;
        }
        return new DefaultCalendarElement(value.toMilliseconds());
    }

    public Calendar convertToCalendar(TimeDistance value) {
        if (value.isInfinity()) {
            return null;
        }
        long milliseconds = value.toMilliseconds();
        return this.convertToCalendar(milliseconds);
    }

    private Calendar convertToCalendar(long milliseconds) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(milliseconds);
        return calendar;
    }

    public Calendar convertToCalendar(CalendarElement date) {
        if (date == null) {
            return null;
        }
        return this.convertToCalendar(date.getTimeInMillis());
    }

    @Override
    public TimeDistance secondsToTimeDistance(long v) {
        return new DefaultTimeDistance(v % 60L, v / 60L % 60L, v / 3600L % 24L, v / 86400L, 0L);
    }

    @Override
    public TimeDistance convertToTimeDistance(TimePoint timePoint) {
        return new DefaultTimeDistance(timePoint);
    }

    @Override
    public CalendarElement add(long timeStamp, TimeDistance duration) {
        long timeInMillis = timeStamp + duration.toMilliseconds();
        return new DefaultCalendarElement(timeInMillis);
    }

    @Override
    public TimeDistance millisecondsToTimeDistance(long milliseconds) {
        return new DefaultTimeDistance(milliseconds, 0L, 0L, 0L, 0L, 0L);
    }

    @Override
    public GuardedInterval<TimeDistance> getRestrictableProcessDuration(TimeModel timeModel) {
        if (timeModel instanceof CSTNUTemplateTimeModel) {
            return TCNAlgorithms.getRestrictableDuration((CSTNUTemplateTimeModel)timeModel);
        }
        if (timeModel instanceof TCNInstanceTimeModel) {
            return TCNAlgorithms.getRestrictableDuration((CSTNUInstanceTimeModel)timeModel);
        }
        throw new IllegalArgumentException("Time Model not supported");
    }

    @Override
    public CalendarElement add(CalendarElement timeStamp, TimePoint duration) {
        long seconds = this.convertToSeconds(duration);
        long timeInMillis = timeStamp.getTimeInMillis() + seconds * 1000L;
        return new DefaultCalendarElement(timeInMillis);
    }
}

