/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.defaultimplementation;

import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.viewer.ModelViewer;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemporalNode;
import de.aristaflow.adept2.model.processmodel.TemporalTemplate;
import de.aristaflow.adept2.model.processmodel.timemodel.FixedDate;
import de.aristaflow.adept2.model.processmodel.timemodel.FixedDateUpdateProcedureData;
import de.aristaflow.adept2.model.processmodel.timemodel.updatehandlers.DataElementUpdateTrigger;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TimeModelTools {
    public static final String COMPLETION_FIXED_DATE_FIELD = "completionFixedDate";
    public static final String START_FIXED_DATE_FIELD = "startFixedDate";
    protected static Logger logger = LoggerTools.getLogger(TimeModelTools.class);

    public static Map<Integer, List<URI>> createUpdateTriggerMapping(TemporalTemplate template) {
        URI baseURI = ProcessElementIdentifierTools.getTemplateIdentifier((Template)template, (String)"localhost");
        HashMap<Integer, List<URI>> updateTriggers = new HashMap<Integer, List<URI>>();
        Set<TemporalNode> nodes = template.getTemporalNodes();
        for (TemporalNode node : nodes) {
            URI identifier;
            List<Integer> triggerNodes;
            FixedDate fixedDate = node.getStartFixedDate();
            if (fixedDate != null) {
                triggerNodes = TimeModelTools.createUpdateTriggers(template, fixedDate);
                identifier = ProcessElementIdentifierTools.getNodeIdentifier((URI)baseURI, (Node)node, (String)START_FIXED_DATE_FIELD);
                TimeModelTools.addTriggers(updateTriggers, triggerNodes, identifier);
            }
            if ((fixedDate = node.getCompletionFixedDate()) == null) continue;
            triggerNodes = TimeModelTools.createUpdateTriggers(template, fixedDate);
            identifier = ProcessElementIdentifierTools.getNodeIdentifier((URI)baseURI, (Node)node, (String)COMPLETION_FIXED_DATE_FIELD);
            TimeModelTools.addTriggers(updateTriggers, triggerNodes, identifier);
        }
        return updateTriggers;
    }

    private static void addTriggers(Map<Integer, List<URI>> updateTriggers, List<Integer> triggerNodes, URI identifier) {
        for (Integer i : triggerNodes) {
            List<URI> list = updateTriggers.get(i);
            if (list == null) {
                list = new ArrayList<URI>();
                updateTriggers.put(i, list);
            }
            list.add(identifier);
        }
    }

    private static List<Integer> createUpdateTriggers(TemporalTemplate template, FixedDate fixedDate) {
        PluginData[] triggerList;
        ArrayList<Integer> triggerNodes = new ArrayList<Integer>();
        FixedDateUpdateProcedureData updateProcedure = fixedDate.getFixedDateUpdateProcedure();
        if (updateProcedure != null && (triggerList = updateProcedure.getUpdateTriggerList()) != null) {
            List<Integer> triggers = TimeModelTools.createUpdateTriggers(template, triggerList);
            triggerNodes.addAll(triggers);
        }
        return triggerNodes;
    }

    private static List<Integer> createUpdateTriggers(TemporalTemplate template, PluginData[] triggerList) {
        ArrayList<Integer> triggerNodes = new ArrayList<Integer>();
        PluginData[] pluginDataArray = triggerList;
        int n = triggerList.length;
        int n2 = 0;
        while (n2 < n) {
            PluginData data = pluginDataArray[n2];
            if (data.getPluginID().equals("de.aristaflow.adept2.model.processmodel.timemodel.updatehandlers.DataElementUpdateTrigger")) {
                DataElementUpdateTrigger updateTrigger = (DataElementUpdateTrigger)ModelViewer.createView((Map)data.getPluginData(), DataElementUpdateTrigger.class);
                int dataElementID = updateTrigger.getDataElementID();
                List<Integer> writers = TimeModelTools.getWriters(template, dataElementID);
                triggerNodes.addAll(writers);
            } else {
                logger.log(Level.SEVERE, "Unknown PluginID '%s'!", data.getPluginID());
            }
            ++n2;
        }
        return triggerNodes;
    }

    private static List<Integer> getWriters(TemporalTemplate template, int dataElementID) {
        int id;
        int[] nodeIDs;
        ArrayList<Integer> nodes = new ArrayList<Integer>();
        int[] nArray = nodeIDs = template.getAccessingNodeIDsForDataElement(dataElementID, ActivityConstants.AccessType.WRITE);
        int n = nodeIDs.length;
        int n2 = 0;
        while (n2 < n) {
            id = nArray[n2];
            nodes.add(id);
            ++n2;
        }
        nArray = nodeIDs = template.getAccessingNodeIDsForDataElement(dataElementID, ActivityConstants.AccessType.SYSTEM_WRITE);
        n = nodeIDs.length;
        n2 = 0;
        while (n2 < n) {
            id = nArray[n2];
            nodes.add(id);
            ++n2;
        }
        return nodes;
    }
}

