/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn;

import java.util.Arrays;

public class IterationChain
implements Comparable<IterationChain> {
    private final Iteration[] iterations;
    private int cachedHashCode = Integer.MIN_VALUE;

    public IterationChain(int startNodeID) {
        this.iterations = new Iteration[1];
        this.iterations[0] = new Iteration(startNodeID, 0);
    }

    @Deprecated
    public IterationChain(Iteration[] iterations) {
        this.iterations = iterations;
    }

    public IterationChain subIteration(int startNodeID) {
        Iteration[] it = new Iteration[this.iterations.length + 1];
        System.arraycopy(this.iterations, 0, it, 0, this.iterations.length);
        it[this.iterations.length] = new Iteration(startNodeID, 1);
        return new IterationChain(it);
    }

    public IterationChain incrementIteration() {
        Iteration[] it = new Iteration[this.iterations.length];
        System.arraycopy(this.iterations, 0, it, 0, this.iterations.length);
        Iteration current = it[this.iterations.length - 1];
        it[this.iterations.length - 1] = new Iteration(current.getNodeID(), current.getIteration() + 1);
        return new IterationChain(it);
    }

    public int getIteration() {
        int iteration = 1;
        int i = this.iterations.length - 1;
        while (i >= 1) {
            iteration *= this.iterations[i].getIteration();
            --i;
        }
        return iteration;
    }

    public int hashCode() {
        if (this.cachedHashCode == Integer.MIN_VALUE) {
            this.cachedHashCode = Arrays.hashCode(this.iterations);
        }
        return this.cachedHashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IterationChain) {
            IterationChain other = (IterationChain)obj;
            boolean result = Arrays.equals(this.iterations, other.iterations);
            return result;
        }
        return super.equals(obj);
    }

    public String toString() {
        return Arrays.toString(this.iterations);
    }

    public Iteration[] getIterations() {
        return this.iterations;
    }

    @Override
    public int compareTo(IterationChain other) {
        int compare;
        int anotherVal;
        Iteration[] iter = this.iterations;
        Iteration[] anotherIter = other.iterations;
        if (iter.length > anotherIter.length) {
            return 1;
        }
        if (iter.length < anotherIter.length) {
            return -1;
        }
        int i = 0;
        while (i < iter.length && i < anotherIter.length) {
            if (iter[i] != anotherIter[i]) break;
            ++i;
        }
        if (i >= iter.length && i >= anotherIter.length) {
            return 0;
        }
        Iteration it = iter[i];
        Iteration anotherIt = anotherIter[i];
        int thisVal = it.blockNodeID;
        int n = thisVal < (anotherVal = anotherIt.blockNodeID) ? -1 : (compare = thisVal == anotherVal ? 0 : 1);
        if (compare != 0) {
            return compare;
        }
        thisVal = it.iteration;
        compare = thisVal < (anotherVal = anotherIt.iteration) ? -1 : (thisVal == anotherVal ? 0 : 1);
        return compare;
    }

    public static class Iteration {
        private final int blockNodeID;
        private final int iteration;

        public Iteration(int blockNodeID, int iteration) {
            this.blockNodeID = blockNodeID;
            this.iteration = iteration;
        }

        public int getNodeID() {
            return this.blockNodeID;
        }

        public int getIteration() {
            return this.iteration;
        }

        public int hashCode() {
            return this.blockNodeID << 32 ^ this.iteration;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Iteration) {
                Iteration other = (Iteration)obj;
                return this.blockNodeID == other.blockNodeID && this.iteration == other.iteration;
            }
            return super.equals(obj);
        }

        public String toString() {
            return String.valueOf(this.blockNodeID) + "@" + this.iteration;
        }
    }
}

